/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.tools;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.videolan4j.VideoLan4J;
import sun.misc.Unsafe;

public class Buffers {
    private static final Marker IT = MarkerManager.getMarker((String)Buffers.class.getSimpleName());
    private static final Unsafe UNSAFE;
    private static final long ADDRESS_FIELD_OFFSET;
    private static Function<Integer, ByteBuffer> BUFFER_ALLOCATOR;
    private static Consumer<ByteBuffer> BUFFER_DEALLOCATOR;

    public static void setBufferAllocator(Function<Integer, ByteBuffer> bufferAllocator) {
        BUFFER_ALLOCATOR = bufferAllocator;
    }

    public static void setBufferDeallocator(Consumer<ByteBuffer> bufferDeallocator) {
        BUFFER_DEALLOCATOR = bufferDeallocator;
    }

    public static ByteBuffer alloc(int size) {
        ByteBuffer buffer = BUFFER_ALLOCATOR.apply(size);
        if (!Buffers.isAligned(Buffers.address(buffer))) {
            VideoLan4J.LOGGER.warn(IT, "Buffer address {} with size {} is unalighed, this might cause performance issues", (Object)Buffers.address(buffer), (Object)size);
        }
        return buffer;
    }

    public static void dealloc(ByteBuffer buffer) {
        BUFFER_DEALLOCATOR.accept(buffer);
    }

    static void dealloc1(ByteBuffer buffer) {
    }

    static ByteBuffer alloc1(int size) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(size + 32);
        long address = Buffers.address((Buffer)buffer);
        if (!Buffers.isAligned(address)) {
            int newPosition = (int)(32L - (address & 0x1FL));
            ((Buffer)buffer).position(newPosition);
            size += newPosition;
        }
        ByteBuffer result = (ByteBuffer)((Buffer)buffer).limit(size);
        return result.slice().order(ByteOrder.nativeOrder());
    }

    public static long address(ByteBuffer buffer) {
        return UNSAFE.getLong(buffer, ADDRESS_FIELD_OFFSET);
    }

    public static boolean isAligned(long address) {
        return (address & 0x1FL) == 0L;
    }

    public static long address(Buffer buffer) {
        return UNSAFE.getLong(buffer, ADDRESS_FIELD_OFFSET);
    }

    static {
        BUFFER_ALLOCATOR = Buffers::alloc1;
        BUFFER_DEALLOCATOR = Buffers::dealloc1;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
            ADDRESS_FIELD_OFFSET = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

