/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.list;

import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_list_player_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.player.list.ControlsApi;
import org.watermedia.videolan4j.player.list.EventApi;
import org.watermedia.videolan4j.player.list.ListApi;
import org.watermedia.videolan4j.player.list.MediaPlayerApi;
import org.watermedia.videolan4j.player.list.StatusApi;
import org.watermedia.videolan4j.support.eventmanager.TaskExecutor;

public final class MediaListPlayer {
    protected final libvlc_instance_t libvlcInstance;
    private libvlc_media_list_player_t mediaListPlayerInstance;
    private final TaskExecutor executor = new TaskExecutor();
    private Object userData;
    private final ControlsApi controlsApi;
    private final EventApi eventApi;
    private final ListApi listApi;
    private final MediaPlayerApi mediaPlayerApi;
    private final StatusApi statusApi;

    public MediaListPlayer(libvlc_instance_t libvlcInstance) {
        this.libvlcInstance = libvlcInstance;
        this.mediaListPlayerInstance = this.newNativeMediaListPlayer();
        this.controlsApi = new ControlsApi(this);
        this.eventApi = new EventApi(this);
        this.listApi = new ListApi(this);
        this.mediaPlayerApi = new MediaPlayerApi(this);
        this.statusApi = new StatusApi(this);
    }

    private libvlc_media_list_player_t newNativeMediaListPlayer() {
        libvlc_media_list_player_t result = LibVlc.libvlc_media_list_player_new(this.libvlcInstance);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Failed to get a new native media list player instance");
    }

    public ControlsApi controls() {
        return this.controlsApi;
    }

    public EventApi events() {
        return this.eventApi;
    }

    public ListApi list() {
        return this.listApi;
    }

    public MediaPlayerApi mediaPlayer() {
        return this.mediaPlayerApi;
    }

    public StatusApi status() {
        return this.statusApi;
    }

    public Object userData() {
        return this.userData;
    }

    public void userData(Object userData) {
        this.userData = userData;
    }

    public void submit(Runnable r) {
        this.executor.submit(r);
    }

    public void release() {
        this.executor.release();
        this.onBeforeRelease();
        this.controlsApi.release();
        this.eventApi.release();
        this.listApi.release();
        this.mediaPlayerApi.release();
        this.statusApi.release();
        LibVlc.libvlc_media_list_player_release(this.mediaListPlayerInstance);
        this.onAfterRelease();
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }

    public libvlc_media_list_player_t mediaListPlayerInstance() {
        return this.mediaListPlayerInstance;
    }
}

