/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.base;

import java.util.HashMap;
import java.util.Map;

public enum MediaPlayerRole {
    NONE(0),
    MUSIC(1),
    VIDEO(2),
    COMMUNICATION(3),
    GAME(4),
    NOTIFICATION(5),
    ANIMATION(6),
    PRODUCTION(7),
    ACCESSIBILITY(8),
    TEST(9);

    private static final Map<Integer, MediaPlayerRole> INT_MAP;
    private final int intValue;

    public static MediaPlayerRole role(int intValue) {
        return INT_MAP.get(intValue);
    }

    private MediaPlayerRole(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    static {
        INT_MAP = new HashMap<Integer, MediaPlayerRole>();
        for (MediaPlayerRole role : MediaPlayerRole.values()) {
            INT_MAP.put(role.intValue, role);
        }
    }
}

