/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.player.videolan;

import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.player.videolan.BasePlayer;
import org.watermedia.api.render.RenderAPI;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferCleanupCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormat;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormatCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.RenderCallback;
import org.watermedia.videolan4j.tools.Chroma;

public class VideoPlayer
extends BasePlayer
implements RenderCallback,
BufferFormatCallback,
BufferCleanupCallback {
    private static final Marker IT = MarkerManager.getMarker((String)"VideoPlayer");
    private int width = 1;
    private int height = 1;
    private int size = this.width * this.height * 4;
    private boolean refresh = false;
    private boolean first = true;
    private final int texture;
    private final Semaphore semaphore = new Semaphore(1);
    private final Executor renderExecutor;
    private ByteBuffer[] buffers;

    public VideoPlayer(Executor renderExecutor) {
        this(null, renderExecutor);
    }

    public VideoPlayer(MediaPlayerFactory factory, Executor renderExecutor) {
        this.texture = RenderAPI.createTexture();
        this.renderExecutor = renderExecutor;
        this.init(factory, this, this, this);
        if (this.raw() == null) {
            RenderAPI.deleteTexture(this.texture);
        } else {
            this.raw().mediaPlayer().videoSurface().getVideoSurface().setSemaphore(this.semaphore);
        }
    }

    @Override
    public void display(MediaPlayer mediaPlayer, ByteBuffer[] nativeBuffers, BufferFormat bufferFormat) {
        this.refresh = true;
    }

    @Override
    public void allocatedBuffers(ByteBuffer[] buffers) {
        this.buffers = buffers;
        this.first = true;
    }

    @Override
    public void cleanupBuffers(ByteBuffer[] buffers) {
        this.buffers = null;
    }

    @Override
    public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
        this.width = sourceWidth;
        this.height = sourceHeight;
        this.size = sourceWidth * sourceHeight * 4;
        this.first = true;
        return new BufferFormat(Chroma.RGBA, sourceWidth, sourceHeight);
    }

    public int size() {
        return this.size;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int preRender() {
        RenderAPI.bindTexture(this.texture);
        try {
            if (this.semaphore.tryAcquire(1L, TimeUnit.SECONDS)) {
                if (this.refresh && this.buffers != null && this.buffers.length > 0) {
                    RenderAPI.uploadBuffer(this.buffers[0], this.texture, 6408, this.width, this.height, this.first);
                    this.first = false;
                    this.refresh = false;
                }
                this.semaphore.release();
            } else {
                WaterMedia.LOGGER.error(IT, "{} took more than 1 second to synchronize with native threads", (Object)this, (Object)new InterruptedByTimeoutException());
                if (this.first) {
                    throw new IllegalStateException("Cannot handle interruption");
                }
                this.release();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        RenderAPI.bindTexture(0);
        return this.texture;
    }

    public int texture() {
        return this.texture;
    }

    public Dimension dimension() {
        if (this.raw() == null) {
            return null;
        }
        return this.raw().mediaPlayer().video().videoDimension();
    }

    @Override
    public void release() {
        this.renderExecutor.execute(() -> RenderAPI.deleteTexture(this.texture));
        super.release();
    }
}

