/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import me.srrapero720.waterframes.common.block.data.DisplayData;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.DataListSyncPacket;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import me.srrapero720.waterframes.common.screens.styles.ScreenStyles;
import me.srrapero720.waterframes.common.screens.widgets.WidgetPlaylistEntry;
import me.srrapero720.waterframes.common.screens.widgets.WidgetURLTextField;
import net.minecraft.ChatFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckButtonIcon;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;

public class PlayListScreen
extends GuiLayer {
    protected static final int WIDTH = 225;
    protected static final int HEIGHT = 210;
    public final DisplayTile tile;
    private final GuiButtonIcon save;
    public LinkedList<URI> uris;
    public final GuiScrollY scrollY;
    public final GuiParent list;
    public final WidgetURLTextField urlTextField;
    public final GuiButtonIcon addButton;
    public final GuiButtonIcon prevButton;
    public final GuiButtonIcon nextButton;
    public final GuiCheckButtonIcon playButton;

    public PlayListScreen(DisplayTile tile) {
        super("display_screen", 225, 210);
        this.setFlow((GuiFlow)GuiFlow.STACK_Y);
        this.tile = tile;
        this.uris = new LinkedList();
        this.scrollY = new GuiScrollY("parent_scroll");
        this.list = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        this.scrollY.addControl((GuiControl)this.list);
        this.setSpacing(4);
        for (URI uri : tile.data.uris) {
            this.list.addControl((GuiControl)new WidgetPlaylistEntry(tile, this.uris, uri));
        }
        this.urlTextField = new WidgetURLTextField(null);
        this.addButton = new GuiButtonIcon("add", IconStyles.ADD, mouse -> {
            if (this.urlTextField.isUrlValid()) {
                this.list.addControl((GuiControl)new WidgetPlaylistEntry(tile, this.uris, this.urlTextField.getURI()));
                this.urlTextField.setText("");
                this.reflow();
            }
        });
        this.save = new GuiButtonIcon("save", IconStyles.SAVE, click -> DisplayNetwork.sendServer(new DataListSyncPacket(tile.m_58899_(), DisplayData.build(this, tile))));
        this.playButton = new GuiCheckButtonIcon("playback", IconStyles.PLAY, IconStyles.PAUSE, tile.data.paused, button -> tile.setPause(true, !tile.data.paused));
        this.nextButton = new GuiButtonIcon("next", IconStyles.NEXT_MEDIA, button -> tile.nextUri(true));
        this.prevButton = new GuiButtonIcon("prev", IconStyles.BACK_MEDIA, button -> tile.prevUri(true));
    }

    public LinkedList<URI> getUris() {
        LinkedList<URI> uris = new LinkedList<URI>();
        for (GuiChildControl control : this.list) {
            GuiControl guiControl = control.control;
            if (!(guiControl instanceof WidgetPlaylistEntry)) continue;
            WidgetPlaylistEntry element = (WidgetPlaylistEntry)guiControl;
            uris.add(element.uri);
        }
        return uris;
    }

    public void create() {
        this.add((GuiControl)new GuiParent("", (GuiFlow)GuiFlow.STACK_X, Align.STRETCH).add(this.prevButton.setSquared(true).setDim(1, 18).setExpandableX()).add(this.playButton.setSquared(true).setDim(1, 18).setExpandableX()).add(this.nextButton.setSquared(true).setDim(1, 18).setExpandableX()));
        this.add((GuiControl)this.scrollY.setExpandable());
        this.add((GuiControl)new GuiParent((GuiFlow)GuiFlow.STACK_X).add(this.urlTextField.setDim(1, 12).setExpandableX()).add((GuiControl)this.addButton.setDim(12, 12)).add((GuiControl)this.save.setDim(12, 12)));
    }

    public void tick() {
        super.tick();
        if (!this.isClient()) {
            return;
        }
        if (this.playButton.getState() != this.tile.data.paused) {
            this.playButton.setState(this.tile.data.paused);
            this.playButton.setTooltip(Collections.singletonList(PlayListScreen.translatable((String)"waterframes.gui.playback", (Object[])new Object[]{ChatFormatting.AQUA + PlayListScreen.translate((String)("waterframes.common." + (this.playButton.value ? "paused" : "playing")))})));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return ScreenStyles.SCREEN_BACKGROUND;
    }

    @OnlyIn(value=Dist.CLIENT)
    public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
        return ScreenStyles.SCREEN_BORDER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiStyle getStyle() {
        return ScreenStyles.DISPLAYS;
    }
}

