/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import org.valkyrienskies.physics_api.ShapeInUseException;
import org.valkyrienskies.physics_api.SphereShapeReference;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api_krunch.KrunchShapeReference;

class KrunchNativeSphereShapeReference
implements SphereShapeReference,
KrunchShapeReference {
    private long shapeAddress;
    private static final long DELETED_SHAPE_ADDRESS = -1L;

    protected KrunchNativeSphereShapeReference(long shapeAddress) {
        this.shapeAddress = shapeAddress;
    }

    @Override
    public void close() {
        this.ensureNotDeleted();
        boolean deleteSuccessful = KrunchNativeSphereShapeReference.deleteSphereShape(this.shapeAddress);
        if (!deleteSuccessful) {
            throw new ShapeInUseException("Delete box shape failed! This shape is currently in use!");
        }
        this.shapeAddress = -1L;
    }

    protected void finalize() {
        if (this.shapeAddress != -1L) {
            this.close();
        }
    }

    @Override
    public long getShapeShapeAddress() {
        this.ensureNotDeleted();
        return this.shapeAddress;
    }

    @Override
    public double getRadius() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        double[] radiusOut = new double[1];
        boolean success = KrunchNativeSphereShapeReference.getRadius(this.shapeAddress, radiusOut);
        if (!success) {
            throw new IllegalStateException("Call to getRadius() failed");
        }
        return radiusOut[0];
    }

    @Override
    public void setRadius(double radius) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        boolean success = KrunchNativeSphereShapeReference.setRadius(this.shapeAddress, radius);
        if (!success) {
            throw new IllegalStateException("Call to setRadius() failed");
        }
    }

    @Override
    public boolean hasBeenDeleted() {
        return this.shapeAddress == -1L;
    }

    private void ensureNotDeleted() {
        if (this.hasBeenDeleted()) {
            throw new UsingDeletedReferenceException("This shape has been deleted!");
        }
    }

    private static native boolean getRadius(long var0, double[] var2);

    private static native boolean setRadius(long var0, double var2);

    private static native boolean deleteSphereShape(long var0);
}

