/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.physics_api.PhysicsWorldReference;
import org.valkyrienskies.physics_api_krunch.KrunchNativePhysicsWorldIsland;
import org.valkyrienskies.physics_api_krunch.KrunchNativePhysicsWorldReference;

public class KrunchNativePhysicsWorldIslandEncoder {
    public static List<PhysicsWorldReference.PhysicsWorldIsland> decodeIslands(@NotNull ByteBuffer readBuffer, @NotNull KrunchNativePhysicsWorldReference physicsWorldReference) {
        int islandSize = readBuffer.getInt();
        ArrayList<PhysicsWorldReference.PhysicsWorldIsland> islands = new ArrayList<PhysicsWorldReference.PhysicsWorldIsland>();
        for (int islandId = 0; islandId < islandSize; ++islandId) {
            KrunchNativePhysicsWorldIsland island = KrunchNativePhysicsWorldIslandEncoder.decodeIsland(readBuffer, physicsWorldReference, islandId);
            islands.add(island);
        }
        return islands;
    }

    private static KrunchNativePhysicsWorldIsland decodeIsland(@NotNull ByteBuffer readBuffer, @NotNull KrunchNativePhysicsWorldReference physicsWorldReference, int islandId) {
        int bodiesSize = readBuffer.getInt();
        IntArrayList bodies = new IntArrayList(bodiesSize);
        for (int i2 = 0; i2 < bodiesSize; ++i2) {
            int bodyId = readBuffer.getInt();
            bodies.add(bodyId);
        }
        return new KrunchNativePhysicsWorldIsland(islandId, (IntList)bodies, physicsWorldReference);
    }
}

