/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server.network;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSGameConfig;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class MixinServerGamePacketListenerImpl {
    @Shadow
    public ServerPlayer f_9743_;
    @Shadow
    private int f_9767_;
    @Shadow
    private int f_9746_;
    @Shadow
    private Vec3 f_9766_;
    @Shadow
    private int f_9735_;
    @Shadow
    @Final
    private MinecraftServer f_9745_;

    @Shadow
    public abstract void m_9829_(Packet<?> var1);

    @ModifyExpressionValue(at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;aboveGroundTickCount:I", ordinal=0)}, method={"tick"})
    private int noFlyKick(int original) {
        if (VSGameConfig.SERVER.getEnableMovementChecks()) {
            return original;
        }
        return 0;
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;subtract(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;")}, method={"handleUseItemOn"})
    private Vec3 skipDistanceCheck2(Vec3 instance, Vec3 vec3, Operation<Vec3> subtract) {
        return VSGameUtilsKt.toWorldCoordinates(this.f_9743_.m_9236_(), (Vec3)subtract.call(new Object[]{instance, vec3}));
    }

    @WrapOperation(method={"handleMovePlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;isSingleplayerOwner()Z")}, require=0)
    private boolean shouldSkipMoveCheck1(ServerGamePacketListenerImpl instance, Operation<Boolean> isSinglePlayerOwner) {
        return !VSGameConfig.SERVER.getEnableMovementChecks();
    }

    @WrapOperation(method={"handleMoveVehicle"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;isSingleplayerOwner()Z")}, require=0)
    private boolean shouldSkipMoveCheck2(ServerGamePacketListenerImpl instance, Operation<Boolean> isSinglePlayerOwner) {
        return !VSGameConfig.SERVER.getEnableMovementChecks();
    }

    @WrapOperation(method={"handleMovePlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;isCreative()Z")}, require=0)
    private boolean shouldSkipMoveCheck(ServerPlayerGameMode instance, Operation<Boolean> isSinglePlayerOwner) {
        return !VSGameConfig.SERVER.getEnableMovementChecks();
    }

    @Inject(method={"teleport(DDDFFLjava/util/Set;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void transformTeleport(double x2, double y2, double z2, float yaw, float pitch, Set<RelativeMovement> relativeSet, CallbackInfo ci2) {
        if (!VSGameConfig.SERVER.getTransformTeleports()) {
            return;
        }
        BlockPos blockPos = BlockPos.m_274561_((double)x2, (double)y2, (double)z2);
        ServerShip ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)this.f_9743_.m_9236_(), blockPos);
        if (ship != null) {
            Vector3d pos = new Vector3d(x2, y2, z2);
            ship.getShipToWorld().transformPosition(pos);
            this.f_9766_ = VectorConversionsMCKt.toMinecraft((Vector3dc)pos);
            if (++this.f_9767_ == Integer.MAX_VALUE) {
                this.f_9767_ = 0;
            }
            this.f_9735_ = this.f_9746_;
            this.f_9743_.m_19890_(pos.x, pos.y, pos.z, yaw, pitch);
            this.m_9829_((Packet<?>)new ClientboundPlayerPositionPacket(pos.x, pos.y, pos.z, yaw, pitch, Collections.emptySet(), this.f_9767_));
            ci2.cancel();
        }
    }

    @Inject(method={"onDisconnect"}, at={@At(value="HEAD")})
    void onDisconnect(Component reason, CallbackInfo ci2) {
        ServerShipWorldCore world = VSGameUtilsKt.getShipObjectWorld(this.f_9745_);
        if (world != null) {
            world.onDisconnect(VSGameUtilsKt.getPlayerWrapper((Player)this.f_9743_));
        }
    }
}

