/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create.block;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.redstone.contact.RedstoneContactBlock;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.TickPriority;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={RedstoneContactBlock.class})
public abstract class MixinRedstoneContactBlock
extends WrenchableDirectionalBlock {
    private static Map<Pair<Level, BlockPos>, BlockPos> contactCache = new HashMap<Pair<Level, BlockPos>, BlockPos>();
    @Shadow
    @Final
    public static BooleanProperty POWERED;
    @Unique
    private static final double MAX_ALIGNMENT_ANGLE = -0.93972176;

    public MixinRedstoneContactBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"onRemove"}, at={@At(value="HEAD")})
    private void injectOnRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving, CallbackInfo ci2) {
        if (state.m_60734_() == this && newState.m_60795_()) {
            Pair key = Pair.of((Object)worldIn, (Object)pos);
            if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && contactCache.containsKey(key)) {
                worldIn.m_186464_(contactCache.get(key), (Block)AllBlocks.REDSTONE_CONTACT.get(), 2, TickPriority.NORMAL);
                contactCache.remove(key);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE_ASSIGN", shift=At.Shift.BY, by=2, target="Lcom/simibubi/create/content/redstone/contact/RedstoneContactBlock;hasValidContact(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random, CallbackInfo ci2, boolean hasValidContact) {
        if (VSGameUtilsKt.isBlockInShipyard((Level)worldIn, pos)) {
            Pair key = Pair.of((Object)worldIn, (Object)pos);
            if (!hasValidContact && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && contactCache.containsKey(key)) {
                worldIn.m_186464_(contactCache.get(key), (Block)AllBlocks.REDSTONE_CONTACT.get(), 2, TickPriority.NORMAL);
                contactCache.remove(key);
            }
            worldIn.m_186464_(pos, (Block)AllBlocks.REDSTONE_CONTACT.get(), 2, TickPriority.NORMAL);
        }
    }

    @Unique
    private static boolean hasContact(Level world, Ship ship, Vector3d searchPos, Direction direction, Ship shipItr) {
        BlockState blockState = world.m_8055_(BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)searchPos)));
        if (AllBlocks.REDSTONE_CONTACT.has(blockState)) {
            double dotAngle;
            Vector3d worldDirection = VectorConversionsMCKt.toJOML(Vec3.m_82528_((Vec3i)direction.m_122436_()));
            Vector3d targetDirection = VectorConversionsMCKt.toJOML(Vec3.m_82528_((Vec3i)((Direction)blockState.m_61143_((Property)f_52588_)).m_122436_()));
            if (ship != null) {
                ship.getShipToWorld().transformDirection((Vector3dc)worldDirection, worldDirection);
            }
            if (shipItr != null) {
                shipItr.getShipToWorld().transformDirection((Vector3dc)targetDirection, targetDirection);
            }
            return (dotAngle = worldDirection.dot((Vector3dc)targetDirection)) < -0.93972176;
        }
        return false;
    }

    @Inject(method={"hasValidContact"}, at={@At(value="RETURN")}, cancellable=true)
    private static void injectHasValidContact(LevelAccessor world, BlockPos pos, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        boolean result = false;
        Level worldLevel = (Level)world;
        BlockState blockState = world.m_8055_(pos.m_121945_(direction));
        if (AllBlocks.REDSTONE_CONTACT.has(blockState)) {
            cir.setReturnValue((Object)(blockState.m_61143_((Property)f_52588_) == direction.m_122424_() ? 1 : 0));
        } else {
            Iterator<Ship> ships;
            AABB searchAABB = new AABB(pos.m_121945_(direction));
            Vector3d searchPos = VectorConversionsMCKt.toJOML(Vec3.m_82512_((Vec3i)pos.m_121945_(direction)));
            Ship ship = VSGameUtilsKt.getShipManagingPos(worldLevel, pos);
            if (VSGameUtilsKt.isBlockInShipyard(worldLevel, pos) && ship != null) {
                Vector3d tempVec = VectorConversionsMCKt.toJOML(Vec3.m_82512_((Vec3i)pos.m_121945_(direction)));
                searchPos = ship.getShipToWorld().transformPosition((Vector3dc)tempVec, new Vector3d());
                ship.getShipToWorld().transformPosition((Vector3dc)tempVec, tempVec);
                double bounds = 0.25;
                searchAABB = new AABB(tempVec.x - bounds, tempVec.y - bounds, tempVec.z - bounds, tempVec.x + bounds, tempVec.y + bounds, tempVec.z + bounds);
                result = MixinRedstoneContactBlock.hasContact(worldLevel, ship, searchPos, direction, null);
            }
            if ((ships = VSGameUtilsKt.getShipsIntersecting(worldLevel, searchAABB).iterator()).hasNext() && !result) {
                do {
                    Vector3d newSearchPos;
                    Ship shipItr;
                    if ((shipItr = ships.next()) == ship || !(result = MixinRedstoneContactBlock.hasContact(worldLevel, ship, newSearchPos = shipItr.getWorldToShip().transformPosition((Vector3dc)searchPos, new Vector3d()), direction, shipItr))) continue;
                    searchPos = newSearchPos;
                } while (ships.hasNext() && !result);
            }
            if (result) {
                contactCache.put((Pair<Level, BlockPos>)Pair.of((Object)worldLevel, (Object)pos), BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)searchPos)));
                world.m_186464_(BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)searchPos)), (Block)AllBlocks.REDSTONE_CONTACT.get(), 2, TickPriority.NORMAL);
            }
            cir.setReturnValue((Object)result);
        }
    }
}

