/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create;

import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.AirFlowParticle;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.IExtendedAirCurrentSource;

@Mixin(value={AirFlowParticle.class})
public abstract class MixinAirFlowParticle
extends SimpleAnimatedParticle {
    @Shadow
    @Final
    private IAirCurrentSource source;

    protected MixinAirFlowParticle(ClientLevel level, double x2, double y2, double z2, SpriteSet sprites, float gravity) {
        super(level, x2, y2, z2, sprites, gravity);
    }

    @Unique
    private Ship getShip() {
        IAirCurrentSource iAirCurrentSource = this.source;
        if (iAirCurrentSource instanceof IExtendedAirCurrentSource) {
            IExtendedAirCurrentSource se2 = (IExtendedAirCurrentSource)iAirCurrentSource;
            return se2.getShip();
        }
        if (this.source.getAirCurrentWorld() != null) {
            return VSGameUtilsKt.getShipManagingPos(this.source.getAirCurrentWorld(), this.source.getAirCurrentPos());
        }
        return null;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;contains(DDD)Z"))
    private boolean redirectBounds(AABB instance, double x2, double y2, double z2) {
        AirCurrent current = this.source.getAirCurrent();
        Level level = this.source.getAirCurrentWorld();
        if (current != null && level != null) {
            return VSGameUtilsKt.transformAabbToWorld(level, instance).m_82393_(x2, y2, z2);
        }
        return instance.m_82393_(x2, y2, z2);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/foundation/utility/VecHelper;getCenterOf(Lnet/minecraft/core/Vec3i;)Lnet/minecraft/world/phys/Vec3;"), allow=1)
    private Vec3 redirectGetCenterOf(Vec3i pos) {
        Ship ship = this.getShip();
        Vec3 result = VecHelper.getCenterOf((Vec3i)pos);
        if (ship != null) {
            Vector3d tempVec = new Vector3d();
            ship.getTransform().getShipToWorld().transformPosition(result.f_82479_, result.f_82480_, result.f_82481_, tempVec);
            result = VectorConversionsMCKt.toMinecraft((Vector3dc)tempVec);
        }
        return result;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;atLowerCornerOf(Lnet/minecraft/core/Vec3i;)Lnet/minecraft/world/phys/Vec3;"), allow=1)
    private Vec3 redirectToLowerCorner(Vec3i pos) {
        Vec3 result = Vec3.m_82528_((Vec3i)pos);
        Ship ship = this.getShip();
        if (ship != null) {
            Vector3d tempVec = new Vector3d();
            ship.getTransform().getShipToWorld().transformDirection(result.f_82479_, result.f_82480_, result.f_82481_, tempVec);
            result = VectorConversionsMCKt.toMinecraft((Vector3dc)tempVec);
        }
        return result;
    }
}

