/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.shipyard_entities;

import net.minecraft.core.SectionPos;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.phys.AABB;
import org.joml.primitives.AABBdc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixinducks.world.OfLevel;
import org.valkyrienskies.mod.mixinducks.world.OfShip;

@Mixin(value={EntitySectionStorage.class})
public abstract class MixinEntitySectionStorage
implements OfLevel {
    @Unique
    private Level level;
    @Unique
    private boolean loopingShips = false;

    @Shadow
    public abstract void m_188362_(AABB var1, AbortableIterationConsumer<EntitySection<?>> var2);

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
    }

    @Inject(method={"createSection"}, at={@At(value="RETURN")})
    void onSectionCreate(long l2, CallbackInfoReturnable<EntitySection<Entity>> cir) {
        ((OfShip)cir.getReturnValue()).setShip(VSGameUtilsKt.getShipManagingPos(this.level, SectionPos.m_123213_((long)l2), SectionPos.m_123230_((long)l2)));
    }

    @Inject(method={"forEachAccessibleNonEmptySection"}, at={@At(value="HEAD")})
    void shipSections(AABB aABB, AbortableIterationConsumer<EntitySection<?>> abortableIterationConsumer, CallbackInfo ci2) {
        if (this.level != null && !this.loopingShips) {
            this.loopingShips = true;
            VSGameUtilsKt.getShipsIntersecting(this.level, aABB).forEach(ship -> {
                AABB transformedAABB = VectorConversionsMCKt.toMinecraft((AABBdc)VectorConversionsMCKt.toJOML(aABB).transform(ship.getWorldToShip()));
                try {
                    this.m_188362_(transformedAABB, abortableIterationConsumer);
                }
                catch (IllegalArgumentException ex2) {
                    ex2.printStackTrace();
                }
            });
            this.loopingShips = false;
        }
    }
}

