/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.networking;

import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.reflect.KProperty;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.networking.NetworkChannel;
import org.valkyrienskies.core.impl.networking.PacketType;
import org.valkyrienskies.core.impl.networking.impl.PacketRequestUdp;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u0001:\u0001?B\u001f\u0012\u0006\u00106\u001a\u000205\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b=\u0010>J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\u00020\u00128\u0007\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R@\u0010\u0019\u001a.\u0012\b\u0012\u0006*\u00020\u00180\u0018\u0012\b\u0012\u0006*\u00020\u00020\u0002*\u0016\u0012\b\u0012\u0006*\u00020\u00180\u0018\u0012\b\u0012\u0006*\u00020\u00020\u00020\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001f\u001a\u00020\u001e8\u0007\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010\u001dR0\u0010,\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020*0)j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020*`+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0014\u00102\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00104\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00103R\u0017\u00106\u001a\u0002058\u0007\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\u0014\u0010;\u001a\u00020:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<"}, d2={"Lorg/valkyrienskies/core/impl/networking/UdpServerImpl;", "", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "player", "", "disconnect", "(Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "Lorg/valkyrienskies/core/impl/networking/impl/PacketRequestUdp;", "packet", "", "prepareIdentifier", "(Lorg/valkyrienskies/core/apigame/world/IPlayer;Lorg/valkyrienskies/core/impl/networking/impl/PacketRequestUdp;)Ljava/lang/Long;", "run", "()V", "Lio/netty/buffer/ByteBuf;", "buf", "sendToClient", "(Lio/netty/buffer/ByteBuf;Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "channel", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "getChannel", "()Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "Lcom/google/common/collect/HashBiMap;", "Ljava/net/SocketAddress;", "connections", "Lcom/google/common/collect/HashBiMap;", "", "failedConnectionsInRow", "I", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "fallback", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "getFallback", "()Lorg/valkyrienskies/core/impl/networking/PacketType;", "Lit/unimi/dsi/fastutil/longs/Long2ObjectArrayMap;", "identification", "Lit/unimi/dsi/fastutil/longs/Long2ObjectArrayMap;", "lastPacketPrint", "J", "packetCount", "Ljava/util/HashMap;", "Ljavax/crypto/SecretKey;", "Lkotlin/collections/b;", "playerSecrets", "Ljava/util/HashMap;", "", "recvBuffer", "[B", "Ljava/net/DatagramPacket;", "recvPacket", "Ljava/net/DatagramPacket;", "sendPacket", "Ljava/net/DatagramSocket;", "socket", "Ljava/net/DatagramSocket;", "getSocket", "()Ljava/net/DatagramSocket;", "Ljava/lang/Thread;", "thread", "Ljava/lang/Thread;", "<init>", "(Ljava/net/DatagramSocket;Lorg/valkyrienskies/core/impl/networking/NetworkChannel;Lorg/valkyrienskies/core/impl/networking/PacketType;)V", "Companion"})
public final class UdpServerImpl {
    public static final Companion Companion = new Companion(null);
    private final DatagramSocket socket;
    private final NetworkChannel channel;
    private final PacketType fallback;
    private final Thread thread;
    private final byte[] recvBuffer;
    private final DatagramPacket recvPacket;
    private final DatagramPacket sendPacket;
    private final HashBiMap<SocketAddress, IPlayer> connections;
    private int failedConnectionsInRow;
    private final Long2ObjectArrayMap<IPlayer> identification;
    private final HashMap<IPlayer, SecretKey> playerSecrets;
    private int packetCount;
    private long lastPacketPrint;
    public static final int PACKET_SIZE = 508;
    private static final Logger logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.networking.UdpServerImpl$Companion.$$delegatedProperties[0]);

    public UdpServerImpl(DatagramSocket socket, NetworkChannel channel, PacketType fallback) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"");
        this.socket = socket;
        this.channel = channel;
        this.fallback = fallback;
        this.thread = new Thread(this::run);
        this.recvBuffer = new byte[508];
        this.recvPacket = new DatagramPacket(this.recvBuffer, 508);
        this.sendPacket = new DatagramPacket(new byte[508], 508);
        this.connections = HashBiMap.create();
        this.identification = new Long2ObjectArrayMap();
        this.playerSecrets = new HashMap();
        this.lastPacketPrint = System.currentTimeMillis();
        this.channel.setRawSendToClient((Function2<? super ByteBuf, ? super IPlayer, Unit>)((Function2)new Function2<ByteBuf, IPlayer, Unit>((Object)this){

            public final void invoke(ByteBuf p0, IPlayer p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"");
                ((UdpServerImpl)this.receiver).sendToClient(p0, p1);
            }
        }));
        this.thread.start();
        this.socket.setSendBufferSize(30480);
        this.socket.setReceiveBufferSize(30480);
    }

    @JvmName(name="getSocket")
    public final DatagramSocket getSocket() {
        return this.socket;
    }

    @JvmName(name="getChannel")
    public final NetworkChannel getChannel() {
        return this.channel;
    }

    @JvmName(name="getFallback")
    public final PacketType getFallback() {
        return this.fallback;
    }

    private final void sendToClient(ByteBuf buf, IPlayer player) {
        if (this.connections.inverse().get((Object)player) == null) {
            this.fallback.sendToClient(buf, player);
        } else {
            int n2 = this.packetCount;
            this.packetCount = n2 + 1;
            if (this.lastPacketPrint + (long)1000 < System.currentTimeMillis()) {
                UdpServerImpl.Companion.getLogger().trace("Sended " + this.packetCount + " UDP packets");
                this.packetCount = 0;
                this.lastPacketPrint = System.currentTimeMillis();
            }
            this.sendPacket.setSocketAddress((SocketAddress)this.connections.inverse().get((Object)player));
            buf.readBytes(this.sendPacket.getData(), 0, buf.writerIndex());
            this.sendPacket.setLength(buf.writerIndex());
            this.socket.send(this.sendPacket);
        }
    }

    private final void run() {
        while (!this.socket.isClosed()) {
            try {
                this.socket.receive(this.recvPacket);
                IPlayer iPlayer = (IPlayer)this.connections.get((Object)this.recvPacket.getSocketAddress());
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.recvBuffer, (int)0, (int)this.recvPacket.getLength());
                if (iPlayer == null) {
                    IPlayer iPlayer2;
                    if (byteBuf.capacity() != 8 || (IPlayer)this.identification.remove(byteBuf.readLong()) == null) continue;
                    HashBiMap<SocketAddress, IPlayer> hashBiMap = this.connections;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"");
                    Map map = (Map)hashBiMap;
                    map.put(this.recvPacket.getSocketAddress(), iPlayer2);
                    this.failedConnectionsInRow = 0;
                    ByteBuf byteBuf2 = Unpooled.buffer((int)16).writeLong(iPlayer2.getUuid().getLeastSignificantBits()).writeLong(iPlayer2.getUuid().getMostSignificantBits());
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"");
                    this.sendToClient(byteBuf2, iPlayer2);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"");
                this.channel.onReceiveServer(byteBuf, iPlayer);
            }
            catch (Exception exception) {
                UdpServerImpl.Companion.getLogger().error("Error in server network thread", (Throwable)exception);
            }
        }
    }

    public final Long prepareIdentifier(IPlayer player, PacketRequestUdp packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"");
        Long l2 = Random.Default.nextLong();
        long l3 = ((Number)l2).longValue();
        boolean bl2 = false;
        byte[] byArray = packet.getSecretKeyBytes();
        try {
            ((Map)this.playerSecrets).put(player, new SecretKeySpec(byArray, "AES"));
        }
        catch (Exception exception) {
            UdpServerImpl.Companion.getLogger().warn("Failed to parse secret from player " + player.getUuid(), (Throwable)exception);
            return null;
        }
        this.identification.put(l3, (Object)player);
        if (this.failedConnectionsInRow == 5) {
            UdpServerImpl.Companion.getLogger().warn("There were 5 cases of failed connections in a row, is the UDP port accessible?");
            UdpServerImpl.Companion.getLogger().info("By disabling UDP this warning shall not be printed anymore.");
        }
        int n2 = this.failedConnectionsInRow;
        this.failedConnectionsInRow = n2 + 1;
        return l2;
    }

    public final void disconnect(IPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"");
        this.connections.inverse().remove((Object)player);
        ((ObjectCollection)this.identification.values()).remove((Object)player);
        this.playerSecrets.remove(player);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u001b\u0010\n\u001a\u00020\u00058CX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t"}, d2={"Lorg/valkyrienskies/core/impl/networking/UdpServerImpl$Companion;", "", "", "PACKET_SIZE", "I", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @JvmName(name="getLogger")
        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

