/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.config;

import com.github.imifou.jsonschema.module.addon.annotation.JsonSchema;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.valkyrienskies.physics_api_krunch.SolverType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b \u0010!R\"\u0010\u0003\u001a\u00020\u00028\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u00020\u00028\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0004\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\"\u0010\r\u001a\u00020\f8\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u00020\f8\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\"\u0010\u0017\u001a\u00020\u00168\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\u00028\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0004\u001a\u0004\b\u001e\u0010\u0006\"\u0004\b\u001f\u0010\b"}, d2={"Lorg/valkyrienskies/core/impl/config/PhysicsConfig;", "", "", "iterations", "I", "getIterations", "()I", "setIterations", "(I)V", "lodDetail", "getLodDetail", "setLodDetail", "", "maxDePenetrationSpeed", "D", "getMaxDePenetrationSpeed", "()D", "setMaxDePenetrationSpeed", "(D)V", "physicsSpeed", "getPhysicsSpeed", "setPhysicsSpeed", "Lorg/valkyrienskies/physics_api_krunch/SolverType;", "solver", "Lorg/valkyrienskies/physics_api_krunch/SolverType;", "getSolver", "()Lorg/valkyrienskies/physics_api_krunch/SolverType;", "setSolver", "(Lorg/valkyrienskies/physics_api_krunch/SolverType;)V", "subSteps", "getSubSteps", "setSubSteps", "<init>", "()V"})
public final class PhysicsConfig {
    @JsonSchema(description="The detail of the collision LOD of ships, higher values are more detailed but heavier to compute")
    private int lodDetail = 512;
    @JsonSchema(description="Sets number of sub-steps used by Krunch")
    private int subSteps = 20;
    @JsonSchema(description="Sets number of iterations per sub-steps used by Krunch")
    private int iterations = 5;
    @JsonSchema(description="Sets the constraint solver used by Krunch")
    private SolverType solver = SolverType.GAUSS_SEIDEL;
    @JsonSchema(description="Limit the max collision de-penetration speed so that rigid bodies don't go flying apart when they overlap")
    private double maxDePenetrationSpeed = 10.0;
    @JsonSchema(description="How fast the physics is running. 1.0 is full speed, 0.5 is 50% speed, etc.")
    private double physicsSpeed = 1.0;

    @JvmName(name="getLodDetail")
    public final int getLodDetail() {
        return this.lodDetail;
    }

    @JvmName(name="setLodDetail")
    public final void setLodDetail(int n2) {
        this.lodDetail = n2;
    }

    @JvmName(name="getSubSteps")
    public final int getSubSteps() {
        return this.subSteps;
    }

    @JvmName(name="setSubSteps")
    public final void setSubSteps(int n2) {
        this.subSteps = n2;
    }

    @JvmName(name="getIterations")
    public final int getIterations() {
        return this.iterations;
    }

    @JvmName(name="setIterations")
    public final void setIterations(int n2) {
        this.iterations = n2;
    }

    @JvmName(name="getSolver")
    public final SolverType getSolver() {
        return this.solver;
    }

    @JvmName(name="setSolver")
    public final void setSolver(SolverType solverType) {
        Intrinsics.checkNotNullParameter((Object)((Object)solverType), (String)"");
        this.solver = solverType;
    }

    @JvmName(name="getMaxDePenetrationSpeed")
    public final double getMaxDePenetrationSpeed() {
        return this.maxDePenetrationSpeed;
    }

    @JvmName(name="setMaxDePenetrationSpeed")
    public final void setMaxDePenetrationSpeed(double d2) {
        this.maxDePenetrationSpeed = d2;
    }

    @JvmName(name="getPhysicsSpeed")
    public final double getPhysicsSpeed() {
        return this.physicsSpeed;
    }

    @JvmName(name="setPhysicsSpeed")
    public final void setPhysicsSpeed(double d2) {
        this.physicsSpeed = d2;
    }
}

