/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.blocks;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.Iterate;
import edn.stratodonut.trackwork.TrackPackets;
import edn.stratodonut.trackwork.TrackworkUtil;
import edn.stratodonut.trackwork.tracks.ITrackPointProvider;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlock;
import edn.stratodonut.trackwork.tracks.network.ThrowTrackPacket;
import edn.stratodonut.trackwork.tracks.render.TrackBeltRenderer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class TrackBaseBlockEntity
extends KineticBlockEntity
implements ITrackPointProvider {
    private boolean detracked = false;
    protected Pair<Float, Float> nextPointVerticalOffset = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    protected float nextPointHorizontalOffset = 0.0f;
    @NotNull
    private ITrackPointProvider.PointType nextPoint = ITrackPointProvider.PointType.NONE;

    public TrackBaseBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(10);
    }

    public void tick() {
        super.tick();
        BlockEntity next = this.f_58857_.m_7702_(this.m_58899_().m_121945_(TrackBeltRenderer.getAlong(this.m_58900_())));
        if (next instanceof ITrackPointProvider) {
            ITrackPointProvider track = (ITrackPointProvider)next;
            this.nextPointVerticalOffset = new Pair((Object)Float.valueOf(track.getPointDownwardOffset(0.0f)), (Object)Float.valueOf(track.getPointDownwardOffset(1.0f)));
            this.nextPointHorizontalOffset = track.getPointHorizontalOffset();
            this.nextPoint = track.getTrackPointType();
        } else {
            this.nextPoint = ITrackPointProvider.PointType.NONE;
        }
    }

    @Override
    @NotNull
    public ITrackPointProvider.PointType getNextPoint() {
        return this.nextPoint;
    }

    public void throwTrack(boolean fixTrack) {
        Level world = this.f_58857_;
        if (world.f_46443_ || this.detracked == !fixTrack) {
            return;
        }
        this.detracked = !fixTrack;
        this.speed = 0.0f;
        BlockPos pos = this.m_58899_();
        for (boolean forward : Iterate.trueAndFalse) {
            BlockEntity currentEntity;
            BlockPos currentPos = this.nextTrackPosition(this.m_58900_(), pos, forward);
            if (currentPos == null || !((currentEntity = world.m_7702_(currentPos)) instanceof TrackBaseBlockEntity)) continue;
            TrackBaseBlockEntity te = (TrackBaseBlockEntity)currentEntity;
            te.throwTrack(fixTrack);
        }
        TrackPackets.getChannel().send(this.packetTarget(), (Object)new ThrowTrackPacket(this.m_58899_(), this.detracked));
    }

    @Nullable
    private BlockPos nextTrackPosition(BlockState state, BlockPos pos, boolean forward) {
        int offset;
        TrackBaseBlock.TrackPart part = (TrackBaseBlock.TrackPart)((Object)state.m_61143_(TrackBaseBlock.PART));
        Direction next = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)TrackworkUtil.around((Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS)));
        int n = offset = forward ? 1 : -1;
        if (part == TrackBaseBlock.TrackPart.END && forward || part == TrackBaseBlock.TrackPart.START && !forward) {
            return null;
        }
        pos = pos.m_5484_(next, offset);
        return pos;
    }

    public boolean isDetracked() {
        return this.detracked;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Detracked", this.detracked);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        if (compound.m_128441_("Detracked")) {
            this.detracked = compound.m_128471_("Detracked");
        }
        super.read(compound, clientPacket);
    }

    public void handlePacket(ThrowTrackPacket p) {
        this.detracked = p.detracked;
        if (this.detracked) {
            this.speed = 0.0f;
        }
    }
}

