/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.sounds;

import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.infrastructure.config.AllConfigs;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.sounds.AmbientGroup;
import edn.stratodonut.trackwork.sounds.PitchGroups;
import edn.stratodonut.trackwork.sounds.TrackSoundScape;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class TrackSoundScapes {
    static final int UPDATE_INTERVAL = 5;
    private static final Map<AmbientGroup, Map<PitchGroups.Group, Set<BlockPos>>> counter = new IdentityHashMap<AmbientGroup, Map<PitchGroups.Group, Set<BlockPos>>>();
    private static final Map<Pair<AmbientGroup, PitchGroups.Group>, TrackSoundScape> activeSounds = new HashMap<Pair<AmbientGroup, PitchGroups.Group>, TrackSoundScape>();

    public static void play(AmbientGroup group, BlockPos pos, float pitch) {
        if (!((Boolean)AllConfigs.client().enableAmbientSounds.get()).booleanValue()) {
            return;
        }
        if (!TrackSoundScapes.outOfRange(pos)) {
            TrackSoundScapes.addSound(group, pos, pitch);
        }
    }

    public static void tick() {
        activeSounds.values().forEach(TrackSoundScape::tick);
        if (AnimationTickHolder.getTicks() % 5 != 0) {
            return;
        }
        boolean disable = (Boolean)AllConfigs.client().enableAmbientSounds.get() == false;
        Iterator<Map.Entry<Pair<AmbientGroup, PitchGroups.Group>, TrackSoundScape>> iterator = activeSounds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Pair<AmbientGroup, PitchGroups.Group>, TrackSoundScape> entry = iterator.next();
            Pair<AmbientGroup, PitchGroups.Group> key = entry.getKey();
            TrackSoundScape value = entry.getValue();
            if (!disable && TrackSoundScapes.getSoundCount((AmbientGroup)key.getFirst(), (PitchGroups.Group)((Object)key.getSecond())) != 0) continue;
            value.remove();
            iterator.remove();
        }
        counter.values().forEach(m -> m.values().forEach(Set::clear));
    }

    private static void addSound(AmbientGroup group, BlockPos pos, float pitch) {
        PitchGroups.Group groupFromPitch = PitchGroups.getGroupFromPitch(pitch);
        Set set = counter.computeIfAbsent(group, ag -> new IdentityHashMap()).computeIfAbsent(groupFromPitch, pg -> new HashSet());
        set.add(pos);
        Pair pair = Pair.of((Object)group, (Object)((Object)groupFromPitch));
        activeSounds.computeIfAbsent((Pair<AmbientGroup, PitchGroups.Group>)pair, $ -> {
            TrackSoundScape TrackSoundScape2 = group.instantiate(pitch);
            TrackSoundScape2.play();
            return TrackSoundScape2;
        });
    }

    public static void invalidateAll() {
        counter.clear();
        activeSounds.forEach(($, sound) -> sound.remove());
        activeSounds.clear();
    }

    protected static boolean outOfRange(BlockPos pos) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            pos = BlockPos.m_274446_((Position)VSGameUtilsKt.toWorldCoordinates((Level)mc.f_91073_, (Vec3)Vec3.m_82512_((Vec3i)pos)));
        }
        return !TrackSoundScapes.getCameraPos().m_123314_((Vec3i)pos, (double)TrackSoundScapes.getMaxAmbientSourceDistance());
    }

    protected static int getMaxAmbientSourceDistance() {
        return (Integer)TrackworkConfigs.client().trackSoundDist.get();
    }

    protected static BlockPos getCameraPos() {
        Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
        if (renderViewEntity == null) {
            return BlockPos.f_121853_;
        }
        BlockPos playerLocation = renderViewEntity.m_20183_();
        return playerLocation;
    }

    public static int getSoundCount(AmbientGroup group, PitchGroups.Group pitchGroup) {
        return TrackSoundScapes.getAllLocations(group, pitchGroup).size();
    }

    public static Set<BlockPos> getAllLocations(AmbientGroup group, PitchGroups.Group pitchGroup) {
        return counter.getOrDefault(group, Collections.emptyMap()).getOrDefault((Object)pitchGroup, Collections.emptySet());
    }
}

