/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzPlacements;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class RoofedDimensionSurfacePlacement
extends PlacementModifier {
    private final int minHeight;
    private final int maxWaterDepth;
    public static final Codec<RoofedDimensionSurfacePlacement> CODEC = RecordCodecBuilder.create(configInstance -> configInstance.group((App)Codec.INT.fieldOf("min_height").orElse((Object)0).forGetter(nbtFeatureConfig -> nbtFeatureConfig.minHeight), (App)Codec.INT.fieldOf("max_water_depth").orElse((Object)0).forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxWaterDepth)).apply((Applicative)configInstance, RoofedDimensionSurfacePlacement::new));

    private RoofedDimensionSurfacePlacement(int minHeight, int maxWaterDepth) {
        this.minHeight = minHeight;
        this.maxWaterDepth = maxWaterDepth;
    }

    public PlacementModifierType<?> m_183327_() {
        return BzPlacements.ROOFED_DIMENSION_SURFACE_PLACEMENT.get();
    }

    public Stream<BlockPos> m_213676_(PlacementContext placementContext, RandomSource random, BlockPos blockPos) {
        int maxY = placementContext.m_191833_().m_6331_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122178_(blockPos.m_123341_(), this.minHeight, blockPos.m_123343_());
        while (mutable.m_123342_() < maxY) {
            BlockState state = placementContext.m_191828_((BlockPos)mutable);
            if (state.m_60795_()) {
                return Stream.of(mutable.m_7949_());
            }
            if (!state.m_60819_().m_76178_()) {
                BlockPos currentPos = mutable.m_7949_();
                mutable.m_122173_(Direction.UP);
                int currentFluidDepth = 1;
                if (currentFluidDepth > this.maxWaterDepth) {
                    return Stream.of(new BlockPos[0]);
                }
                while (mutable.m_123342_() < maxY) {
                    BlockState secondState = placementContext.m_191828_((BlockPos)mutable);
                    if (secondState.m_60795_()) {
                        return Stream.of(currentPos);
                    }
                    if (secondState.m_60819_().m_76178_()) break;
                    mutable.m_122173_(Direction.UP);
                    if (++currentFluidDepth <= this.maxWaterDepth) continue;
                    return Stream.of(new BlockPos[0]);
                }
            }
            mutable.m_122173_(Direction.UP);
        }
        return Stream.of(new BlockPos[0]);
    }
}

