/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminPose;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.SentryWatcherSpawnEgg;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.entities.EntityAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SentryWatcherEntity
extends Entity
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_ID_ACTIVATED = SynchedEntityData.m_135353_(SentryWatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_SHAKING = SynchedEntityData.m_135353_(SentryWatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_NO_AI = SynchedEntityData.m_135353_(SentryWatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Direction> DATA_ID_TARGET_FACING = SynchedEntityData.m_135353_(SentryWatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_ID_OWNER = SynchedEntityData.m_135353_(SentryWatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public float xxa;
    public float zza;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    private int shakingTime = 0;
    private Direction targetFacing;
    private boolean explosionPrimed = false;
    private boolean quarterTurns = false;
    private boolean prevShaking;
    private int shakeStartTick;
    private Vec3 prevVelocity;
    private Vec3 activatedStart;
    private int lastRightClicked = -100;
    private static final int MAX_CHARGING_DISTANCE = 80;
    private static final int SIGHT_RANGE = 36;
    private static final int UNABLE_TO_DESTROY_TOTAL_BLOCK_HARDNESS = 20;
    private static final float MAX_STEP_UP = 0.75f;
    private static final float ROTATION_SPEED = 1.5f;
    private static final float ACCELERATION_FLUID = 0.95f;
    private static final float ACCELERATION_GRAVITY = 0.98f;
    private static final float MAX_SPEED_CAP = 2.0f;

    public SentryWatcherEntity(Level worldIn) {
        super(BzEntities.SENTRY_WATCHER.get(), worldIn);
        this.m_274367_(0.75f);
        this.f_19811_ = true;
    }

    public SentryWatcherEntity(EntityType<? extends SentryWatcherEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(0.75f);
    }

    public int getShakingTime() {
        return this.shakingTime;
    }

    public void setShakingTime(int shakingTime) {
        this.shakingTime = shakingTime;
    }

    public Direction getTargetFacing() {
        if (this.targetFacing == null) {
            this.targetFacing = this.m_6350_();
        }
        return this.targetFacing;
    }

    public void setTargetFacing(Direction targetFacing) {
        this.targetFacing = targetFacing;
        this.setTargetFacingForSync();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_ACTIVATED, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_SHAKING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_NO_AI, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TARGET_FACING, (Object)this.getTargetFacing());
        this.f_19804_.m_135372_(DATA_ID_OWNER, Optional.empty());
    }

    public boolean hasActivated() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_ACTIVATED);
    }

    protected void setHasActivated(boolean activated) {
        this.f_19804_.m_135381_(DATA_ID_ACTIVATED, (Object)activated);
    }

    public boolean hasShaking() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_SHAKING);
    }

    protected void setHasShaking(boolean isShaking) {
        this.f_19804_.m_135381_(DATA_ID_SHAKING, (Object)isShaking);
    }

    public boolean hasNoAI() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_NO_AI);
    }

    protected void setNoAI(boolean noAI) {
        this.f_19804_.m_135381_(DATA_ID_NO_AI, (Object)noAI);
    }

    public Direction getTargetFacingFromSync() {
        return (Direction)this.f_19804_.m_135370_(DATA_ID_TARGET_FACING);
    }

    public void setTargetFacingForSync() {
        this.f_19804_.m_135381_(DATA_ID_TARGET_FACING, (Object)this.getTargetFacing());
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.f_19804_.m_135370_(DATA_ID_OWNER);
    }

    public void setOwner(Optional<UUID> owner) {
        this.f_19804_.m_135381_(DATA_ID_OWNER, owner);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        this.m_6210_();
        if (this.m_20069_() && this.f_19796_.m_188503_(20) == 0) {
            this.m_5841_();
        }
        super.m_7350_(key);
    }

    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128379_("explosionPrimed", this.explosionPrimed);
        compoundTag.m_128379_("quarterTurns", this.quarterTurns);
        if (this.activatedStart != null) {
            compoundTag.m_128347_("activatedStartX", this.activatedStart.m_7096_());
            compoundTag.m_128347_("activatedStartZ", this.activatedStart.m_7094_());
        }
        compoundTag.m_128379_("activated", this.hasActivated());
        compoundTag.m_128379_("shaking", this.hasShaking());
        compoundTag.m_128405_("shakingTime", this.getShakingTime());
        String targetFacingName = this.getTargetFacing().m_122433_();
        compoundTag.m_128359_("targetFacing", targetFacingName);
        if (compoundTag.m_128441_("noAi")) {
            compoundTag.m_128379_("noAi", this.hasNoAI());
        } else if (compoundTag.m_128441_("noAI")) {
            compoundTag.m_128379_("noAI", this.hasNoAI());
        } else {
            compoundTag.m_128379_("NoAI", this.hasNoAI());
        }
        if (this.getOwner().isPresent()) {
            compoundTag.m_128362_("owner", this.getOwner().get());
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        this.explosionPrimed = compoundTag.m_128471_("explosionPrimed");
        this.quarterTurns = compoundTag.m_128471_("quarterTurns");
        this.activatedStart = new Vec3(compoundTag.m_128459_("activatedStartX"), 0.0, compoundTag.m_128459_("activatedStartZ"));
        this.setHasActivated(compoundTag.m_128471_("activated"));
        this.setHasShaking(compoundTag.m_128471_("shaking"));
        this.setShakingTime(compoundTag.m_128451_("shakingTime"));
        this.setHasShaking(this.getShakingTime() > 0);
        String targetFacingName = compoundTag.m_128461_("targetFacing");
        Direction targetDirection = Direction.m_122402_((String)targetFacingName);
        this.setTargetFacing(targetDirection);
        this.setNoAI(compoundTag.m_128471_("NoAI") || compoundTag.m_128471_("noAI") || compoundTag.m_128471_("noAi"));
        if (compoundTag.m_128441_("owner")) {
            this.setOwner(Optional.of(compoundTag.m_128342_("owner")));
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        if (this.explosionPrimed && !this.m_9236_().m_5776_() && removalReason == Entity.RemovalReason.KILLED) {
            this.largeExplosion();
        }
    }

    private void largeExplosion() {
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f, Level.ExplosionInteraction.MOB);
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 9.0f, Level.ExplosionInteraction.MOB);
    }

    public boolean m_5833_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public ItemStack m_142340_() {
        return BzItems.SENTRY_WATCHER_SPAWN_EGG.get().m_7968_();
    }

    public void m_6210_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        super.m_6210_();
        this.m_20248_(x, y, z);
    }

    public float m_7890_(Rotation rotation) {
        this.setTargetFacing(rotation.m_55954_(this.getTargetFacing()));
        float f = Mth.m_14177_((float)this.m_146908_());
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> f + 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> f + 270.0f;
            case Rotation.CLOCKWISE_90 -> f + 90.0f;
            default -> f;
        };
    }

    public float m_6961_(Mirror mirror) {
        this.setTargetFacing(mirror.m_54848_(this.getTargetFacing()));
        float f = Mth.m_14177_((float)this.m_146908_());
        return switch (mirror) {
            case Mirror.FRONT_BACK -> -f;
            case Mirror.LEFT_RIGHT -> 180.0f - f;
            default -> f;
        };
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    public boolean m_142535_(float f, float g, DamageSource arg) {
        if ((double)f > 1.5) {
            this.m_5496_(SoundEvents.f_11908_, 1.0f, 0.5f);
            this.playBlockFallSound();
            return true;
        }
        return false;
    }

    protected void playBlockFallSound() {
        if (!this.m_20067_()) {
            int i = Mth.m_14107_((double)this.m_20185_());
            int j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f));
            int k = Mth.m_14107_((double)this.m_20189_());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.m_9236_().m_8055_(pos);
            if (!blockstate.m_60795_()) {
                SoundType soundtype = blockstate.m_60827_();
                this.m_5496_(soundtype.m_56779_(), soundtype.m_56773_() * 0.5f, soundtype.m_56774_() * 0.75f);
            }
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public float getFluidSpeed() {
        return 0.95f;
    }

    public boolean m_204031_(TagKey<Fluid> tagKey, double d) {
        if (this.m_146899_()) {
            return false;
        }
        AABB aABB = this.m_20191_().m_82406_(0.001);
        int i = Mth.m_14107_((double)aABB.f_82288_);
        int j = Mth.m_14165_((double)aABB.f_82291_);
        int k = Mth.m_14107_((double)aABB.f_82289_);
        int l = Mth.m_14165_((double)aABB.f_82292_);
        int m = Mth.m_14107_((double)aABB.f_82290_);
        int n = Mth.m_14165_((double)aABB.f_82293_);
        double e = 0.0;
        boolean bl2 = false;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int p = i; p < j; ++p) {
            for (int q = k; q < l; ++q) {
                for (int r = m; r < n; ++r) {
                    double f;
                    mutableBlockPos.m_122178_(p, q, r);
                    FluidState fluidState = this.m_9236_().m_6425_((BlockPos)mutableBlockPos);
                    if (!fluidState.m_205070_(tagKey) || !((f = (double)((float)q + fluidState.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos))) >= aABB.f_82289_)) continue;
                    bl2 = true;
                    e = Math.max(f - aABB.f_82289_, e);
                }
            }
        }
        this.f_19799_.put(tagKey, e);
        return bl2;
    }

    public boolean m_7337_(Entity entity) {
        RootminEntity rootminEntity;
        if (entity instanceof RootminEntity && (rootminEntity = (RootminEntity)entity).getRootminPose() == RootminPose.ENTITY_TO_BLOCK) {
            return false;
        }
        return entity.m_5829_() && !this.m_20365_(entity);
    }

    public InteractionResult m_6096_(Player player, InteractionHand interactionHand) {
        if (player != null && interactionHand == InteractionHand.MAIN_HAND && this.getOwner().isPresent() && (this.getOwner().get().equals(player.m_20148_()) || this.getOwner().get().equals(SentryWatcherSpawnEgg.DISPENSER_OWNER_UUID))) {
            if (this.f_19797_ - this.lastRightClicked < 40) {
                GeneralUtils.givePlayerItem(player, interactionHand, BzItems.SENTRY_WATCHER_SPAWN_EGG.get().m_7968_(), false, false);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                this.lastRightClicked = this.f_19797_;
                this.setHasShaking(true);
                this.setShakingTime(40);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_213877_()) {
            this.aiStep();
        }
        if (this.hasActivated() && this.activatedStart != null && Math.abs(this.m_20182_().m_165924_() - this.activatedStart.m_165924_()) > 80.0) {
            this.deactivate();
        }
        this.m_9236_().m_46473_().m_6180_("rangeChecks");
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        this.m_9236_().m_46473_().m_7238_();
    }

    public void travel() {
        if (this.m_6109_()) {
            boolean isFalling;
            double gravityModifier = 0.08;
            boolean bl = isFalling = this.m_20184_().f_82480_ <= 0.0;
            if (this.m_20069_() || this.m_20077_()) {
                double e = this.m_20186_();
                float speed = this.getFluidSpeed();
                float g = 0.02f;
                float h = 0.0f;
                if (!this.m_20096_()) {
                    h *= 0.5f;
                }
                if (h > 0.0f) {
                    speed += (0.54600006f - speed) * h / 3.0f;
                    g += (this.getFluidSpeed() - g) * h / 3.0f;
                }
                this.m_19920_(g, Vec3.f_82478_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 vec32 = this.m_20184_();
                this.m_20256_(vec32.m_82542_((double)speed, (double)0.8f, (double)speed));
                Vec3 vec33 = this.getFluidFallingAdjustedMovement(gravityModifier, isFalling, this.m_20184_());
                this.m_20256_(vec33);
                if (this.f_19862_ && this.m_20229_(vec33.f_82479_, vec33.f_82480_ + (double)0.6f - this.m_20186_() + e, vec33.f_82481_)) {
                    this.m_20334_(vec33.f_82479_, 0.3f, vec33.f_82481_);
                }
            } else {
                BlockPos blockPos = this.m_20099_();
                Vec3 vec37 = this.handleRelativeFrictionAndCalculateMovement();
                double ySpeed = vec37.f_82480_;
                if (this.m_9236_().f_46443_ && !this.m_9236_().m_46805_(blockPos)) {
                    ySpeed = this.m_20186_() > (double)this.m_9236_().m_141937_() ? -0.1 : 0.0;
                } else if (!this.m_20068_()) {
                    ySpeed -= gravityModifier;
                }
                this.m_20334_(vec37.f_82479_, ySpeed * (double)0.98f, vec37.f_82481_);
            }
        } else if (this.m_9236_().m_5776_()) {
            if (this.hasActivated() && this.m_20096_() && (Math.abs(this.m_20184_().m_7096_()) > 0.001 || Math.abs(this.m_20184_().m_7094_()) > 0.001)) {
                int particlesToSpawn = (int)(1.0 + Math.abs(this.m_20184_().m_7096_() * 50.0) + Math.abs(this.m_20184_().m_7094_() + 50.0));
                for (int i = 0; i < particlesToSpawn; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20182_().m_7096_() + this.f_19796_.m_188583_() * 0.6, this.m_20182_().m_7098_() + this.f_19796_.m_188583_() * 0.1 + 0.2, this.m_20182_().m_7094_() + this.f_19796_.m_188583_() * 0.6, this.f_19796_.m_188583_() * 0.01 + 0.01, this.f_19796_.m_188583_() * 0.01 + 0.01, this.f_19796_.m_188583_() * 0.01 + 0.01);
                }
            }
            if (this.hasShaking() && (!this.prevShaking || (this.f_19797_ - this.shakeStartTick) % 10 == 0)) {
                this.m_9236_().m_245747_(this.m_20183_(), BzSounds.SENTRY_WATCHER_ACTIVATING.get(), SoundSource.NEUTRAL, 2.5f, 1.0f, false);
            } else if (this.hasActivated() && !this.hasShaking() && this.f_19797_ % 10 == 0) {
                this.m_9236_().m_245747_(this.m_20183_(), BzSounds.SENTRY_WATCHER_MOVING.get(), SoundSource.NEUTRAL, 2.0f, 1.0f, false);
            }
            if (!this.prevShaking && this.hasShaking()) {
                this.shakeStartTick = this.f_19797_;
            }
            this.prevShaking = this.hasShaking();
        }
        double xSpeed = this.m_20184_().m_7096_();
        double zSpeed = this.m_20184_().m_7094_();
        this.m_20334_(GeneralUtils.capBetween(xSpeed, -2.0, 2.0), this.m_20184_().m_7098_(), GeneralUtils.capBetween(zSpeed, -2.0, 2.0));
        this.pushEntities();
    }

    protected void serverAiStep() {
        ServerLevel serverLevel;
        StructureStart structureStart;
        Level newX2;
        Vec3 offset;
        if (this.getShakingTime() > 0) {
            this.setShakingTime(this.getShakingTime() - 1);
            if (this.getShakingTime() <= 0) {
                this.setHasShaking(false);
            }
        }
        if (this.hasActivated()) {
            if (this.f_19862_ && this.m_20184_().m_165924_() < (double)1.0E-4f) {
                this.deactivate();
                double pastSpeed = this.prevVelocity.m_165924_();
                if (pastSpeed > 0.01) {
                    List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), EntitySelector.m_20421_((Entity)this));
                    for (Entity entity : list) {
                        if (entity.m_6095_().m_204039_(BzTags.SENTRY_WATCHER_CANNOT_DAMAGE)) continue;
                        entity.m_6469_(this.m_9236_().m_269111_().m_269298_(BzDamageSources.SENTRY_WATCHER_CRUSHING_TYPE, (Entity)this), 1.0f);
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)entity;
                        float oldHealth = livingEntity.m_21223_();
                        float maxhealth = Math.max(livingEntity.m_21223_(), livingEntity.m_21233_());
                        double healthToLose = Mth.m_14085_((double)(maxhealth / 3.0f), (double)(maxhealth - 1.0f), (double)(pastSpeed - 0.2));
                        double possibleNewHealth = (double)oldHealth - healthToLose;
                        double newHealth = Math.max(possibleNewHealth, 1.0);
                        livingEntity.m_21153_((float)newHealth);
                        if (!(livingEntity instanceof Player)) continue;
                        Player player = (Player)livingEntity;
                        double armorDamage = Mth.m_14085_((double)1.0, (double)8.0, (double)(pastSpeed - 0.2));
                        player.m_150109_().m_150072_(this.m_9236_().m_269111_().m_269298_(BzDamageSources.SENTRY_WATCHER_CRUSHING_TYPE, (Entity)this), (float)armorDamage, Inventory.f_150068_);
                    }
                }
            } else if (!this.hasNoAI() && this.getShakingTime() <= 0) {
                Vec3 currentVelocity = this.m_20184_();
                double newX2 = currentVelocity.m_7096_();
                double newY = currentVelocity.m_7098_();
                double newZ = currentVelocity.m_7094_();
                Direction currentDirection = this.getTargetFacing();
                if (currentDirection.m_122429_() != 0) {
                    newX2 += (double)((float)currentDirection.m_122429_() / 200.0f);
                    newX2 *= 1.05;
                } else if (currentDirection.m_122431_() != 0) {
                    newZ += (double)((float)currentDirection.m_122431_() / 200.0f);
                    newZ *= 1.05;
                }
                this.m_20334_(newX2, newY, newZ);
            }
        } else if (!this.hasNoAI() && this.f_19797_ % 10 == 0 && this.m_146908_() == this.getTargetFacing().m_122435_() && !this.scanAndBeginActivationIfEnemyFound(offset = Vec3.m_82528_((Vec3i)Rotation.CLOCKWISE_90.m_55954_(this.getTargetFacing()).m_122436_()).m_82490_(0.5))) {
            this.scanAndBeginActivationIfEnemyFound(offset.m_82490_(-1.0));
        }
        if (!this.hasNoAI() && this.explosionPrimed && this.f_19797_ % 20 == 0 && (newX2 = this.m_9236_()) instanceof ServerLevel && ((structureStart = (serverLevel = (ServerLevel)newX2).m_215010_().m_220491_(this.m_20183_(), BzTags.SEMPITERNAL_SANCTUMS)) == null || !structureStart.m_73603_())) {
            this.m_6074_();
        }
    }

    private boolean scanAndBeginActivationIfEnemyFound(Vec3 offset) {
        Vec3 eyePosition = this.m_146892_().m_82549_(offset);
        Vec3 finalPos = eyePosition.m_82549_(Vec3.m_82528_((Vec3i)this.getTargetFacing().m_122436_().m_142393_(36)));
        AABB boundsForChecking = this.m_20191_().m_82400_(36.0);
        EntityHitResult entityHitResult = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)eyePosition, (Vec3)finalPos, (AABB)boundsForChecking, this::canSeeEntity);
        if (entityHitResult != null) {
            this.setHasActivated(true);
            this.setShakingTime(40);
            this.setHasShaking(true);
            this.activatedStart = this.m_20182_();
            return true;
        }
        finalPos = this.m_20182_().m_82520_(0.0, 0.1, 0.0).m_82549_(Vec3.m_82528_((Vec3i)this.getTargetFacing().m_122436_().m_142393_(36)));
        boundsForChecking = this.m_20191_().m_82400_(36.0);
        EntityHitResult entityHitResult2 = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)eyePosition, (Vec3)finalPos, (AABB)boundsForChecking, this::canSeeEntity);
        if (entityHitResult2 != null) {
            this.setHasActivated(true);
            this.setShakingTime(40);
            this.setHasShaking(true);
            this.activatedStart = this.m_20182_();
            return true;
        }
        return false;
    }

    private void deactivate() {
        this.setHasActivated(false);
        if (this.quarterTurns) {
            this.setTargetFacing(this.getTargetFacing().m_122428_());
        } else {
            this.setTargetFacing(this.getTargetFacing().m_122424_());
        }
        this.m_20334_(0.0, this.m_20184_().m_7098_(), 0.0);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 40, 1.0, 1.0, 1.0, 0.1);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 40, 1.0, 1.0, 1.0, 0.1);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 40, 1.0, 1.0, 1.0, 0.1);
            serverLevel.m_245803_((Entity)this, this.m_20183_(), BzSounds.SENTRY_WATCHER_CRASH.get(), SoundSource.NEUTRAL, 2.5f, 1.0f);
        }
    }

    private boolean canSeeEntity(Entity entity) {
        Player player;
        if (entity.m_6095_().m_204039_(BzTags.SENTRY_WATCHER_FORCED_NEVER_ACTIVATES_WHEN_SEEN) || entity.m_5833_()) {
            return false;
        }
        if (entity.m_6095_().m_204039_(BzTags.SENTRY_WATCHER_ACTIVATES_WHEN_SEEN)) {
            return true;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_20148_().equals(this.getOwner().orElse(null)))) {
            return false;
        }
        return entity instanceof LivingEntity && !BeeAggression.isBeelikeEntity(entity);
    }

    public void aiStep() {
        if (this.hasNoAI()) {
            return;
        }
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double e = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double f = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double g = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)g / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d, e, f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        this.turnToTargetFacing();
        Vec3 vec3 = this.m_20184_();
        double newX = vec3.f_82479_;
        double newY = vec3.f_82480_;
        double newZ = vec3.f_82481_;
        if (Math.abs(vec3.f_82479_) < 0.003) {
            newX = 0.0;
        }
        if (Math.abs(vec3.f_82480_) < 0.003) {
            newY = 0.0;
        }
        if (Math.abs(vec3.f_82481_) < 0.003) {
            newZ = 0.0;
        }
        this.m_20334_(newX, newY, newZ);
        this.m_9236_().m_46473_().m_6180_("ai");
        if (this.isImmobile()) {
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.m_21515_()) {
            this.m_9236_().m_46473_().m_6180_("newAi");
            this.serverAiStep();
            this.m_9236_().m_46473_().m_7238_();
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("travel");
        this.travel();
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("freezing");
        if (!this.m_9236_().f_46443_) {
            int m = this.m_146888_();
            if (this.f_146808_ && this.m_142079_()) {
                this.m_146917_(Math.min(this.m_146891_(), m + 1));
            } else {
                this.m_146917_(Math.max(0, m - 2));
            }
        }
        this.m_9236_().m_46473_().m_7238_();
    }

    private void turnToTargetFacing() {
        if (!this.hasNoAI() && !this.hasActivated() && this.m_146908_() != this.getTargetFacingFromSync().m_122435_()) {
            double newYDiff;
            double newY;
            double targetY = this.getTargetFacing().m_122435_();
            double currentY = this.m_146908_();
            double diff = targetY - currentY;
            double diff2 = targetY - (currentY + 360.0);
            double diffToUse = diff;
            if (Math.abs(diff) > Math.abs(diff2)) {
                diffToUse = diff2;
            }
            if ((newY = currentY + (newYDiff = Math.max(Math.min(diffToUse, 1.5), -1.5))) < 0.0) {
                newY += 360.0;
            } else if (newY >= 360.0) {
                newY -= 360.0;
            }
            this.m_146922_((float)newY);
            if (this.f_19797_ % 20 == 0) {
                this.m_9236_().m_245747_(this.m_20183_(), BzSounds.SENTRY_WATCHER_MOVING.get(), SoundSource.NEUTRAL, 0.4f, 0.2f, false);
            }
        }
    }

    protected void pushEntities() {
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Player.class), this.m_20191_(), EntitySelector.m_20421_((Entity)this)).forEach(this::doPush);
        } else {
            List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), EntitySelector.m_20421_((Entity)this));
            if (!list.isEmpty()) {
                int j;
                int i = this.m_9236_().m_46469_().m_46215_(GameRules.f_46149_);
                if (i > 0 && list.size() > i - 1 && this.f_19796_.m_188503_(4) == 0) {
                    j = 0;
                    for (Entity entity : list) {
                        if (entity.m_20159_()) continue;
                        ++j;
                    }
                }
                for (j = 0; j < list.size(); ++j) {
                    Entity entity = (Entity)list.get(j);
                    this.doPush(entity);
                }
            }
        }
    }

    protected void doPush(Entity entity) {
        if (entity instanceof LivingEntity) {
            double speedDiff;
            Vec3 currentVelocity = this.m_20184_();
            Vec3 victimVelocity = entity.m_20184_();
            Vec3 diffVelocity = currentVelocity.m_82546_(victimVelocity);
            double d = speedDiff = this.getTargetFacing().m_122429_() != 0 ? Math.abs(diffVelocity.m_7096_()) : Math.abs(diffVelocity.m_7094_());
            if (speedDiff > 0.2) {
                speedDiff -= 0.1;
                double pushEffect = 1.1;
                entity.m_20334_(0.0, entity.m_20184_().m_7098_(), 0.0);
                entity.m_5997_(this.m_20184_().m_7096_() * pushEffect, 0.0, this.m_20184_().m_7094_() * pushEffect);
                AABB sentryBounds = this.m_20191_();
                Vec3 pushToSpot = entity.m_20182_();
                switch (this.getTargetFacing()) {
                    case NORTH: {
                        pushToSpot = new Vec3(pushToSpot.m_7096_(), pushToSpot.m_7098_(), sentryBounds.f_82290_);
                        break;
                    }
                    case SOUTH: {
                        pushToSpot = new Vec3(pushToSpot.m_7096_(), pushToSpot.m_7098_(), sentryBounds.f_82293_);
                        break;
                    }
                    case WEST: {
                        pushToSpot = new Vec3(sentryBounds.f_82288_, pushToSpot.m_7098_(), pushToSpot.m_7094_());
                        break;
                    }
                    case EAST: {
                        pushToSpot = new Vec3(sentryBounds.f_82291_, pushToSpot.m_7098_(), pushToSpot.m_7094_());
                    }
                }
                entity.m_146884_(pushToSpot);
                if (!this.m_9236_().m_5776_() && !entity.m_6095_().m_204039_(BzTags.SENTRY_WATCHER_CANNOT_DAMAGE)) {
                    ServerPlayer serverPlayer;
                    float damageMultiplier = 30.0f;
                    if (entity instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)entity)) {
                        damageMultiplier = 16.0f;
                    }
                    int beeArmorOn = BeeArmor.getBeeThemedWearablesCount(entity);
                    entity.m_6469_(this.m_9236_().m_269111_().m_269298_(BzDamageSources.SENTRY_WATCHER_CRUSHING_TYPE, (Entity)this), (float)(speedDiff * (double)(damageMultiplier -= (float)beeArmorOn * 1.333333f)));
                }
            } else {
                super.m_7334_(entity);
            }
        } else if (entity instanceof SentryWatcherEntity) {
            this.deactivate();
        } else {
            super.m_7334_(entity);
        }
    }

    public void m_5997_(double d, double e, double f) {
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement() {
        Vec3 deltaMovement = this.m_20184_();
        if (!this.hasActivated()) {
            deltaMovement = deltaMovement.m_82542_(0.9, 1.0, 0.9);
        }
        this.m_6478_(MoverType.SELF, deltaMovement);
        deltaMovement = this.m_20184_();
        if (this.f_19862_ && this.m_146900_().m_60713_(Blocks.f_152499_) && PowderSnowBlock.m_154255_((Entity)this)) {
            deltaMovement = new Vec3(deltaMovement.f_82479_, 0.2, deltaMovement.f_82481_);
        }
        return deltaMovement;
    }

    public Vec3 getFluidFallingAdjustedMovement(double d, boolean bl, Vec3 vec3) {
        if (!this.m_20068_() && !this.m_20142_()) {
            double e = bl && Math.abs(vec3.f_82480_ - 0.005) >= 0.003 && Math.abs(vec3.f_82480_ - d / 16.0) < 0.003 ? -0.003 : vec3.f_82480_ - d / 16.0;
            return new Vec3(vec3.f_82479_, e, vec3.f_82481_);
        }
        return vec3;
    }

    public void m_6478_(MoverType moverType, Vec3 vec3) {
        if (this.f_19794_) {
            this.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
        } else {
            Vec3 collision;
            double d;
            this.f_146810_ = this.m_6060_();
            if (moverType == MoverType.PISTON && (vec3 = this.m_20133_(vec3)).equals((Object)Vec3.f_82478_)) {
                return;
            }
            this.m_9236_().m_46473_().m_6180_("move");
            if (this.f_19865_.m_82556_() > 1.0E-7) {
                vec3 = vec3.m_82559_(this.f_19865_);
                this.f_19865_ = Vec3.f_82478_;
                this.m_20256_(Vec3.f_82478_);
            }
            if ((d = (collision = this.collide(vec3 = this.m_5763_(vec3, moverType))).m_82556_()) > 1.0E-7) {
                BlockHitResult blockHitResult;
                if (this.f_19789_ != 0.0f && d >= 1.0 && (blockHitResult = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(collision), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
                    this.m_183634_();
                }
                this.m_6034_(this.m_20185_() + collision.f_82479_, this.m_20186_() + collision.f_82480_, this.m_20189_() + collision.f_82481_);
            }
            this.m_9236_().m_46473_().m_7238_();
            this.m_9236_().m_46473_().m_6180_("rest");
            this.prevVelocity = vec3;
            boolean loseXSpeed = !Mth.m_14082_((double)vec3.f_82479_, (double)collision.f_82479_);
            boolean loseZSpeed = !Mth.m_14082_((double)vec3.f_82481_, (double)collision.f_82481_);
            this.f_19862_ = loseXSpeed || loseZSpeed;
            this.f_19863_ = vec3.f_82480_ != collision.f_82480_;
            this.f_201939_ = this.f_19863_ && vec3.f_82480_ < 0.0;
            Vec3 deltaMovement = this.m_20184_();
            if (this.f_19862_ && Math.abs(deltaMovement.m_7096_()) + Math.abs(deltaMovement.m_7094_()) > 0.01) {
                this.destroyBlocksInWay();
            }
            this.f_185931_ = this.f_19862_ ? this.m_196406_(collision) : false;
            this.m_289603_(this.f_201939_, collision);
            BlockPos blockPos = this.m_216999_();
            BlockState blockState = this.m_9236_().m_8055_(blockPos);
            this.m_7840_(collision.f_82480_, this.m_20096_(), blockState, blockPos);
            if (this.m_213877_()) {
                this.m_9236_().m_46473_().m_7238_();
            } else {
                Entity.MovementEmission movementEmission;
                if (this.f_19862_) {
                    Vec3 vec33 = this.m_20184_();
                    this.m_20334_(loseXSpeed ? 0.0 : vec33.f_82479_, vec33.f_82480_, loseZSpeed ? 0.0 : vec33.f_82481_);
                }
                Block block = blockState.m_60734_();
                if (vec3.f_82480_ != collision.f_82480_) {
                    block.m_5548_((BlockGetter)this.m_9236_(), (Entity)this);
                }
                if (this.m_20096_()) {
                    block.m_141947_(this.m_9236_(), blockPos, blockState, (Entity)this);
                }
                if ((movementEmission = this.m_142319_()).m_146944_() && !this.m_20159_()) {
                    double e = collision.f_82479_;
                    double f = collision.f_82480_;
                    double g = collision.f_82481_;
                    this.f_146794_ += (float)(collision.m_82553_() * 0.6);
                    BlockPos blockPos2 = this.m_20097_();
                    BlockState blockState2 = this.m_9236_().m_8055_(blockPos2);
                    this.f_19787_ += (float)collision.m_165924_() * 0.6f;
                    this.f_19788_ += (float)Math.sqrt(e * e + f * f + g * g) * 0.6f;
                    if (this.f_19788_ > ((EntityAccessor)((Object)this)).bumblezone$getNextStep() && !blockState2.m_60795_()) {
                        boolean bl4 = blockPos2.equals((Object)blockPos);
                        boolean bl5 = ((EntityAccessor)((Object)this)).bumblezone$callVibrationAndSoundEffectsFromBlock(blockPos, blockState, movementEmission.m_146946_(), bl4, vec3);
                        if (!bl4) {
                            bl5 |= ((EntityAccessor)((Object)this)).bumblezone$callVibrationAndSoundEffectsFromBlock(blockPos2, blockState2, false, movementEmission.m_146945_(), vec3);
                        }
                        if (bl5) {
                            ((EntityAccessor)((Object)this)).bumblezone$setNextStep(this.m_6059_());
                        } else if (this.m_20069_()) {
                            ((EntityAccessor)((Object)this)).bumblezone$setNextStep(this.m_6059_());
                            if (movementEmission.m_146946_()) {
                                this.m_280447_();
                            }
                            if (movementEmission.m_146945_()) {
                                this.m_146850_(GameEvent.f_157786_);
                            }
                        }
                    } else if (blockState2.m_60795_()) {
                        this.m_146874_();
                    }
                }
                this.m_146872_();
                if (this.m_9236_().m_46847_(this.m_20191_().m_82406_(1.0E-6)).noneMatch(blockStatex -> blockStatex.m_204336_(BlockTags.f_13076_) || blockStatex.m_60713_(Blocks.f_49991_))) {
                    if (this.m_20094_() <= 0) {
                        this.m_7311_(-this.m_6101_());
                    }
                    if (this.f_146810_ && (this.f_146808_ || this.m_20071_())) {
                        this.m_146873_();
                    }
                }
                if (this.m_6060_() && (this.f_146808_ || this.m_20071_())) {
                    this.m_7311_(-this.m_6101_());
                }
                this.m_9236_().m_46473_().m_7238_();
            }
        }
    }

    private void destroyBlocksInWay() {
        Direction facing = this.getTargetFacing();
        AABB aabb = this.m_20191_();
        BlockPos min = null;
        BlockPos max = null;
        double xStep = (double)facing.m_122429_() / 3.0;
        double zStep = (double)facing.m_122431_() / 3.0;
        switch (facing) {
            case NORTH: {
                min = new BlockPos((int)Math.floor(aabb.f_82288_ + xStep + 1.0E-4), (int)Math.floor(aabb.f_82289_), (int)Math.floor(aabb.f_82290_ + zStep + 1.0E-4));
                max = new BlockPos((int)Math.floor(aabb.f_82291_ + xStep - (double)1.0E-4f), (int)Math.floor(aabb.f_82289_), (int)Math.floor(aabb.f_82290_ + zStep + 1.0E-4));
                break;
            }
            case SOUTH: {
                min = new BlockPos((int)Math.floor(aabb.f_82288_ + xStep + 1.0E-4), (int)Math.floor(aabb.f_82289_), (int)Math.floor(aabb.f_82293_ + zStep - 1.0E-4));
                max = new BlockPos((int)Math.floor(aabb.f_82291_ + xStep - 1.0E-4), (int)Math.floor(aabb.f_82289_), (int)Math.floor(aabb.f_82293_ + zStep - 1.0E-4));
                break;
            }
            case WEST: {
                min = new BlockPos((int)Math.floor(aabb.f_82288_ + xStep + 1.0E-4), (int)Math.floor(aabb.f_82289_), (int)Math.floor(aabb.f_82290_ + zStep + 1.0E-4));
                max = new BlockPos((int)Math.floor(aabb.f_82288_ + xStep + 1.0E-4), (int)Math.floor(aabb.f_82289_), (int)Math.floor(aabb.f_82293_ + zStep - 1.0E-4));
                break;
            }
            case EAST: {
                min = new BlockPos((int)Math.floor(aabb.f_82291_ + xStep - 1.0E-4), (int)Math.floor(aabb.f_82289_), (int)Math.floor(aabb.f_82290_ + zStep + 1.0E-4));
                max = new BlockPos((int)Math.floor(aabb.f_82291_ + xStep - 1.0E-4), (int)Math.floor(aabb.f_82289_), (int)Math.floor(aabb.f_82293_ + zStep - 1.0E-4));
            }
        }
        if (min != null && this.getOwner().isEmpty()) {
            boolean canDemolish = true;
            double totalhardness = 0.0;
            int alwaysDestroyCounter = 0;
            ArrayList<BlockPos> demolishPos = new ArrayList<BlockPos>();
            for (BlockPos pos : BlockPos.m_121940_(min, max)) {
                BlockState state = this.m_9236_().m_8055_(pos);
                VoxelShape blockShape = state.m_60812_((BlockGetter)this.m_9236_(), pos);
                if ((!blockShape.m_83281_() || state.m_204336_(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) && blockShape.m_83297_(Direction.Axis.Y) > this.m_20186_() - (double)this.m_146904_()) {
                    if (state.m_204336_(BzTags.SENTRY_WATCHER_FORCED_NEVER_DESTROY)) {
                        canDemolish = false;
                        break;
                    }
                    demolishPos.add(pos.m_7949_());
                    totalhardness += (double)state.m_60734_().m_7325_();
                    if (state.m_204336_(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) {
                        ++alwaysDestroyCounter;
                    }
                }
                BlockPos abovePos = pos.m_7494_();
                BlockState aboveState = this.m_9236_().m_8055_(abovePos);
                if (aboveState.m_60812_((BlockGetter)this.m_9236_(), abovePos).m_83281_() && !aboveState.m_204336_(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) continue;
                if (aboveState.m_204336_(BzTags.SENTRY_WATCHER_FORCED_NEVER_DESTROY)) {
                    canDemolish = false;
                    break;
                }
                demolishPos.add(abovePos);
                totalhardness += (double)aboveState.m_60734_().m_7325_();
                if (!aboveState.m_204336_(BzTags.SENTRY_WATCHER_ALWAYS_DESTROY)) continue;
                ++alwaysDestroyCounter;
            }
            if (canDemolish && (alwaysDestroyCounter == demolishPos.size() || totalhardness < 20.0)) {
                for (BlockPos pos : demolishPos) {
                    this.m_9236_().m_46961_(pos, true);
                }
                this.f_19862_ = false;
            }
        }
    }

    private Vec3 collide(Vec3 incomingSpeed) {
        boolean zCollided;
        AABB sentryBoundingBox = this.m_20191_();
        ArrayList shapesCollidedWith = new ArrayList();
        boolean isNotMoving = incomingSpeed.m_82556_() == 0.0;
        Vec3 collidedVelocity = isNotMoving ? incomingSpeed : SentryWatcherEntity.m_198894_((Entity)this, (Vec3)incomingSpeed, (AABB)sentryBoundingBox, (Level)this.m_9236_(), shapesCollidedWith);
        boolean xCollided = incomingSpeed.f_82479_ != collidedVelocity.f_82479_;
        boolean bl = zCollided = incomingSpeed.f_82481_ != collidedVelocity.f_82481_;
        if (this.m_274421_() > 0.0f && (xCollided || zCollided)) {
            Vec3 vec35;
            Vec3 vec33 = SentryWatcherEntity.m_198894_((Entity)this, (Vec3)new Vec3(incomingSpeed.f_82479_, (double)this.m_274421_(), incomingSpeed.f_82481_), (AABB)sentryBoundingBox, (Level)this.m_9236_(), shapesCollidedWith);
            Vec3 vec34 = SentryWatcherEntity.m_198894_((Entity)this, (Vec3)new Vec3(0.0, (double)this.m_274421_(), 0.0), (AABB)sentryBoundingBox.m_82363_(incomingSpeed.f_82479_, 0.0, incomingSpeed.f_82481_), (Level)this.m_9236_(), shapesCollidedWith);
            if (vec34.f_82480_ < (double)this.m_274421_() && (vec35 = SentryWatcherEntity.m_198894_((Entity)this, (Vec3)new Vec3(incomingSpeed.f_82479_, 0.0, incomingSpeed.f_82481_), (AABB)sentryBoundingBox.m_82383_(vec34), (Level)this.m_9236_(), shapesCollidedWith).m_82549_(vec34)).m_165925_() > vec33.m_165925_()) {
                vec33 = vec35;
            }
            if (vec33.m_165925_() > collidedVelocity.m_165925_()) {
                return vec33.m_82549_(SentryWatcherEntity.m_198894_((Entity)this, (Vec3)new Vec3(0.0, -vec33.f_82480_ + incomingSpeed.f_82480_, 0.0), (AABB)sentryBoundingBox.m_82383_(vec33), (Level)this.m_9236_(), shapesCollidedWith));
            }
        }
        return collidedVelocity;
    }

    public void m_6453_(double d, double e, double f, float g, float h, int i, boolean bl) {
        this.lerpX = d;
        this.lerpY = e;
        this.lerpZ = f;
        this.lerpYRot = g;
        this.lerpXRot = h;
        this.lerpSteps = i;
    }

    public boolean m_6072_() {
        return false;
    }

    public float m_213816_() {
        return this.m_146908_();
    }

    protected boolean isImmobile() {
        return false;
    }
}

