/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.controllers;

import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class HoneySlimeMoveController
extends MoveControl {
    private float targetYaw;
    private int jumpDelay;
    private final HoneySlimeEntity slime;
    private boolean isAggressive;

    public HoneySlimeMoveController(HoneySlimeEntity slimeIn) {
        super((Mob)slimeIn);
        this.slime = slimeIn;
        this.targetYaw = 180.0f * slimeIn.m_146908_() / (float)Math.PI;
    }

    public void setDirection(float yRotIn, boolean aggressive) {
        this.targetYaw = yRotIn;
        this.isAggressive = aggressive;
    }

    public void setDirection(float yRotIn) {
        this.targetYaw = yRotIn;
        this.isAggressive = true;
    }

    public void setSpeed(double speedIn) {
        this.f_24978_ = speedIn;
        this.f_24981_ = MoveControl.Operation.MOVE_TO;
    }

    public void m_8126_() {
        this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.targetYaw, 90.0f));
        this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
        this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
        if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
            this.f_24974_.m_21564_(0.0f);
        } else {
            this.f_24981_ = MoveControl.Operation.WAIT;
            if (this.f_24974_.m_20096_()) {
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21051_(Attributes.f_22278_).m_22135_()));
                if (this.jumpDelay-- <= 0) {
                    this.jumpDelay = this.slime.getJumpDelay();
                    if (this.isAggressive) {
                        this.jumpDelay /= 4;
                    }
                    this.slime.m_21569_().m_24901_();
                    if (this.slime.makesSoundOnJump()) {
                        this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_(), ((this.slime.m_217043_().m_188501_() - this.slime.m_217043_().m_188501_()) * 0.2f + 1.0f) * 0.8f);
                    }
                } else {
                    this.slime.f_20900_ = 0.0f;
                    this.slime.f_20902_ = 0.0f;
                    this.f_24974_.m_7910_(0.0f);
                }
            } else {
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21051_(Attributes.f_22279_).m_22135_()));
            }
        }
    }
}

