/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.blocks.HoneyCocoon;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.BzRandomizableContainerBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.menus.StrictChestMenu;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneyCocoonBlockEntity
extends BzRandomizableContainerBlockEntity {
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)18, (Object)ItemStack.f_41583_);
    private UUID blockEntityUuid = null;

    protected HoneyCocoonBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public HoneyCocoonBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(BzBlockEntities.HONEY_COCOON.get(), blockPos, blockState);
    }

    public int m_6643_() {
        return this.itemStacks.size();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.the_bumblezone.honey_cocoon");
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.loadFromTag(tag);
    }

    public void loadFromTag(CompoundTag compoundTag) {
        this.itemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compoundTag) && compoundTag.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.itemStacks);
        }
        if (compoundTag.m_128403_("blockEntityUuid")) {
            this.blockEntityUuid = compoundTag.m_128342_("blockEntityUuid");
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.itemStacks);
        }
        tag.m_128362_("blockEntityUuid", this.getBlockEntityUuid());
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, HoneyCocoonBlockEntity honeyCocoonBlockEntity) {
        if (level instanceof ServerLevel) {
            boolean lootrActive;
            ServerLevel serverLevel = (ServerLevel)level;
            boolean bl = lootrActive = ModChecker.lootrPresent && BzModCompatibilityConfigs.allowLootrCompat;
            if (honeyCocoonBlockEntity.getLootTable() != null && (Boolean)blockState.m_61143_((Property)HoneyCocoon.IS_LOOT_CONTAINER) != lootrActive) {
                serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)HoneyCocoon.IS_LOOT_CONTAINER, (Comparable)Boolean.valueOf(lootrActive)), 2);
            }
        }
    }

    protected NonNullList<ItemStack> m_7086_() {
        if (this.isLootWithLootrOn()) {
            return NonNullList.m_122779_();
        }
        return this.itemStacks;
    }

    protected void m_6520_(@NotNull NonNullList<ItemStack> itemStacks) {
        if (this.isLootWithLootrOn()) {
            return;
        }
        this.itemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.itemStacks.size(); ++i) {
            if (i >= itemStacks.size()) continue;
            this.itemStacks.set(0, (Object)((ItemStack)itemStacks.get(i)));
        }
    }

    public ItemStack m_8020_(int slotIndex) {
        if (this.isLootWithLootrOn()) {
            return ItemStack.f_41583_;
        }
        return super.m_8020_(slotIndex);
    }

    public ItemStack m_7407_(int slotIndex, int removeAmount) {
        if (this.isLootWithLootrOn()) {
            return ItemStack.f_41583_;
        }
        return super.m_7407_(slotIndex, removeAmount);
    }

    public ItemStack m_8016_(int slotIndex) {
        if (this.isLootWithLootrOn()) {
            return ItemStack.f_41583_;
        }
        return super.m_8016_(slotIndex);
    }

    public void m_6836_(int slotIndex, ItemStack itemStack) {
        if (this.isLootWithLootrOn()) {
            return;
        }
        super.m_6836_(slotIndex, itemStack);
    }

    private boolean isLootWithLootrOn() {
        if (this.getLootTable() == null || !ModChecker.lootrPresent || !BzModCompatibilityConfigs.allowLootrCompat) {
            return false;
        }
        BlockState state = this.m_58900_();
        return state.m_60713_(BzBlocks.HONEY_COCOON.get()) && (Boolean)state.m_61143_((Property)HoneyCocoon.IS_LOOT_CONTAINER) != false;
    }

    protected AbstractContainerMenu m_6555_(int slot, @NotNull Inventory inventory) {
        return new StrictChestMenu(BzMenuTypes.STRICT_9x2.get(), slot, inventory, (Container)this, this.m_6643_() / 9);
    }

    public int[] m_7071_(@NotNull Direction direction) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    @Override
    public Direction getInputDirection() {
        return Direction.UP;
    }

    @Override
    public boolean m_7155_(int i, @NotNull ItemStack stack, Direction direction) {
        if (this.isLootWithLootrOn()) {
            return false;
        }
        return super.m_7155_(i, stack, direction);
    }

    @Override
    public boolean m_7157_(int i, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (this.isLootWithLootrOn()) {
            return false;
        }
        return super.m_7157_(i, stack, direction);
    }

    public boolean m_7531_(int i, int i1) {
        if (i == 1) {
            return true;
        }
        return super.m_7531_(i, i1);
    }

    public boolean isUnpackedLoottable() {
        return this.f_59605_ == null;
    }

    public void m_59640_(Player player) {
        BlockState blockState;
        if (ModChecker.lootrPresent && BzModCompatibilityConfigs.allowLootrCompat) {
            return;
        }
        super.m_59640_(player);
        if (this.f_58857_ != null && (blockState = this.f_58857_.m_8055_(this.f_58858_)).m_60713_(BzBlocks.HONEY_COCOON.get()) && ((Boolean)blockState.m_61143_((Property)HoneyCocoon.WATERLOGGED)).booleanValue()) {
            this.f_58857_.m_186469_(this.f_58858_, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), BzFluids.SUGAR_WATER_FLUID.get().m_6718_((LevelReader)this.f_58857_));
            this.f_58857_.m_186460_(this.f_58858_, blockState.m_60734_(), 150);
        }
    }

    public UUID getBlockEntityUuid() {
        if (this.blockEntityUuid == null) {
            this.blockEntityUuid = UUID.randomUUID();
        }
        return this.blockEntityUuid;
    }

    @Nullable
    public ResourceLocation getLootTable() {
        return this.f_59605_;
    }

    public long getLootSeed() {
        return this.f_59606_;
    }
}

