/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import net.mehvahdjukaar.supplementaries.common.entities.RopeArrowEntity;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class RopeArrowItem
extends ArrowItem {
    public RopeArrowItem(Item.Properties builder) {
        super(builder);
    }

    public AbstractArrow m_6394_(Level world, ItemStack stack, LivingEntity shooter) {
        int charges = RopeArrowItem.getRopes(stack);
        return new RopeArrowEntity(world, shooter, charges);
    }

    public static int getRopes(ItemStack stack) {
        return stack.m_41776_() - stack.m_41773_();
    }

    public static void addRopes(ItemStack stack, int ropes) {
        stack.m_41721_(stack.m_41773_() - ropes);
    }

    public static int getRopeCapacity() {
        return CommonConfigs.Tools.ROPE_ARROW_CAPACITY.get();
    }

    public static boolean isValidRope(ItemStack stack) {
        return stack.m_204117_(ModTags.ROPES);
    }

    public int getMaxDamage(ItemStack stack) {
        return RopeArrowItem.getRopeCapacity();
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, Player player) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)this.getMaxDamage(stack));
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public int m_142159_(ItemStack stack) {
        return 7294006;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237110_((String)"message.supplementaries.rope_arrow_tooltip", (Object[])new Object[]{RopeArrowItem.getRopes(stack), RopeArrowItem.getRopeCapacity()}));
        if (worldIn == null) {
            return;
        }
        if (!MiscUtils.showsHints((BlockGetter)worldIn, flagIn)) {
            return;
        }
        Holder.Reference<Block> override = CommonConfigs.getRopeOverride();
        if (override != null) {
            tooltip.add((Component)Component.m_237110_((String)"message.supplementaries.rope_arrow", (Object[])new Object[]{override.m_205785_().m_135782_().toString()}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_142207_(ItemStack ropeArrow, Slot pSlot, ClickAction pAction, Player pPlayer) {
        ItemStack itemstack;
        if (pAction != ClickAction.SECONDARY && RopeArrowItem.isValidRope(itemstack = pSlot.m_7993_())) {
            float ropes = RopeArrowItem.getRopes(ropeArrow);
            int missingRope = (int)((float)ropeArrow.m_41776_() - ropes);
            if (missingRope != 0) {
                ItemStack ropeTaken = pSlot.m_150647_(itemstack.m_41613_(), missingRope, pPlayer);
                int ropeWeCanAdd = Math.min(missingRope, ropeTaken.m_41613_());
                RopeArrowItem.addRopes(ropeArrow, ropeWeCanAdd);
                this.playInsertSound((Entity)pPlayer);
                return true;
            }
        }
        return false;
    }

    public boolean m_142305_(ItemStack ropeArrow, ItemStack ropeStack, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(pPlayer) && RopeArrowItem.isValidRope(ropeStack)) {
            float ropes = RopeArrowItem.getRopes(ropeArrow);
            int missingRope = (int)((float)ropeArrow.m_41776_() - ropes);
            if (missingRope != 0) {
                int ropeWeCanAdd = Math.min(missingRope, ropeStack.m_41613_());
                RopeArrowItem.addRopes(ropeArrow, ropeWeCanAdd);
                ropeStack.m_41774_(ropeWeCanAdd);
                this.playInsertSound((Entity)pPlayer);
                return true;
            }
        }
        return false;
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(ModSounds.ROPE_PLACE.get(), 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

