/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GunpowderBlock;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteLiquidBlock;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.SoulFiredCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FlammableLiquidBlock
extends FiniteLiquidBlock
implements ILightable {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public final VoxelShape[] interactionShapes = (VoxelShape[])IntStream.range(0, 16).mapToObj(i -> FlammableLiquidBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)Math.max(0.0f, 15.0f * (1.0f - (float)i / (float)this.maxLevel)), (double)16.0)).toArray(VoxelShape[]::new);

    public FlammableLiquidBlock(Supplier<? extends FiniteFluid> supplier, BlockBehaviour.Properties arg, int baseLight) {
        super(supplier, arg.m_60953_(state -> (Integer)state.m_61143_((Property)AGE) > baseLight ? 15 : 0));
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    @Override
    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE});
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return FireStage.fromAge((Integer)state.m_61143_((Property)AGE)).isBurning() ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            MiscUtils.scheduleTickOverridingExisting(sl, pos, this, this.getReactToFireDelay());
        }
    }

    @Override
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(state, world, pos, oldState, moving);
        if (!oldState.m_60713_(state.m_60734_()) && world instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)world;
            MiscUtils.scheduleTickOverridingExisting(sl, pos, this, this.getReactToFireDelay());
        }
    }

    protected int getReactToFireDelay() {
        return 2;
    }

    protected int getFireTickDelay(RandomSource random) {
        return 30 + random.m_188503_(10);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return this.interactWithPlayer(state, worldIn, pos, player, handIn);
    }

    public boolean lightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor level, ILightable.FireSourceType fireSourceType) {
        if (FlammableLiquidBlock.shouldNotHaveFire(state, pos, level)) {
            return false;
        }
        boolean success = super.lightUp(player, state, pos, level, fireSourceType);
        if (success && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            MiscUtils.scheduleTickOverridingExisting(sl, pos, this, this.getReactToFireDelay());
        }
        return success;
    }

    public static boolean shouldNotHaveFire(BlockState state, BlockPos pos, LevelAccessor levelAccessor) {
        return levelAccessor.m_6425_(pos.m_7494_()).m_192917_(state.m_60819_().m_76152_());
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockState newShape = super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        if (this.isLitUp(state, (BlockGetter)level, currentPos) && FlammableLiquidBlock.shouldNotHaveFire(newShape, currentPos, level)) {
            return (BlockState)newShape.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
        }
        return newShape;
    }

    public boolean isLitUp(BlockState state, BlockGetter level, BlockPos pos) {
        return FireStage.fromAge((Integer)state.m_61143_((Property)AGE)).isBurning();
    }

    public void setLitUp(BlockState state, LevelAccessor world, BlockPos pos, boolean lit) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(lit ? 1 : 0)), 3);
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.isLitUp(state, level, pos) ? this.interactionShapes[(Integer)state.m_61143_((Property)MISSING_LEVELS)] : super.m_5940_(state, level, pos, context);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.interactionShapes[(Integer)state.m_61143_((Property)MISSING_LEVELS)];
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult pHit, Projectile projectile) {
        BlockPos pos = pHit.m_82425_();
        this.interactWithEntity(level, state, (Entity)projectile, pos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        boolean shouldBeOnFire = false;
        for (Direction direction : context.m_6232_()) {
            if (!GunpowderBlock.canLightMeOnFire((LevelAccessor)level, pos.m_121945_(direction))) continue;
            shouldBeOnFire = true;
            break;
        }
        return (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(shouldBeOnFire ? 1 : 0));
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            this.interactWithEntity(level, state, (Entity)projectile, pos);
        }
        if (this.isLitUp(state, (BlockGetter)level, pos)) {
            if (!entity.m_5825_()) {
                if (CompatHandler.SOUL_FIRED) {
                    SoulFiredCompat.setOnFire(entity, 8);
                } else {
                    entity.m_7311_(entity.m_20094_() + 1);
                    if (entity.m_20094_() == 0) {
                        entity.m_20254_(8);
                    }
                }
            }
            entity.m_6469_(level.m_269111_().m_269387_(), 1.0f);
        } else if (entity.m_6060_()) {
            this.lightUp(entity, state, pos, (LevelAccessor)level, ILightable.FireSourceType.FLAMING_ARROW);
        }
        Integer duration = CommonConfigs.Functional.FLAMMABLE_FROM_LUMISENE.get();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            if (duration > 0) {
                le.m_7292_(new MobEffectInstance(ModRegistry.FLAMMABLE.get(), duration.intValue(), 0, false, false));
            }
        }
        super.m_7892_(state, level, pos, entity);
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.m_5776_() && this.isLitUp(state, (BlockGetter)level, pos)) {
            level.m_5898_(null, 1009, pos, 0);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!this.isLitUp(state, (BlockGetter)level, pos)) {
            return;
        }
        if (random.m_188503_(24) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        double baseY = (float)Math.max((age + 1) / 5, 1) * 0.5f;
        for (int i = 0; i < 3; ++i) {
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)pos.m_123342_() + random.m_188500_() * 0.25 + baseY;
            double z = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!SuppPlatformStuff.canCatchFire(level, pos.m_121945_(direction), direction)) continue;
            for (int i = 0; i < 2; ++i) {
                Vector3f step = direction.m_253071_();
                double x = (double)pos.m_123341_() + 0.5 + (double)step.x * 0.5 + (step.x == 0.0f ? random.m_188500_() - 0.5 : (double)(-step.x) * random.m_188500_() * 0.1);
                double y = (double)pos.m_123342_() + 0.5 + (double)step.y * 0.5 + (step.y == 0.0f ? random.m_188500_() - 0.5 : (double)(-step.y) * random.m_188500_() * 0.1);
                double z = (double)pos.m_123343_() + 0.5 + (double)step.z * 0.5 + (step.z == 0.0f ? random.m_188500_() - 0.5 : (double)(-step.z) * random.m_188500_() * 0.1);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.m_46469_().m_46207_(GameRules.f_46131_)) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        FireStage stage = FireStage.fromAge(age);
        if (stage == FireStage.OFF) {
            for (Direction dir : Direction.values()) {
                if (dir == Direction.DOWN || !GunpowderBlock.canLightMeOnFire((LevelAccessor)level, pos.m_121945_(dir))) continue;
                this.lightUp(null, state, pos, (LevelAccessor)level, ILightable.FireSourceType.FLAMING_ARROW);
                return;
            }
            return;
        }
        if (stage == FireStage.RISING) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 3);
            MiscUtils.scheduleTickOverridingExisting(level, pos, this, this.getReactToFireDelay());
            return;
        }
        if (stage == FireStage.DYING) {
            int missingLayers = (Integer)state.m_61143_((Property)MISSING_LEVELS);
            if (missingLayers == 15) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                if (SuppPlatformStuff.canCatchFire((Level)level, pos.m_7495_(), Direction.UP)) {
                    int newAge = random.m_188503_(8);
                    level.m_7731_(pos, FlammableLiquidBlock.getFireDelegate().m_53437_((LevelAccessor)level, pos, newAge), 3);
                }
                return;
            }
            level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)MISSING_LEVELS, (Comparable)Integer.valueOf(missingLayers + 1))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(4)));
            level.m_186460_(pos, (Block)this, this.getFireTickDelay(level.f_46441_));
            return;
        }
        if (stage == FireStage.RAGING) {
            level.m_186460_(pos, (Block)this, this.getFireTickDelay(level.f_46441_));
            int ageAdd = random.m_188503_(3) / 2;
            int ageIncrease = Math.min(15, age + ageAdd);
            if (age != ageIncrease) {
                state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(ageIncrease));
                level.m_7731_(pos, state, 4);
            }
            FlammableLiquidBlock.burnStuffAroundLikeFire(state, level, pos, random, age);
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.isLitUp(state, level, pos) ? 0 : 60;
    }

    private static void burnStuffAroundLikeFire(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, int age) {
        boolean increaseFireBurnout = level.m_204166_(pos).m_203656_(BiomeTags.f_263839_);
        int extraChance = increaseFireBurnout ? -50 : 0;
        SuppPlatformStuff.tryBurningByFire(level, pos.m_122029_(), 300 + extraChance, random, age, Direction.WEST);
        SuppPlatformStuff.tryBurningByFire(level, pos.m_122024_(), 300 + extraChance, random, age, Direction.EAST);
        SuppPlatformStuff.tryBurningByFire(level, pos.m_7494_(), 250 + extraChance, random, age, Direction.DOWN);
        SuppPlatformStuff.tryBurningByFire(level, pos.m_122012_(), 300 + extraChance, random, age, Direction.SOUTH);
        SuppPlatformStuff.tryBurningByFire(level, pos.m_122019_(), 300 + extraChance, random, age, Direction.NORTH);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 4; ++dy) {
                    Block block;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    int chance = 100;
                    if (dy > 1) {
                        chance += (dy - 1) * 100;
                    }
                    mutableBlockPos.m_122154_((Vec3i)pos, dx, dy, dz);
                    FireBlock fireBlock = FlammableLiquidBlock.getFireDelegate();
                    int igniteOdds = fireBlock.m_221156_((LevelReader)level, (BlockPos)mutableBlockPos);
                    boolean isLumisene = false;
                    if (igniteOdds == 0 && (dy != 0 || dx != 0 && dz != 0)) {
                        BlockState nextState = level.m_8055_(pos);
                        if (state.m_60734_() instanceof FlammableLiquidBlock) {
                            igniteOdds = PlatHelper.getFireSpreadSpeed((BlockState)nextState, (BlockGetter)level, (BlockPos)pos, (Direction)Direction.UP);
                            isLumisene = true;
                        }
                    }
                    if (igniteOdds <= 0) continue;
                    int i2 = (igniteOdds + 40 + level.m_46791_().m_19028_() * 7) / (age + 30);
                    if (increaseFireBurnout) {
                        i2 /= 2;
                    }
                    if (i2 <= 0 || random.m_188503_(chance) > i2 || level.m_46471_() && fireBlock.m_53428_((Level)level, (BlockPos)mutableBlockPos)) continue;
                    int newAge = Math.min(15, age + random.m_188503_(5) / 4);
                    if (isLumisene && (block = level.m_8055_(pos).m_60734_()) instanceof FlammableLiquidBlock) {
                        FlammableLiquidBlock fl = (FlammableLiquidBlock)block;
                        fl.lightUp(null, state, pos, (LevelAccessor)level, ILightable.FireSourceType.FLAMING_ARROW);
                        continue;
                    }
                    level.m_7731_((BlockPos)mutableBlockPos, fireBlock.m_53437_((LevelAccessor)level, (BlockPos)mutableBlockPos, newAge), 3);
                }
            }
        }
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        if (this.isLitUp(state, level, pos)) {
            return BlockPathTypes.DAMAGE_FIRE;
        }
        return null;
    }

    @Nullable
    public BlockPathTypes getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, BlockPathTypes originalType) {
        if (this.isLitUp(state, level, pos)) {
            return BlockPathTypes.DAMAGE_FIRE;
        }
        return null;
    }

    @NotNull
    private static FireBlock getFireDelegate() {
        return (FireBlock)Blocks.f_50083_;
    }

    public static enum FireStage {
        OFF,
        RISING,
        RAGING,
        DYING;


        public boolean isBurning() {
            return this != OFF;
        }

        public static FireStage fromAge(int age) {
            if (age == 0) {
                return OFF;
            }
            if (age == 15) {
                return DYING;
            }
            if (age < 4) {
                return RISING;
            }
            return RAGING;
        }
    }
}

