/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GlobeBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobeBlockTile
extends BlockEntity
implements Nameable {
    private static final Pair<GlobeManager.Model, @Nullable ResourceLocation> DEFAULT_DATA = Pair.of((Object)((Object)GlobeManager.Model.GLOBE), null);
    private final boolean sepia;
    private boolean sheared = false;
    private Component customName;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private Pair<GlobeManager.Model, @Nullable ResourceLocation> renderData = DEFAULT_DATA;

    public GlobeBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.GLOBE_TILE.get(), pos, state);
        this.sepia = state.m_60713_(ModRegistry.GLOBE_SEPIA.get());
    }

    public int getFaceRot() {
        return (3 - (Integer)this.m_58900_().m_61143_((Property)GlobeBlock.ROTATION)) * 90;
    }

    public float getRotation(float partialTicks) {
        int face = this.getFaceRot();
        return Mth.m_14179_((float)partialTicks, (float)(this.prevYaw + (float)face), (float)(this.yaw + (float)face));
    }

    @NotNull
    public Pair<GlobeManager.Model, ResourceLocation> getRenderData() {
        return this.renderData;
    }

    public boolean isSepia() {
        return this.sepia;
    }

    public void setCustomName(Component name) {
        this.customName = name;
        this.updateRenderData();
    }

    public void toggleShearing() {
        this.sheared = !this.sheared;
        this.updateRenderData();
    }

    private void updateRenderData() {
        Pair<GlobeManager.Model, ResourceLocation> customData;
        this.renderData = this.sheared ? Pair.of((Object)((Object)GlobeManager.Model.SHEARED), (Object)(this.sepia ? ModTextures.GLOBE_SHEARED_SEPIA_TEXTURE : ModTextures.GLOBE_SHEARED_TEXTURE)) : (this.m_8077_() ? ((customData = GlobeManager.Type.getModelAndTexture(this.m_7770_().getString())) != null ? customData : DEFAULT_DATA) : DEFAULT_DATA);
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public Component getDefaultName() {
        return Component.m_237115_((String)"block.supplementaries.globe");
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("CustomName", 8)) {
            this.setCustomName((Component)Component.Serializer.m_130701_((String)compound.m_128461_("CustomName")));
        }
        this.yaw = compound.m_128457_("Yaw");
        this.sheared = compound.m_128471_("Sheared");
        super.m_142466_(compound);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.updateRenderData();
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        tag.m_128350_("Yaw", this.yaw);
        tag.m_128379_("Sheared", this.sheared);
    }

    public void spin() {
        int spin = 360;
        int inc = 90;
        int face = (this.getFaceRot() - inc + 360) % 360;
        this.yaw = this.yaw + (float)spin + (float)inc;
        this.prevYaw = this.prevYaw + (float)spin + (float)inc;
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)GlobeBlock.ROTATION, (Comparable)Integer.valueOf(3 - face / 90)));
        this.m_6596_();
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.spin();
            this.f_58857_.m_5594_(null, this.f_58858_, ModSounds.GLOBE_SPIN.get(), SoundSource.BLOCKS, 0.65f, MthUtils.nextWeighted((RandomSource)this.f_58857_.f_46441_, (float)0.2f) + 0.9f);
            return true;
        }
        if (id == 2) {
            this.f_58857_.m_142052_(this.f_58858_, this.m_58900_());
            return true;
        }
        return super.m_7531_(id, type);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, GlobeBlockTile tile) {
        tile.prevYaw = tile.yaw;
        if (tile.yaw != 0.0f) {
            if (tile.yaw < 0.0f) {
                tile.yaw = 0.0f;
                pLevel.m_46717_(pPos, pState.m_60734_());
            } else {
                tile.yaw = tile.yaw * 0.94f - 0.7f;
            }
        }
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)GlobeBlock.FACING);
    }

    public boolean isSpinningVeryFast() {
        return this.yaw > 1500.0f;
    }

    public int getSignalPower() {
        if (this.yaw != 0.0f) {
            return 15;
        }
        return this.getFaceRot() / 90 + 1;
    }
}

