/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.color;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TippedSpikesColor
implements BlockColor,
ItemColor {
    private static final ThreadLocal<Int2IntMap> CACHED_COLORS_0 = ThreadLocal.withInitial(Int2IntOpenHashMap::new);
    private static final ThreadLocal<Int2IntMap> CACHED_COLORS_1 = ThreadLocal.withInitial(Int2IntOpenHashMap::new);

    private static int getCachedColor(int base, int tint) {
        return switch (tint) {
            default -> -1;
            case 1 -> CACHED_COLORS_0.get().computeIfAbsent(base, b -> TippedSpikesColor.getProcessedColor(base, 0));
            case 2 -> CACHED_COLORS_1.get().computeIfAbsent(base, b -> TippedSpikesColor.getProcessedColor(base, 1));
        };
    }

    public int m_92566_(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tint) {
        if (world != null && pos != null) {
            Level level;
            BlockEntity blockEntity;
            BlockEntity blockEntity2 = world.m_7702_(pos);
            if (blockEntity2 instanceof BambooSpikesBlockTile) {
                BambooSpikesBlockTile tile = (BambooSpikesBlockTile)blockEntity2;
                int color = tile.getColor();
                return TippedSpikesColor.getCachedColor(color, tint);
            }
            if (CompatHandler.QUARK && world instanceof Level && (blockEntity = QuarkCompat.getMovingBlockEntity(pos, state, level = (Level)world)) instanceof BambooSpikesBlockTile) {
                BambooSpikesBlockTile tile = (BambooSpikesBlockTile)blockEntity;
                int color = tile.getColor();
                return TippedSpikesColor.getCachedColor(color, tint);
            }
        }
        return 0xFFFFFF;
    }

    public int m_92671_(ItemStack stack, int tint) {
        if (tint == 0) {
            return 0xFFFFFF;
        }
        return TippedSpikesColor.getCachedColor(PotionUtils.m_43575_((ItemStack)stack), tint);
    }

    private static int getProcessedColor(int rgb, int tint) {
        HSLColor hsl = new RGBColor(rgb).asHSL();
        float h = hsl.hue();
        if (tint == 1) {
            boolean b = h > 0.16667f && h < 0.6667f;
            float i = b ? -0.04f : 0.04f;
            h = (h + i) % 1.0f;
        }
        hsl = ColorHelper.prettyfyColor(hsl.withHue(h));
        float s = hsl.saturation();
        s = tint == 0 ? s * 0.81f : s * 0.74f;
        return hsl.withSaturation(s).asRGB().toInt();
    }
}

