/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.forge.compat.skinshuffle;

import io.netty.buffer.Unpooled;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleCompatibility;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleHandshakePayload;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshPayload;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshV1Payload;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshV2Payload;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;

public class SkinShufflePacketHandler {
    private static final EventNetworkChannel HANDSHAKE_INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)SkinShuffleHandshakePayload.PACKET_ID).clientAcceptedVersions(NetworkRegistry.acceptMissingOr((String)"")).serverAcceptedVersions(NetworkRegistry.acceptMissingOr((String)"")).networkProtocolVersion(() -> "").eventNetworkChannel();
    private static final EventNetworkChannel SKIN_REFRESH_V1_INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)SkinShuffleSkinRefreshV1Payload.PACKET_ID).clientAcceptedVersions(NetworkRegistry.acceptMissingOr((String)"")).serverAcceptedVersions(NetworkRegistry.acceptMissingOr((String)"")).networkProtocolVersion(() -> "").eventNetworkChannel();
    private static final EventNetworkChannel SKIN_REFRESH_V2_INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)SkinShuffleSkinRefreshV2Payload.PACKET_ID).clientAcceptedVersions(NetworkRegistry.acceptMissingOr((String)"")).serverAcceptedVersions(NetworkRegistry.acceptMissingOr((String)"")).networkProtocolVersion(() -> "").eventNetworkChannel();

    protected static void initialize() {
        SKIN_REFRESH_V1_INSTANCE.addListener(SkinShufflePacketHandler::skinRefreshV1Listener);
        SKIN_REFRESH_V2_INSTANCE.addListener(SkinShufflePacketHandler::skinRefreshV2Listener);
    }

    private SkinShufflePacketHandler() {
    }

    public static void sendHandshake(Connection connection) {
        connection.m_129512_((Packet)new ClientboundCustomPayloadPacket(SkinShuffleHandshakePayload.PACKET_ID, new FriendlyByteBuf(Unpooled.buffer((int)0, (int)0))));
    }

    private static void skinRefreshV1Listener(NetworkEvent.ClientCustomPayloadEvent event) {
        SkinShuffleSkinRefreshV1Payload payload = SkinShuffleSkinRefreshV1Payload.decode(event.getPayload());
        SkinShufflePacketHandler.handleSkinRefreshPacket(payload, (NetworkEvent.Context)event.getSource().get());
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    private static void skinRefreshV2Listener(NetworkEvent.ClientCustomPayloadEvent event) {
        SkinShuffleSkinRefreshV2Payload payload = SkinShuffleSkinRefreshV2Payload.decode(event.getPayload());
        SkinShufflePacketHandler.handleSkinRefreshPacket(payload, (NetworkEvent.Context)event.getSource().get());
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    private static void handleSkinRefreshPacket(SkinShuffleSkinRefreshPayload payload, NetworkEvent.Context context) {
        ServerPlayer sender = context.getSender();
        if (!context.getDirection().getReceptionSide().isServer() || sender == null) {
            return;
        }
        SkinShuffleCompatibility.handleSkinRefresh(sender.m_20194_(), sender, payload);
    }
}

