/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.NativeImage;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.accessor.HttpTextureAccessor;
import dev.tr7zw.skinlayers.accessor.NativeImageAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.accessor.SkullSettings;
import dev.tr7zw.skinlayers.api.SkinLayersAPI;
import dev.tr7zw.transition.mc.PlayerUtil;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class SkinUtil {
    private static Cache<AbstractTexture, NativeImage> cache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<AbstractTexture, NativeImage>(){

        public void onRemoval(RemovalNotification<AbstractTexture, NativeImage> notification) {
            try {
                ((NativeImage)notification.getValue()).close();
            }
            catch (Exception ex) {
                SkinLayersModBase.LOGGER.error("Error while closing a texture.", (Throwable)ex);
            }
        }
    }).build();

    private static NativeImage getSkinTexture(AbstractClientPlayer player) {
        return SkinUtil.getTexture(PlayerUtil.getPlayerSkin((AbstractClientPlayer)player), null);
    }

    private static NativeImage getTexture(ResourceLocation resourceLocation, SkullSettings settings) {
        try {
            NativeImageAccessor ac;
            NativeImage nativeImage;
            Optional optionalRes = Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation);
            if (optionalRes.isPresent()) {
                Resource resource = (Resource)optionalRes.get();
                NativeImage skin = NativeImage.m_85058_((InputStream)resource.m_215507_());
                return skin;
            }
            AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(resourceLocation);
            if (texture == null) {
                return null;
            }
            NativeImage cachedImage = (NativeImage)cache.getIfPresent((Object)texture);
            if (cachedImage != null && (nativeImage = cachedImage) instanceof NativeImageAccessor && (ac = (NativeImageAccessor)nativeImage).skinlayers$isAllocated()) {
                return cachedImage;
            }
            cache.invalidate((Object)texture);
            if (texture instanceof HttpTextureAccessor) {
                HttpTextureAccessor httpTexture = (HttpTextureAccessor)texture;
                try {
                    NativeImageAccessor ac2;
                    NativeImage nativeImage2;
                    NativeImage img = httpTexture.getImage();
                    if (img != null && (nativeImage2 = img) instanceof NativeImageAccessor && (ac2 = (NativeImageAccessor)nativeImage2).skinlayers$isAllocated()) {
                        cache.put((Object)texture, (Object)img);
                        return img;
                    }
                }
                catch (Exception img) {
                    // empty catch block
                }
                return null;
            }
            if (texture instanceof DynamicTexture) {
                try {
                    NativeImageAccessor ac3;
                    NativeImage nativeImage3;
                    NativeImage img = ((DynamicTexture)texture).m_117991_();
                    if (img != null && (nativeImage3 = img) instanceof NativeImageAccessor && (ac3 = (NativeImageAccessor)nativeImage3).skinlayers$isAllocated()) {
                        return img;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            settings.setInitialized(true);
            SkinLayersModBase.LOGGER.warn("Unable to handle skin " + String.valueOf(resourceLocation) + ". Potentially a conflict with another mod. (" + texture.getClass().getName() + ")");
            return null;
        }
        catch (Exception ex) {
            SkinLayersModBase.LOGGER.error("Error while resolving a skin texture.", (Throwable)ex);
            return null;
        }
    }

    public static boolean setup3dLayers(AbstractClientPlayer abstractClientPlayerEntity, PlayerSettings settings, boolean thinArms) {
        ResourceLocation skinLocation = PlayerUtil.getPlayerSkin((AbstractClientPlayer)abstractClientPlayerEntity);
        if (skinLocation == null) {
            return false;
        }
        if (skinLocation.equals((Object)settings.getCurrentSkin()) && thinArms == settings.hasThinArms()) {
            return settings.getHeadMesh() != null;
        }
        NativeImage skin = SkinUtil.getSkinTexture(abstractClientPlayerEntity);
        if (skin == null || skin.m_84982_() != 64 || skin.m_85084_() != 64) {
            settings.setCurrentSkin(skinLocation);
            settings.setThinArms(thinArms);
            settings.clearMeshes();
            return false;
        }
        settings.setLeftLegMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 4, 12, 4, 0, 48, true, 0.0f));
        settings.setRightLegMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 4, 12, 4, 0, 32, true, 0.0f));
        if (thinArms) {
            settings.setLeftArmMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 3, 12, 4, 48, 48, true, -2.0f));
            settings.setRightArmMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 3, 12, 4, 40, 32, true, -2.0f));
        } else {
            settings.setLeftArmMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 4, 12, 4, 48, 48, true, -2.0f));
            settings.setRightArmMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 4, 12, 4, 40, 32, true, -2.0f));
        }
        settings.setTorsoMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 8, 12, 4, 16, 32, true, 0.0f));
        settings.setHeadMesh(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 8, 8, 8, 32, 0, false, 0.6f));
        settings.setCurrentSkin(skinLocation);
        settings.setThinArms(thinArms);
        return true;
    }

    public static boolean setup3dLayers(GameProfile gameprofile, SkullSettings settings) {
        if (gameprofile == null) {
            return false;
        }
        ResourceLocation playerSkin = PlayerUtil.getPlayerSkin((GameProfile)gameprofile);
        if (playerSkin == null) {
            return false;
        }
        NativeImage skin = SkinUtil.getTexture(playerSkin, settings);
        if (skin == null || skin.m_84982_() != 64 || skin.m_85084_() != 64) {
            return false;
        }
        settings.setupHeadLayers(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 8, 8, 8, 32, 0, false, 0.6f));
        settings.setInitialized(true);
        return true;
    }

    public static boolean setup3dLayers(ResourceLocation playerSkin, SkullSettings settings) {
        if (playerSkin == null) {
            return false;
        }
        NativeImage skin = SkinUtil.getTexture(playerSkin, settings);
        if (skin == null || skin.m_84982_() != 64 || skin.m_85084_() != 64) {
            return false;
        }
        settings.setupHeadLayers(SkinLayersAPI.getMeshHelper().create3DMesh(skin, 8, 8, 8, 32, 0, false, 0.6f));
        settings.setInitialized(true);
        return true;
    }
}

