/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.sittingplus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.loading.FMLPaths;

public class SittingPlusConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_PATH = FMLPaths.CONFIGDIR.get().resolve("SittingPlusConfig.json").toString();
    public boolean enableClickToSit = true;
    public boolean enableThirdPersonOnSit = true;
    public boolean onlyLowerCameraInFirstPerson = false;
    public boolean enableAfkSit = true;
    public int afkSitDelaySeconds = 60;
    private static SittingPlusConfig instance;

    public static SittingPlusConfig getConfig() {
        if (instance == null) {
            instance = new SittingPlusConfig();
            instance.loadConfig();
        }
        return instance;
    }

    private void loadConfig() {
        File configFile = new File(CONFIG_FILE_PATH);
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                SittingPlusConfig loadedConfig = (SittingPlusConfig)GSON.fromJson((Reader)reader, SittingPlusConfig.class);
                if (loadedConfig != null) {
                    this.enableClickToSit = loadedConfig.enableClickToSit;
                    this.enableThirdPersonOnSit = loadedConfig.enableThirdPersonOnSit;
                    this.onlyLowerCameraInFirstPerson = loadedConfig.onlyLowerCameraInFirstPerson;
                    this.enableAfkSit = loadedConfig.enableAfkSit;
                    this.afkSitDelaySeconds = loadedConfig.afkSitDelaySeconds;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.saveConfig();
        }
    }

    public void saveConfig() {
        File configFile = new File(CONFIG_FILE_PATH);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

