/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.entity;

import com.mrcrayfish.framework.api.sync.IDataSerializer;
import com.mrcrayfish.framework.api.sync.Serializers;
import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.furniture.refurbished.core.ModEntities;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Seat
extends Entity {
    public static final SyncedClassKey<Seat> SEAT = new SyncedClassKey(Seat.class, Utils.resource("seat"));
    public static final SyncedDataKey<Seat, Boolean> LOCK_YAW = SyncedDataKey.builder(SEAT, (IDataSerializer)Serializers.BOOLEAN).id(Utils.resource("lock_yaw")).defaultValueSupplier(() -> false).syncMode(SyncedDataKey.SyncMode.TRACKING_ONLY).saveToFile().build();

    public Seat(Level level) {
        super((EntityType)ModEntities.SEAT.get(), level);
    }

    private Seat(Level level, BlockPos pos, double seatHeight, float seatYaw, boolean lockYaw) {
        this(level);
        this.m_146884_(Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, seatHeight, 0.0));
        this.m_19915_(seatYaw, 0.0f);
        LOCK_YAW.setValue((Entity)this, (Object)lockYaw);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
    }

    protected void m_7380_(CompoundTag tag) {
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (!level.m_5776_()) {
            BlockPos pos = this.m_20183_();
            if (this.m_20197_().isEmpty() || level.m_46859_(pos)) {
                this.m_146870_();
                level.m_46717_(pos, level.m_8055_(pos).m_60734_());
            }
        }
    }

    protected void m_20348_(Entity entity) {
        super.m_20348_(entity);
        entity.m_146922_(this.m_146908_());
    }

    public void m_7340_(Entity entity) {
        this.clampPassengerYaw(entity);
    }

    public Vec3 m_7688_(LivingEntity entity) {
        Direction[] sides;
        Direction front = (Boolean)LOCK_YAW.getValue((Entity)this) != false ? this.m_6350_() : entity.m_6350_();
        for (Direction side : sides = new Direction[]{front, front.m_122427_(), front.m_122428_(), front.m_122424_()}) {
            Vec3 pos = DismountHelper.m_38441_((EntityType)entity.m_6095_(), (CollisionGetter)this.m_9236_(), (BlockPos)this.m_20183_().m_121945_(side), (boolean)false);
            if (pos == null) continue;
            return pos.m_82520_(0.0, 0.25, 0.0);
        }
        return super.m_7688_(entity);
    }

    private void clampPassengerYaw(Entity entity) {
        if (((Boolean)LOCK_YAW.getValue((Entity)this)).booleanValue()) {
            entity.m_5618_(this.m_146908_());
            float wrappedYaw = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float clampedYaw = Mth.m_14036_((float)wrappedYaw, (float)-120.0f, (float)120.0f);
            entity.f_19859_ += clampedYaw - wrappedYaw;
            entity.m_146922_(entity.m_146908_() + clampedYaw - wrappedYaw);
            entity.m_5616_(entity.m_146908_());
        }
    }

    public static boolean sit(Player player, BlockPos pos, double seatHeight, @Nullable Direction direction) {
        Level level = player.m_9236_();
        if (!level.m_5776_() && Seat.availableAt(level, pos)) {
            float seatYaw = direction != null ? direction.m_122435_() : player.m_146908_();
            Seat seat = new Seat(level, pos, seatHeight, seatYaw, direction != null);
            level.m_7967_((Entity)seat);
            return player.m_20329_((Entity)seat);
        }
        return false;
    }

    public static boolean availableAt(Level level, BlockPos pos) {
        return level.m_45976_(Seat.class, new AABB(pos)).isEmpty();
    }
}

