/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GrillBlockEntityRenderer
implements BlockEntityRenderer<GrillBlockEntity> {
    private final ItemRenderer renderer;

    public GrillBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.m_234447_();
    }

    public void render(GrillBlockEntity grill, float partialTick, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
        NonNullList<ItemStack> items = grill.getCookingItems();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.m_41619_()) continue;
            this.drawCookingSpace(grill, stack, poseStack, i, partialTick, source, light, overlay);
        }
        NonNullList<ItemStack> fuel = grill.getFuelItems();
        for (int i = 0; i < fuel.size(); ++i) {
            ItemStack stack = (ItemStack)fuel.get(i);
            if (stack.m_41619_()) continue;
            this.drawFuel(grill, stack, poseStack, i, source, light, overlay);
        }
    }

    private void drawCookingSpace(GrillBlockEntity grill, ItemStack cookingStack, PoseStack poseStack, int quadrant, float partialTick, MultiBufferSource source, int light, int overlay) {
        poseStack.m_85836_();
        GrillBlockEntity.CookingSpace space = grill.getCookingSpace(quadrant);
        FlipAnimation animation = space.getAnimation();
        float time = animation.isPlaying() ? animation.getTime(partialTick) : 0.0f;
        float flipProgress = this.calculateFlipProgress(time);
        float flipHeight = 0.75f;
        poseStack.m_252880_(0.0f, flipProgress * flipHeight, 0.0f);
        poseStack.m_85837_(0.3 + 0.4 * (double)(quadrant % 2), 1.0, 0.3 + 0.4 * (double)(quadrant / 2));
        poseStack.m_252781_(Axis.f_252529_.m_252961_(1.5707964f));
        poseStack.m_252781_(Axis.f_252403_.m_252961_(1.5707964f * (float)space.getRotation()));
        poseStack.m_252781_(Axis.f_252529_.m_252961_((float)Math.PI * -3 * time));
        poseStack.m_252781_(Axis.f_252529_.m_252961_(!animation.isPlaying() && space.isFlipped() ? (float)Math.PI : 0.0f));
        poseStack.m_85841_(0.375f, 0.375f, 0.375f);
        this.renderer.m_269128_(cookingStack, ItemDisplayContext.FIXED, light, overlay, poseStack, source, grill.m_58904_(), 0);
        poseStack.m_85849_();
    }

    private void drawFuel(GrillBlockEntity grill, ItemStack fuelStack, PoseStack poseStack, int index, MultiBufferSource source, int light, int overlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.3 + 0.2 * (double)(index % 3), 0.85, 0.3 + 0.2 * (double)(index / 3));
        poseStack.m_252781_(Axis.f_252529_.m_252961_(1.5707964f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(10.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(10.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(5.0f));
        poseStack.m_85841_(0.375f, 0.375f, 0.375f);
        this.renderer.m_269128_(fuelStack, ItemDisplayContext.FIXED, light, overlay, poseStack, source, grill.m_58904_(), 0);
        poseStack.m_85849_();
    }

    private float calculateFlipProgress(float time) {
        if ((double)time <= 0.5) {
            return 1.0f - (float)Math.pow(1.0f - (time /= 0.5f), 4.0);
        }
        time -= 0.5f;
        return 1.0f - (time /= 0.5f) * time * time * time;
    }
}

