/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IProcessingBlock;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ProcessingContainerBlockEntity
extends BasicLootBlockEntity
implements IProcessingBlock {
    protected static final int[] NO_SLOTS = new int[0];
    private final RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe> inputRecipeCache;
    private final RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe>[] processRecipeCache;
    private final RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe> outputRecipeCache;
    protected int totalProcessingTime;
    protected int processingTime;
    protected int energy;

    public ProcessingContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int containerSize, RecipeType<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state, containerSize);
        this.inputRecipeCache = RecipeManager.m_220267_(recipeType);
        this.processRecipeCache = this.createCacheArray(this.getInputSlots().length, () -> RecipeManager.m_220267_((RecipeType)recipeType));
        this.outputRecipeCache = RecipeManager.m_220267_(recipeType);
    }

    protected abstract int[] getInputSlots();

    protected abstract int[] getOutputSlots();

    protected abstract int[] getEnergySlots();

    protected boolean shouldProcessAll() {
        return false;
    }

    protected int getEnergyFor(ItemStack stack) {
        return 0;
    }

    protected void onConsumeEnergy(ItemStack stack) {
    }

    protected boolean handleProcessed(ItemStack stack) {
        return false;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public void addEnergy(int energy) {
        this.energy += energy;
    }

    @Override
    public boolean requiresEnergy() {
        return this.getEnergySlots().length > 0;
    }

    @Override
    public int retrieveEnergy(boolean consume) {
        int[] slots;
        for (int slot : slots = this.getEnergySlots()) {
            int energy;
            ItemStack stack = this.m_8020_(slot);
            if (stack.m_41619_() || (energy = this.getEnergyFor(stack)) <= 0) continue;
            if (consume) {
                this.onConsumeEnergy(stack);
                stack.m_41774_(1);
            }
            return energy;
        }
        return 0;
    }

    @Override
    public int updateAndGetTotalProcessingTime() {
        int time = 0;
        int[] slots = this.getInputSlots();
        for (int i = 0; i < slots.length; ++i) {
            Optional<? extends ProcessingRecipe> optional;
            int slot = slots[i];
            ItemStack stack = this.m_8020_(slot);
            if (stack.m_41619_() || !(optional = this.getRecipe(this.processRecipeCache[i], stack)).isPresent()) continue;
            time = Math.max(time, optional.get().getTime());
            if (!this.shouldProcessAll()) break;
        }
        if (this.totalProcessingTime != time) {
            this.totalProcessingTime = time;
        }
        return this.totalProcessingTime;
    }

    @Override
    public int getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setProcessingTime(int time) {
        this.processingTime = time;
    }

    @Override
    public boolean canProcess() {
        return this.canProcessInput();
    }

    protected final boolean canProcessInput() {
        int[] slots = this.getInputSlots();
        for (int i = 0; i < slots.length; ++i) {
            int slot = slots[i];
            ItemStack stack = this.m_8020_(slot);
            if (stack.m_41619_()) continue;
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(this.processRecipeCache[i], stack);
            if (optional.isEmpty()) {
                return false;
            }
            ItemStack result = optional.get().m_8043_(this.f_58857_.m_9598_());
            if (!this.canOutput(stack, result)) {
                return false;
            }
            if (this.shouldProcessAll()) continue;
            return true;
        }
        return !this.isInputEmpty();
    }

    @Override
    public void onCompleteProcess() {
        int[] slots = this.getInputSlots();
        for (int i = 0; i < slots.length; ++i) {
            int slot = slots[i];
            ItemStack stack = this.m_8020_(slot);
            if (stack.m_41619_()) continue;
            Item remainingItem = stack.m_41720_().m_41469_();
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(this.processRecipeCache[i], stack);
            ItemStack result = optional.map(recipe -> recipe.m_8043_(this.f_58857_.m_9598_())).orElse(ItemStack.f_41583_);
            stack.m_41774_(1);
            if (!result.m_41619_()) {
                ItemStack copy = result.m_41777_();
                if (!this.handleProcessed(copy)) {
                    this.pushOutput(copy);
                }
                if (remainingItem != null) {
                    this.m_6836_(slot, new ItemStack((ItemLike)remainingItem));
                }
            }
            if (this.shouldProcessAll()) continue;
            return;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ProcessingContainerBlockEntity processor) {
        processor.processTick();
    }

    protected boolean canOutput(ItemStack input, ItemStack result) {
        int[] slots;
        if (result.m_41619_()) {
            return false;
        }
        int count = 0;
        for (int slot : slots = this.getOutputSlots()) {
            ItemStack stack = this.m_8020_(slot);
            if (stack.m_41619_()) {
                return true;
            }
            if (this.isOutputInput(slot) && input.m_41720_().m_41469_() == null) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)result, (ItemStack)stack)) continue;
            count += stack.m_41741_() - stack.m_41613_();
        }
        return count >= result.m_41613_();
    }

    protected boolean isOutputInput(int outputSlotIndex) {
        return this.m_6893_() == 1 && this.slotsContains(this.getInputSlots(), outputSlotIndex);
    }

    protected void pushOutput(ItemStack result) {
        int[] slots;
        for (int slot : slots = this.getOutputSlots()) {
            ItemStack stack = this.m_8020_(slot);
            if (stack.m_41619_()) {
                this.m_6836_(slot, result);
                return;
            }
            if (!ItemStack.m_150942_((ItemStack)result, (ItemStack)stack) || stack.m_41613_() >= stack.m_41741_()) continue;
            int count = Math.min(result.m_41613_(), stack.m_41741_() - stack.m_41613_());
            stack.m_41769_(count);
            result.m_41774_(count);
            if (!result.m_41619_()) continue;
            return;
        }
    }

    protected boolean isInputEmpty() {
        int[] slots;
        for (int slot : slots = this.getInputSlots()) {
            ItemStack stack = this.m_8020_(slot);
            if (stack.m_41619_()) continue;
            return false;
        }
        return slots.length > 0;
    }

    private Optional<? extends ProcessingRecipe> getRecipe(RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe> cache, ItemStack stack) {
        return cache.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(this.f_58857_));
    }

    public boolean isRecipe(ItemStack stack) {
        return this.inputRecipeCache.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(this.f_58857_)).isPresent();
    }

    @Override
    public boolean m_7013_(int slotIndex, ItemStack stack) {
        if (this.slotsContains(this.getInputSlots(), slotIndex)) {
            return this.isSlotInsertable(slotIndex);
        }
        if (this.slotsContains(this.getEnergySlots(), slotIndex)) {
            return this.getEnergyFor(stack) > 0 && this.isSlotInsertable(slotIndex);
        }
        return false;
    }

    public boolean m_271862_(Container container, int slotIndex, ItemStack stack) {
        if (this.slotsContains(this.getOutputSlots(), slotIndex)) {
            if (this.isOutputInput(slotIndex)) {
                return this.getRecipe(this.outputRecipeCache, stack).isEmpty();
            }
            return true;
        }
        return false;
    }

    protected boolean slotsContains(int[] slots, int slotIndex) {
        for (int slot : slots) {
            if (slot != slotIndex) continue;
            return true;
        }
        return false;
    }

    protected RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe>[] createCacheArray(int size, Supplier<RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe>> fill) {
        RecipeManager.CachedCheck[] array = new RecipeManager.CachedCheck[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = fill.get();
        }
        return array;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("MaxProcessTime", 3)) {
            this.totalProcessingTime = tag.m_128451_("MaxProcessTime");
        }
        if (tag.m_128425_("ProcessTime", 3)) {
            this.processingTime = tag.m_128451_("ProcessTime");
        }
        if (tag.m_128425_("Energy", 3)) {
            this.energy = tag.m_128451_("Energy");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("MaxProcessTime", this.totalProcessingTime);
        tag.m_128405_("ProcessTime", this.processingTime);
        tag.m_128405_("Energy", this.energy);
    }
}

