/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block.be;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.automation.block.ChuteBlock;
import org.violetmoon.quark.content.automation.module.ChuteModule;
import org.violetmoon.quark.content.building.module.GrateModule;
import org.violetmoon.zeta.block.be.ZetaBlockEntity;

public class ChuteBlockEntity
extends ZetaBlockEntity {
    private static final AABB CLEARANCE = new AABB(BlockPos.f_121853_).m_82406_(0.25).m_82386_(0.0, 0.25, 0.0);
    private final IItemHandler handler = new IItemHandler(){

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!ChuteBlockEntity.this.canDropItem()) {
                return stack;
            }
            if (!simulate && ChuteBlockEntity.this.f_58857_ != null && !stack.m_41619_()) {
                ItemEntity entity = new ItemEntity(ChuteBlockEntity.this.f_58857_, (double)ChuteBlockEntity.this.f_58858_.m_123341_() + 0.5, (double)ChuteBlockEntity.this.f_58858_.m_123342_() - 0.5, (double)ChuteBlockEntity.this.f_58858_.m_123343_() + 0.5, stack.m_41777_());
                entity.m_20334_(0.0, 0.0, 0.0);
                ChuteBlockEntity.this.f_58857_.m_7967_((Entity)entity);
            }
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }
    };

    public ChuteBlockEntity(BlockPos pos, BlockState state) {
        super(ChuteModule.blockEntityType, pos, state);
    }

    private boolean canDropItem() {
        if (this.f_58857_ != null && ((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)ChuteBlock.ENABLED)).booleanValue()) {
            BlockPos below = this.f_58858_.m_7495_();
            BlockState state = this.f_58857_.m_8055_(below);
            if (state.m_60795_()) {
                return true;
            }
            if (state.m_60713_(GrateModule.grate)) {
                return true;
            }
            VoxelShape shape = state.m_60812_((BlockGetter)this.f_58857_, below);
            if (shape.m_83281_()) {
                return true;
            }
            if (shape.m_83297_(Direction.Axis.Y) > 1.0) {
                return false;
            }
            for (AABB box : shape.m_83299_()) {
                if (!box.m_82381_(CLEARANCE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side != Direction.DOWN && cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.handler).cast();
        }
        return super.getCapability(cap, side);
    }
}

