/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.networking.forge;

import com.unlikepaladin.pfm.blocks.blockentities.MicrowaveBlockEntity;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class MicrowaveActivePacket {
    private final BlockPos entityPos;
    private final boolean active;

    public MicrowaveActivePacket(BlockPos entityPos, boolean active) {
        this.entityPos = entityPos;
        this.active = active;
    }

    public static void handle(MicrowaveActivePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            BlockPos entityPos = msg.entityPos;
            boolean active = msg.active;
            Level world = Objects.requireNonNull(player).m_20193_();
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
                if (world.m_46805_(entityPos)) {
                    MicrowaveBlockEntity microwaveBlockEntity = (MicrowaveBlockEntity)world.m_7702_(entityPos);
                    microwaveBlockEntity.setActive(active);
                } else {
                    player.m_5661_(Component.m_130674_((String)"Trying to access unloaded chunks, are you cheating?"), false);
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }

    public static void encode(MicrowaveActivePacket packet, FriendlyByteBuf buffer) {
        BlockPos entityPos = packet.entityPos;
        boolean active = packet.active;
        buffer.m_130064_(entityPos);
        buffer.writeBoolean(active);
    }

    public static MicrowaveActivePacket decode(FriendlyByteBuf buffer) {
        BlockPos entityPos = buffer.m_130135_();
        boolean active = buffer.readBoolean();
        return new MicrowaveActivePacket(entityPos, active);
    }
}

