/*
 * Decompiled with CFR 0.152.
 */
package net.mosquito.mosquievent.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.mosquito.mosquievent.entity.DuckVariant;
import net.mosquito.mosquievent.entity.ModEntities;
import net.mosquito.mosquievent.item.ModItems;
import net.mosquito.mosquievent.sound.ModSounds;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class DuckEntity
extends Animal
implements GeoAnimatable {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(DuckEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_, Items.f_271133_, Items.f_276594_});
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public int eggTime = this.f_19796_.m_188503_(6000) + 6000;
    public boolean isChickenJockey;

    public DuckEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && --this.eggTime <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)ModItems.DUCK_EGG.get());
            this.m_146850_(GameEvent.f_157810_);
            this.eggTime = this.f_19796_.m_188503_(6000) + 6000;
        }
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22283_, (double)0.7f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22265_();
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            if (!this.m_20096_() && this.m_20184_().f_82480_ < -0.001) {
                return state.setAndContinue(RawAnimation.begin().then("animation.model.falling", Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then("animation.model.walk", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("animation.model.idle", Animation.LoopType.LOOP));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return switch (this.getVariant()) {
            case DuckVariant.DUOLINGO -> (SoundEvent)ModSounds.DUO_DUCK_AMBIENT.get();
            case DuckVariant.CANARIVRE -> (SoundEvent)ModSounds.IVRE_DUCK_AMBIENT.get();
            default -> (SoundEvent)ModSounds.DUCK_AMBIENT.get();
        };
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return switch (this.getVariant()) {
            case DuckVariant.DUOLINGO -> (SoundEvent)ModSounds.DUO_DUCK_HIT.get();
            case DuckVariant.CANARIVRE -> (SoundEvent)ModSounds.IVRE_DUCK_HIT.get();
            default -> (SoundEvent)ModSounds.DUCK_HIT.get();
        };
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return switch (this.getVariant()) {
            case DuckVariant.DUOLINGO -> (SoundEvent)ModSounds.DUO_DUCK_DEATH.get();
            case DuckVariant.CANARIVRE -> (SoundEvent)ModSounds.IVRE_DUCK_DEATH.get();
            default -> (SoundEvent)ModSounds.DUCK_DEATH.get();
        };
    }

    protected float m_6121_() {
        return 0.08f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public DuckVariant getVariant() {
        if (this.m_8077_() && "Daffy".equalsIgnoreCase(this.m_7770_().getString())) {
            return DuckVariant.DAFFY;
        }
        if (this.m_8077_() && "Duck hunt".equalsIgnoreCase(this.m_7770_().getString())) {
            return DuckVariant.DUCKHUNT;
        }
        if (this.m_8077_() && "Donald".equalsIgnoreCase(this.m_7770_().getString())) {
            return DuckVariant.DONALD;
        }
        if (this.m_8077_() && "Canarivre".equalsIgnoreCase(this.m_7770_().getString())) {
            return DuckVariant.CANARIVRE;
        }
        if (this.m_8077_() && "Canarticho".equalsIgnoreCase(this.m_7770_().getString())) {
            return DuckVariant.CANARTICHO;
        }
        if (this.m_8077_() && "Repo".equalsIgnoreCase(this.m_7770_().getString())) {
            return DuckVariant.REPO;
        }
        if (this.m_8077_() && "Daisy".equalsIgnoreCase(this.m_7770_().getString())) {
            return DuckVariant.DAISY;
        }
        if (this.m_8077_() && "Psykokwak".equalsIgnoreCase(this.m_7770_().getString())) {
            return DuckVariant.PSYKOKWAK;
        }
        if (this.m_8077_() && "Duolingo".equalsIgnoreCase(this.m_7770_().getString())) {
            return DuckVariant.DUOLINGO;
        }
        if (this.m_8077_() && "Canard WC".equalsIgnoreCase(this.m_7770_().getString())) {
            return DuckVariant.CANARDWC;
        }
        return DuckVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(DuckVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(VARIANT, (Object)tag.m_128451_("Variant"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        DuckVariant[] variants = DuckVariant.values();
        DuckVariant variant = variants[this.f_19796_.m_188503_(Math.min(variants.length, 3))];
        this.setVariant(variant);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42404_);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        DuckEntity baby = (DuckEntity)((EntityType)ModEntities.DUCK.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            DuckVariant[] variants = DuckVariant.values();
            DuckVariant variant = variants[this.f_19796_.m_188503_(Math.min(variants.length, 3))];
            baby.setVariant(variant);
        }
        return baby;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        this.m_19998_((ItemLike)Items.f_42402_);
    }
}

