/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CustomMapData<H extends DirtyCounter> {
    public Type<?> getType();

    default public boolean persistOnCopyOrLock() {
        return true;
    }

    default public boolean persistOnRescale() {
        return true;
    }

    default public boolean onItemUpdate(MapItemSavedData data, Entity entity) {
        return false;
    }

    @Nullable
    default public Component onItemTooltip(MapItemSavedData data, ItemStack stack) {
        return null;
    }

    public H createDirtyCounter();

    public void load(CompoundTag var1);

    public void loadUpdateTag(CompoundTag var1);

    public void save(CompoundTag var1);

    public void saveToUpdateTag(CompoundTag var1, H var2);

    default public void setDirty(MapItemSavedData data, Consumer<H> dirtySetter) {
        Type<?> type = this.getType();
        ((ExpandedMapData)data).setCustomDataDirty(type, dirtySetter);
    }

    public record Type<T extends CustomMapData<?>>(ResourceLocation id, Supplier<T> factory) {
        @NotNull
        public T get(MapItemSavedData mapData) {
            return (T)((ExpandedMapData)mapData).getCustomData().get(this.id);
        }
    }

    public static interface DirtyCounter {
        public boolean isDirty();

        public void clearDirty();
    }

    public static class SimpleDirtyCounter
    implements DirtyCounter {
        private boolean dirty = true;

        public void markDirty() {
            this.dirty = true;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public void clearDirty() {
            this.dirty = false;
        }
    }
}

