/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.network;

import io.netty.channel.ChannelHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import ru.magistu.siegemachines.entity.machine.Machine;

@ChannelHandler.Sharable
public class PacketMachineInventorySlot {
    private final int entityid;
    private final int slot;
    private ItemStack itemstack = ItemStack.f_41583_;

    public PacketMachineInventorySlot(int entityid, int slot, ItemStack itemstack) {
        this.entityid = entityid;
        this.slot = slot;
        this.itemstack = itemstack.m_41777_();
    }

    public static PacketMachineInventorySlot read(FriendlyByteBuf buf) {
        return new PacketMachineInventorySlot(buf.readInt(), buf.readInt(), buf.m_130267_());
    }

    public static void write(PacketMachineInventorySlot message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityid);
        buf.writeInt(message.slot);
        buf.writeItemStack(message.itemstack, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(PacketMachineInventorySlot packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (packet == null || player == null || player.m_9236_() == null) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(packet.entityid);
        if (!(entity instanceof Machine)) {
            return;
        }
        Machine machine = (Machine)entity;
        machine.inventory.m_6836_(packet.slot, packet.itemstack);
    }

    public static class Handler {
        public static void handle(PacketMachineInventorySlot packet, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                context.enqueueWork(() -> PacketMachineInventorySlot.handleClientSide(packet));
            }
            context.setPacketHandled(true);
        }
    }
}

