/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.projectile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import ru.magistu.siegemachines.entity.machine.Machine;

public class MissileExplosion
extends Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private final boolean fire;
    private final Explosion.BlockInteraction blockInteraction;
    private final Random random = new Random();
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @javax.annotation.Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final List<BlockPos> toBlow = Lists.newArrayList();
    private final Map<Player, Vec3> hitPlayers = Maps.newHashMap();
    private final Vec3 position;
    private float damagemultiplier = 1.0f;

    public MissileExplosion(Level level, @javax.annotation.Nullable Entity source, double x, double y, double z, float radius) {
        this(level, source, x, y, z, radius, false, Explosion.BlockInteraction.DESTROY);
    }

    public MissileExplosion(Level level, @javax.annotation.Nullable Entity source, double x, double y, double z, float radius, List<BlockPos> pPositions) {
        this(level, source, x, y, z, radius, false, Explosion.BlockInteraction.DESTROY, pPositions);
    }

    public MissileExplosion(Level level, @javax.annotation.Nullable Entity source, double x, double y, double z, float radius, boolean fired, Explosion.BlockInteraction blockinteraction, List<BlockPos> pPositions) {
        this(level, source, x, y, z, radius, fired, blockinteraction);
        this.toBlow.addAll(pPositions);
    }

    public MissileExplosion(Level level, @javax.annotation.Nullable Entity source, double x, double y, double z, float radius, boolean fired, Explosion.BlockInteraction blockinteraction) {
        this(level, source, null, null, x, y, z, radius, fired, blockinteraction);
    }

    public MissileExplosion(Level level, @javax.annotation.Nullable Entity source, @javax.annotation.Nullable DamageSource damagesource, @javax.annotation.Nullable ExplosionDamageCalculator damagecalculator, double x, double y, double z, float radius, boolean fired, Explosion.BlockInteraction blockinteraction) {
        super(level, source, damagesource, damagecalculator, x, y, z, radius, fired, blockinteraction);
        Entity vehicle;
        this.level = level;
        this.source = source;
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.z = z;
        this.fire = fired;
        this.blockInteraction = blockinteraction;
        this.damageSource = damagesource == null ? level.m_269111_().m_269093_((Explosion)this) : damagesource;
        this.damageCalculator = damagecalculator == null ? this.makeDamageCalculator(source) : damagecalculator;
        this.position = new Vec3(this.x, this.y, this.z);
        if (source != null && source.m_20159_() && (vehicle = source.m_20202_()) instanceof Machine) {
            this.damagemultiplier = ((Float)((Machine)vehicle).f_19847_.specs.damagemultiplier.get()).floatValue();
        }
    }

    private ExplosionDamageCalculator makeDamageCalculator(@javax.annotation.Nullable Entity pEntity) {
        return pEntity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(pEntity);
    }

    public static float getSeenPercent(Vec3 pExplosionVector, Entity pEntity) {
        AABB aabb = pEntity.m_20191_();
        double d0 = 1.0 / ((aabb.f_82291_ - aabb.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((aabb.f_82292_ - aabb.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((aabb.f_82293_ - aabb.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = Mth.m_14139_((double)d5, (double)aabb.f_82288_, (double)aabb.f_82291_);
                        double d9 = Mth.m_14139_((double)d6, (double)aabb.f_82289_, (double)aabb.f_82292_);
                        double d10 = Mth.m_14139_((double)d7, (double)aabb.f_82290_, (double)aabb.f_82293_);
                        Vec3 vec3 = new Vec3(d8 + d3, d9, d10 + d4);
                        if (pEntity.m_9236_().m_45547_(new ClipContext(vec3, pExplosionVector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, pEntity)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void m_46061_() {
        this.level.m_142346_(this.source, GameEvent.f_157812_, new BlockPos((int)this.x, (int)this.y, (int)this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    for (float f = this.radius * (0.7f + this.level.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos((int)d4, (int)d6, (int)d8);
                        BlockState blockstate = this.level.m_8055_(blockpos);
                        FluidState fluidstate = this.level.m_6425_(blockpos);
                        if (!this.level.m_46739_(blockpos)) continue block2;
                        Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll(set);
        float f2 = this.radius * 2.0f;
        int k1 = Mth.m_14107_((double)(this.x - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(this.x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(this.y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(this.y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(this.z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(this.z + (double)f2 + 1.0));
        List list = this.level.m_45933_(this.source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)f2);
        Vec3 vec3 = new Vec3(this.x, this.y, this.z);
        for (Entity entity : list) {
            Player player;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            if (entity.m_6128_() || !((d12 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2) <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - this.x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * d7 + (d9 = entity.m_20189_() - this.z) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = MissileExplosion.getSeenPercent(vec3, entity);
            double d10 = (1.0 - d12) * d14;
            entity.m_6469_(this.m_46077_(), this.damagemultiplier * (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.hitPlayers.put(player, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void m_46075_(boolean pSpawnParticles) {
        boolean flag;
        if (this.level.f_46443_) {
            this.level.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.f_46441_.m_188501_() - this.level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.blockInteraction != Explosion.BlockInteraction.KEEP;
        if (pSpawnParticles) {
            if (!(this.radius < 2.0f) && flag) {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.toBlow, new Random(this.level.f_46441_.m_188502_()));
            for (BlockPos blockpos : this.toBlow) {
                BlockState blockstate = this.level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (blockstate.m_60795_()) continue;
                BlockPos blockpos1 = blockpos.m_7949_();
                this.level.m_46473_().m_6180_("explosion_blocks");
                if (blockstate.canDropFromExplosion((BlockGetter)this.level, blockpos, (Explosion)this) && this.level instanceof ServerLevel) {
                    BlockEntity blockentity = blockstate.m_155947_() ? this.level.m_7702_(blockpos) : null;
                    LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockentity).m_287289_(LootContextParams.f_81455_, (Object)this.source);
                    if (this.blockInteraction == Explosion.BlockInteraction.DESTROY) {
                        lootcontext$builder.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                    }
                    blockstate.m_287290_(lootcontext$builder).forEach(p_46074_ -> MissileExplosion.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_46074_, blockpos1));
                }
                blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
                this.level.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos blockpos2 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.m_8055_(blockpos2).m_60795_() || !this.level.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.level, blockpos2.m_7495_())) continue;
                this.level.m_46597_(blockpos2, BaseFireBlock.m_49245_((BlockGetter)this.level, (BlockPos)blockpos2));
            }
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> pDropPositionArray, ItemStack pStack, BlockPos pPos) {
        int i = pDropPositionArray.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)pDropPositionArray.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)pStack)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)pStack, (int)16);
            pDropPositionArray.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!pStack.m_41619_()) continue;
            return;
        }
        pDropPositionArray.add((Object)Pair.of((Object)pStack, (Object)pPos));
    }

    public DamageSource m_46077_() {
        return this.damageSource;
    }

    public Map<Player, Vec3> m_46078_() {
        return this.hitPlayers;
    }

    @Nullable
    public LivingEntity m_252906_() {
        Entity entity;
        if (this.source == null) {
            return null;
        }
        if (this.source instanceof PrimedTnt) {
            return ((PrimedTnt)this.source).m_19749_();
        }
        if (this.source instanceof LivingEntity) {
            return (LivingEntity)this.source;
        }
        if (this.source instanceof Projectile && (entity = ((Projectile)this.source).m_19749_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void m_46080_() {
        this.toBlow.clear();
    }

    public List<BlockPos> m_46081_() {
        return this.toBlow;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    @javax.annotation.Nullable
    public Entity getExploder() {
        return this.source;
    }
}

