/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import ru.magistu.siegemachines.entity.projectile.FlightType;
import ru.magistu.siegemachines.entity.projectile.MissileExplosion;
import ru.magistu.siegemachines.entity.projectile.MissileType;
import ru.magistu.siegemachines.item.ModItems;

public abstract class Missile
extends ThrowableItemProjectile {
    public MissileType f_19847_ = MissileType.STONE;
    public Item item = (Item)ModItems.STONE.get();

    public Missile(EntityType<? extends Missile> entitytype, Level level) {
        super(entitytype, level);
    }

    public Missile(EntityType<? extends Missile> entitytype, Level level, Vector3d pos, LivingEntity entity, MissileType type, Item item) {
        super(entitytype, entity, level);
        this.f_19847_ = type;
        this.item = item;
        this.m_6034_(pos.x, pos.y, pos.z);
    }

    @NotNull
    public Item m_7881_() {
        return this.item;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6532_(HitResult result) {
        float f = 2.0f;
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityRTR = (EntityHitResult)result;
            Vec3 pos = entityRTR.m_82450_();
            Entity entity = entityRTR.m_82443_();
            float damage = ((Float)this.f_19847_.specs.mass.get()).floatValue() * (float)this.m_20184_().m_82553_();
            DamageSource damagesource = this.m_269291_().m_269390_((Entity)this, this.m_19749_());
            if (!(this.f_19847_.armorpiercing >= 1.0f) && this.f_19847_.armorpiercing > 0.0f && entity instanceof LivingEntity) {
                Player player;
                LivingEntity livingentity = (LivingEntity)entity;
                if (livingentity instanceof Player && (player = (Player)livingentity).m_21254_() && (this.item == ModItems.GIANT_ARROW.get() || this.item == Items.f_42412_) && (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ShieldItem || player.m_21254_() && player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ShieldItem)) {
                    return;
                }
                damage -= (1.0f - this.f_19847_.armorpiercing) * (damage - CombatRules.m_19272_((float)damage, (float)0.0f, (float)0.0f));
            }
            if (!this.m_9236_().m_5776_() && this.f_19847_.explosive) {
                this.explode(pos.f_82479_, pos.f_82480_, pos.f_82481_, 3.0f, Explosion.BlockInteraction.KEEP);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            entity.m_6469_(damagesource, damage);
            Vec3 vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.f_19847_.knockback * 0.6);
            if (vector3d.m_82556_() > 0.0) {
                entity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
            }
        }
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            boolean smoothimpact;
            BlockHitResult blockRTR = (BlockHitResult)result;
            BlockPos blockpos = blockRTR.m_82425_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            boolean bl = smoothimpact = (blockstate == Blocks.f_49992_.m_49966_() || blockstate == Blocks.f_49993_.m_49966_() || blockstate == Blocks.f_50493_.m_49966_() || blockstate == Blocks.f_50440_.m_49966_() || blockstate == Blocks.f_152481_.m_49966_() || blockstate == Blocks.f_50546_.m_49966_() || blockstate == Blocks.f_50127_.m_49966_()) && blockRTR.m_82434_() == Direction.UP;
            if (blockRTR.m_82434_() == Direction.UP) {
                if (this.f_19847_.explosive) {
                    int r = 0;
                    while ((float)r < ((Float)this.f_19847_.specs.explosionpower.get()).floatValue()) {
                        float a = 0.0f;
                        while ((double)a < Math.PI * 2) {
                            BlockPos pos = blockRTR.m_82425_().m_7918_((int)((double)r * Math.cos(a)), 0, (int)((double)(-r) * Math.sin(a)));
                            if (this.m_9236_().m_8055_(pos) == Blocks.f_50440_.m_49966_()) {
                                this.m_9236_().m_46597_(pos, Blocks.f_50493_.m_49966_());
                            }
                            a = (float)((double)a + 0.7853981633974483);
                        }
                        ++r;
                    }
                }
                if (!this.m_9236_().m_5776_()) {
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    if (smoothimpact && this.f_19847_.explosive) {
                        this.explode(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), ((Float)this.f_19847_.specs.explosionpower.get()).floatValue() * f, Explosion.BlockInteraction.KEEP);
                    }
                } else if (smoothimpact) {
                    this.dustExplosion((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), blockpos, ((Float)this.f_19847_.specs.explosionpower.get()).floatValue() / 2.0f, 50);
                }
            }
            if (!this.m_9236_().m_5776_() && !smoothimpact && this.f_19847_.explosive) {
                this.explode(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), ((Float)this.f_19847_.specs.explosionpower.get()).floatValue() * f, Explosion.BlockInteraction.DESTROY);
            }
        }
        if (result.m_6662_() == HitResult.Type.MISS) {
            this.m_9236_().m_5594_((Player)this.m_19749_(), this.m_20097_(), SoundEvents.f_11664_, SoundSource.AMBIENT, 1.0f, 1.0f);
            if (!this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void dustExplosion(ParticleOptions particle, BlockPos blockpos, double speed, int amount) {
        this.dustExplosion(particle, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), speed, amount);
    }

    private void dustExplosion(ParticleOptions particle, double x, double y, double z, double speed, int amount) {
        for (int i = 0; i < amount; ++i) {
            Vec3 movement = this.m_20184_();
            double d0 = x - 0.05 + this.m_9236_().f_46441_.m_188500_() * 0.3;
            double d1 = y + 1.0;
            double d2 = z - 0.05 + this.m_9236_().f_46441_.m_188500_() * 0.3;
            double d3 = movement.f_82479_ * this.m_9236_().f_46441_.m_188500_() * speed;
            double d4 = -movement.f_82480_ * this.m_9236_().f_46441_.m_188500_() * speed * 10.0;
            double d5 = movement.f_82481_ * this.m_9236_().f_46441_.m_188500_() * speed;
            this.m_9236_().m_7106_(particle, d0, d1, d2, d3, d4, d5);
        }
    }

    public void m_8119_() {
        if (this.f_19847_.flighttype == FlightType.SPINNING) {
            this.m_146926_(this.m_146909_() + 0.5f);
        }
        super.m_8119_();
    }

    public MissileExplosion explode(double x, double y, double z, float radius, Explosion.BlockInteraction mode) {
        return this.explode(null, null, x, y, z, radius, false, mode);
    }

    public MissileExplosion explode(@Nullable DamageSource source, @Nullable ExplosionDamageCalculator context, double x, double y, double z, float size, boolean fired, Explosion.BlockInteraction mode) {
        MissileExplosion explosion = new MissileExplosion(this.m_9236_(), this.m_19749_(), source, context, x, y, z, size, fired, mode);
        if (ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion)) {
            return explosion;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        return explosion;
    }
}

