/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import ru.magistu.siegemachines.client.SoundTypes;
import ru.magistu.siegemachines.client.gui.machine.crosshair.Crosshair;
import ru.magistu.siegemachines.client.gui.machine.crosshair.ReloadingCrosshair;
import ru.magistu.siegemachines.entity.IReloading;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.machine.ShootingMachine;
import ru.magistu.siegemachines.item.ModItems;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Culverin
extends ShootingMachine
implements GeoAnimatable,
IReloading {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    static RawAnimation MOVING_ANIM = RawAnimation.begin().thenLoop("Moving");
    private double wheelspitch = 0.0;
    private double wheelsspeed = 0.0;
    private int wheelssoundticks = 10;

    public Culverin(EntityType<? extends Mob> entitytype, Level level) {
        super(entitytype, level, MachineType.CULVERIN);
        this.turretpitchprev = this.turretpitch = -18.5f;
        this.turretpitchdest = this.turretpitch;
    }

    private PlayState wheels_predicate(AnimationState<Culverin> event) {
        event.getController().setAnimation(MOVING_ANIM);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController wheels_controller = new AnimationController((GeoAnimatable)this, "wheels_controller", 1, this::wheels_predicate).setOverrideEasingType(dbl -> t -> {
            double d = this.getWheelsSpeed();
            this.wheelsspeed = d > 0.0 ? Math.min(d, 1.0) : Math.max(d, -1.0);
            return this.wheelspitch += 0.015 * this.wheelsspeed;
        });
        data.add(new AnimationController[]{wheels_controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public double getTick(Object entity) {
        return this.f_19797_;
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_().equals(Items.f_42409_)) {
            if (this.useticks < 0) {
                stack.m_41622_(1, (LivingEntity)player, p_213833_1_ -> {
                    p_213833_1_.m_21190_(hand);
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)this.f_20935_, (InteractionHand)hand);
                });
                this.startShooting((LivingEntity)player);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_().equals(Items.f_42403_)) {
            if (!this.inventory.containsItem(Items.f_42403_)) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.inventory.putItem(stack);
            }
            return InteractionResult.SUCCESS;
        }
        if (super.m_6071_(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (!this.m_9236_().m_5776_() && !this.m_20160_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_274498_(Player p_278262_, Vec3 pos) {
        if (this.m_6084_()) {
            if (this.m_20160_()) {
                LivingEntity livingentity = this.m_6688_();
                this.setTurretRotationsDest(livingentity.m_146909_(), livingentity.m_146908_() - this.getYaw());
                this.setYawDest(livingentity.m_146908_());
                this.updateYaw();
                this.updateTurretRotations();
                float f0 = livingentity.f_20900_ * 0.2f;
                float f1 = livingentity.f_20902_;
                this.m_7910_(0.02f);
                pos = new Vec3((double)f0, pos.f_82480_, (double)f1);
            }
            super.m_7023_(pos);
        }
    }

    @Override
    public void m_8119_() {
        LivingEntity passenger;
        if (this.useticks != 0 && --this.useticks <= 0) {
            if (this.inventory.containsItem(Items.f_42403_)) {
                this.useRelease();
            }
            this.useticks = 0;
        }
        if (!this.m_9236_().m_5776_() && (this.m_20096_() || this.m_20069_())) {
            this.m_20256_(this.getWheelsDeltaMovement());
        }
        if (this.delayticks > 0 && this.m_20160_()) {
            --this.delayticks;
        }
        if (this.renderupdateticks-- <= 0) {
            this.updateMachineRender();
            this.renderupdateticks = 20;
        }
        if (this.m_9236_().m_5776_() && this.m_217005_() && this.getWheelsSpeed() > 0.0081 && this.wheelssoundticks-- <= 0 && Minecraft.m_91087_().f_91074_ == (passenger = this.m_6688_())) {
            Vec3 pos = this.m_20182_();
            this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)SoundTypes.CANNON_WHEELS.get(), this.m_5720_(), 1.5f, 0.85f + this.m_9236_().f_46441_.m_188501_() * 0.3f, false);
            this.wheelssoundticks = 20;
        }
        super.m_8119_();
    }

    @Override
    public void startShooting(LivingEntity entity) {
        if (this.delayticks <= 0 && this.useticks <= 0) {
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundTypes.FUSE.get(), this.m_5720_(), this.getVolumeFromDist(this.m_20270_((Entity)entity)), 0.8f);
            }
            this.useticks = this.f_19847_.usetime;
        }
    }

    @Override
    public void shoot() {
        if (!this.m_9236_().m_5776_()) {
            super.shoot();
            this.m_20256_(this.m_20184_().m_82546_(this.getShotView().m_82490_(0.25)));
            this.f_19812_ = true;
            this.inventory.shrinkItem(Items.f_42403_);
        } else {
            this.blowParticles((ParticleOptions)ParticleTypes.f_123744_, 0.035, 25);
            this.blowParticles((ParticleOptions)ParticleTypes.f_123796_, 0.2, 60);
            Vec3 pos = this.m_20182_();
            this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)SoundTypes.CULVERIN_SHOOTING.get(), this.m_5720_(), 1.0f, 0.85f + this.m_9236_().f_46441_.m_188501_() * 0.3f, false);
        }
        this.delayticks = (Integer)this.f_19847_.specs.delaytime.get();
    }

    public double getWheelsSpeed() {
        if (this.m_20096_()) {
            return this.m_20252_(5.0f).m_82542_(1.0, 0.0, 1.0).m_82526_(this.m_20184_());
        }
        return 0.0;
    }

    public Vec3 getWheelsDeltaMovement() {
        if (this.m_20096_()) {
            Vec3 view = this.m_20252_(1.0f);
            Vec3 movement = this.m_20184_();
            double d0 = movement.f_82479_ * view.f_82479_ + movement.f_82481_ * view.f_82481_;
            double d1 = d0 * view.f_82479_;
            double d2 = 0.0;
            double d3 = d0 * view.f_82481_;
            return new Vec3(d1, d2, d3);
        }
        return Vec3.f_82478_;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Crosshair createCrosshair() {
        return new ReloadingCrosshair();
    }

    @Override
    public Item getMachineItem() {
        return (Item)ModItems.CULVERIN.get();
    }
}

