/*
 * Decompiled with CFR 0.152.
 */
package ru.magistu.siegemachines.entity.machine;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ru.magistu.siegemachines.client.SoundTypes;
import ru.magistu.siegemachines.client.gui.machine.crosshair.Crosshair;
import ru.magistu.siegemachines.client.gui.machine.crosshair.ReloadingCrosshair;
import ru.magistu.siegemachines.entity.machine.MachineType;
import ru.magistu.siegemachines.entity.machine.ShootingMachine;
import ru.magistu.siegemachines.item.ModItems;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Ballista
extends ShootingMachine
implements GeoAnimatable {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    static RawAnimation SHOOTING_ANIM = RawAnimation.begin().thenLoop("Shooting");
    static RawAnimation RELOADING_ANIM = RawAnimation.begin().thenLoop("Reloading");
    public State state = State.RELOADING;

    public Ballista(EntityType<? extends Mob> entitytype, Level level) {
        super(entitytype, level, MachineType.BALLISTA);
    }

    private PlayState predicate(AnimationState<Ballista> event) {
        switch (this.state) {
            case SHOOTING: {
                event.getController().setAnimation(SHOOTING_ANIM);
                return PlayState.CONTINUE;
            }
            case RELOADING: {
                event.getController().setAnimation(RELOADING_ANIM);
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate);
        controller.setOverrideEasingType(dbl -> t -> {
            if (this.state.equals((Object)State.RELOADING)) {
                return (double)((Integer)this.f_19847_.specs.delaytime.get() - this.delayticks) / (double)((Integer)this.f_19847_.specs.delaytime.get()).intValue();
            }
            return t;
        });
        data.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (super.m_6071_(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (!this.m_9236_().m_5776_() && !this.m_20160_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void startShooting(LivingEntity entity) {
        if (this.delayticks <= 0 && this.useticks <= 0 && this.shootingticks <= 0) {
            this.state = State.SHOOTING;
            this.useticks = this.f_19847_.usetime;
            this.shootingticks = this.f_19847_.usereleasetime;
            Vec3 pos = this.m_20182_();
            this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)SoundTypes.BALLISTA_SHOOTING.get(), this.m_5720_(), 1.4f, 1.0f, false);
        }
    }

    @Override
    public void shoot() {
        if (!this.m_9236_().m_5776_()) {
            super.shoot();
        }
    }

    public double getTick(Object entity) {
        return this.f_19797_;
    }

    protected void m_274498_(Player p_278262_, Vec3 pos) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.useticks <= 0 && this.delayticks <= 0) {
                LivingEntity livingentity = this.m_6688_();
                this.setTurretRotations(livingentity.m_146909_(), this.getTurretYaw());
                this.updateTurretRotations();
                this.setYawDest(livingentity.m_146908_());
                this.updateYaw();
            }
            super.m_7023_(pos);
        }
    }

    @Override
    public void m_8119_() {
        if (this.useticks != 0 && --this.useticks <= 0) {
            this.state = State.RELOADING;
            this.useticks = 0;
            this.delayticks = (Integer)this.f_19847_.specs.delaytime.get();
        }
        if (this.shootingticks != 0 && --this.shootingticks <= 0) {
            this.useRelease();
            this.shootingticks = 0;
        }
        if (!this.m_9236_().m_5776_() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
        }
        if (this.delayticks > 0 && this.m_20160_()) {
            if (this.delayticks % 21 == 0) {
                Vec3 pos = this.m_20182_();
                this.m_9236_().m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)SoundTypes.BALLISTA_RELOADING.get(), this.m_5720_(), 1.0f, 1.0f, false);
            }
            --this.delayticks;
        }
        if (this.renderupdateticks-- <= 0) {
            this.updateMachineRender();
            this.renderupdateticks = 20;
        }
        super.m_8119_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Crosshair createCrosshair() {
        return new ReloadingCrosshair();
    }

    @Override
    public Item getMachineItem() {
        return (Item)ModItems.BALLISTA.get();
    }

    public static enum State {
        SHOOTING,
        RELOADING;

    }
}

