/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.StructureSetAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public record RemoveStructureSetEntriesModifier(ModifierPredicate predicate, HolderSet<StructureSet> structureSets, List<Holder<Structure>> entries) implements Modifier
{
    public static final Codec<RemoveStructureSetEntriesModifier> CODEC = RecordCodecBuilder.create(instance -> Modifier.addModifierFields(instance).and(instance.group((App)LithostitchedCodecs.registrySet(Registries.f_256998_, "structure_set").forGetter(RemoveStructureSetEntriesModifier::structureSets), (App)Structure.f_226554_.listOf().fieldOf("structures").forGetter(RemoveStructureSetEntriesModifier::entries))).apply((Applicative)instance, RemoveStructureSetEntriesModifier::new));

    @Override
    public ModifierPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return Modifier.ModifierPhase.REMOVE;
    }

    @Override
    public void applyModifier() {
        this.structureSets.m_203614_().map(Holder::m_203334_).forEach(this::applyModifier);
    }

    private void applyModifier(StructureSet structureSet) {
        StructureSetAccessor structureSetAccessor = (StructureSetAccessor)structureSet;
        ArrayList structureSelectionEntries = new ArrayList(structureSet.f_210003_());
        structureSetAccessor.setStructures(structureSelectionEntries.stream().filter(setEntry -> !this.entries.contains(setEntry.f_210026_())).collect(Collectors.toList()));
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }
}

