/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.StackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ItemStackListFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<ItemStack> create(StackHelper stackHelper) {
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        boolean showHidden = clientConfig.isShowHiddenItemsEnabled();
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        HashSet<Object> itemUidSet = new HashSet<Object>();
        Minecraft minecraft = Minecraft.m_91087_();
        FeatureFlagSet features = Optional.ofNullable(minecraft.f_91074_).map(p -> p.f_108617_).map(ClientPacketListener::m_247016_).orElse(FeatureFlagSet.m_246902_());
        boolean hasOperatorItemsTabPermissions = showHidden || (Boolean)minecraft.f_91066_.m_257871_().m_231551_() != false || Optional.of(minecraft).map(m -> m.f_91074_).map(Player::m_36337_).orElse(false) != false;
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("minecraft.level must be set before JEI fetches ingredients");
        }
        RegistryAccess registryAccess = level.m_9598_();
        CreativeModeTab.ItemDisplayParameters displayParameters = new CreativeModeTab.ItemDisplayParameters(features, hasOperatorItemsTabPermissions, (HolderLookup.Provider)registryAccess);
        for (CreativeModeTab tab : CreativeModeTabs.m_257478_()) {
            Collection searchTabDisplayItems;
            Collection displayItems;
            if (tab.m_257962_() != CreativeModeTab.Type.CATEGORY) {
                LOGGER.debug("Skipping creative tab: '{}' because it is type: {}", (Object)tab.m_40786_().getString(), (Object)tab.m_257962_());
                continue;
            }
            try {
                tab.m_269498_(displayParameters);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while building contents.Items from this group will be missing from the JEI ingredient list: {}", (Object)tab.m_40786_().getString(), (Object)e);
                continue;
            }
            try {
                displayItems = tab.m_260957_();
                searchTabDisplayItems = tab.m_261235_();
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while getting search tab display items.Some items from this group will be missing from the JEI ingredient list: {}", (Object)tab.m_40786_().getString(), (Object)e);
                continue;
            }
            if (displayItems.isEmpty() && searchTabDisplayItems.isEmpty()) {
                LOGGER.warn("Item Group has no display items and no search tab display items. Items from this group will be missing from the JEI ingredient list. {}", (Object)tab.m_40786_().getString());
                continue;
            }
            ItemStackListFactory.addFromTab(displayItems, "displayItems", tab, stackHelper, itemList, itemUidSet);
            if (displayItems.equals(searchTabDisplayItems)) continue;
            ItemStackListFactory.addFromTab(searchTabDisplayItems, "searchTabDisplayItems", tab, stackHelper, itemList, itemUidSet);
        }
        if (showHidden) {
            ItemStackListFactory.addItemsFromRegistries(stackHelper, itemList, itemUidSet, features);
        }
        return itemList;
    }

    private static void addFromTab(Collection<ItemStack> tabDisplayItems, String displayType, CreativeModeTab tab, StackHelper stackHelper, List<ItemStack> itemList, Set<Object> itemUidSet) {
        HashSet<Object> tabUidSet = new HashSet<Object>();
        int added = 0;
        HashSet<Object> duplicateInTab = new HashSet<Object>();
        int duplicateInTabCount = 0;
        for (ItemStack itemStack : tabDisplayItems) {
            if (itemStack.m_41619_()) {
                LOGGER.error("Found an empty itemStack in '{}' creative tab's {}", (Object)tab, (Object)displayType);
                continue;
            }
            Object itemKey = ItemStackListFactory.safeGetUid(stackHelper, itemStack);
            if (itemKey == null) continue;
            if (tabUidSet.contains(itemKey)) {
                duplicateInTab.add(itemKey);
                ++duplicateInTabCount;
            }
            if (!itemUidSet.add(itemKey)) continue;
            tabUidSet.add(itemKey);
            itemList.add(itemStack);
            ++added;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Added {}/{} new items from '{}' creative tab's {}", (Object)StringUtils.leftPad((String)Integer.toString(added), (int)4, (char)' '), (Object)StringUtils.leftPad((String)Integer.toString(tabDisplayItems.size()), (int)4, (char)' '), (Object)tab.m_40786_().getString(), (Object)displayType);
        }
        if (duplicateInTabCount > 0) {
            Level level = Services.PLATFORM.getModHelper().isInDev() ? Level.WARN : Level.DEBUG;
            LOGGER.log(level, "{} duplicate items were found in '{}' creative tab's: {}\nThis may indicate that these types of item need a subtype interpreter added to JEI:\n{}", (Object)duplicateInTabCount, (Object)tab.m_40786_().getString(), (Object)displayType, (Object)duplicateInTab.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]")));
        }
    }

    private static void addItemsFromRegistries(StackHelper stackHelper, List<ItemStack> itemList, Set<Object> itemUidSet, FeatureFlagSet features) {
        Object itemKey;
        List<ItemStack> itemStacks = RegistryUtil.getRegistry(Registries.f_256913_).m_255303_().m_245140_(features).m_214062_().map(ItemStack::new).filter(i -> !i.m_41619_()).toList();
        int added = 0;
        for (ItemStack itemStack : itemStacks) {
            itemKey = ItemStackListFactory.safeGetUid(stackHelper, itemStack);
            if (itemKey == null || !itemUidSet.add(itemKey)) continue;
            itemList.add(itemStack);
            ++added;
        }
        LOGGER.debug("Added {}/{} new items from the item registry (this is run because ShowHiddenItems is set to true in JEI's config)", (Object)added, (Object)itemStacks.size());
        itemStacks = RegistryUtil.getRegistry(Registries.f_256747_).m_255303_().m_245140_(features).m_214062_().map(Holder.Reference::m_203334_).map(ItemStack::new).filter(i -> !i.m_41619_()).toList();
        added = 0;
        for (ItemStack itemStack : itemStacks) {
            itemKey = ItemStackListFactory.safeGetUid(stackHelper, itemStack);
            if (itemKey == null || !itemUidSet.add(itemKey)) continue;
            itemList.add(itemStack);
            ++added;
        }
        LOGGER.debug("Added {}/{} new items from the block registry (this is run because ShowHiddenItems is set to true in JEI's config)", (Object)added, (Object)itemStacks.size());
    }

    @Nullable
    private static Object safeGetUid(StackHelper stackHelper, ItemStack stack) {
        if (stackHelper.hasSubtypes(stack)) {
            try {
                return stackHelper.getUniqueIdentifierForStack(stack, UidContext.Ingredient);
            }
            catch (LinkageError | RuntimeException e) {
                String stackInfo = ErrorUtil.getItemStackInfo(stack);
                LOGGER.error("Couldn't get unique name for itemStack {}", (Object)stackInfo, (Object)e);
                return null;
            }
        }
        return stack.m_41720_();
    }
}

