/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.cache;

import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import journeymap.common.Journeymap;
import journeymap.common.nbt.cache.CacheFile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.util.ExceptionCollector;
import net.minecraft.world.level.ChunkPos;

public class CacheFileStorage
implements AutoCloseable {
    public static final String EXTENSION = ".mca";
    private static final int MAX_CACHE_SIZE = 256;
    private final Long2ObjectLinkedOpenHashMap<CacheFile> cache = new Long2ObjectLinkedOpenHashMap();
    private final Path folderPath;
    private final boolean sync;

    CacheFileStorage(Path folderPath, boolean sync) {
        this.folderPath = folderPath;
        this.sync = sync;
    }

    private CacheFile getCacheFile(ChunkPos chunkPos) throws IOException {
        long i = ChunkPos.m_45589_((int)chunkPos.m_45610_(), (int)chunkPos.m_45612_());
        CacheFile cacheFile = (CacheFile)this.cache.getAndMoveToFirst(i);
        if (cacheFile == null) {
            if (this.cache.size() >= 256) {
                ((CacheFile)this.cache.removeLast()).close();
            }
            Files.createDirectories(this.folderPath, new FileAttribute[0]);
            Path path = this.folderPath.resolve("r." + chunkPos.m_45610_() + "." + chunkPos.m_45612_() + EXTENSION);
            cacheFile = new CacheFile(path, this.folderPath, this.sync);
            this.cache.putAndMoveToFirst(i, (Object)cacheFile);
        }
        return cacheFile;
    }

    @Nullable
    public CompoundTag read(ChunkPos chunkPos) throws IOException {
        CompoundTag tag;
        block5: {
            CompoundTag tag2;
            CacheFile cacheFile = this.getCacheFile(chunkPos);
            DataInputStream chunkDataInputStream = cacheFile.getChunkDataInputStream(chunkPos);
            try {
                if (chunkDataInputStream == null) {
                    tag = null;
                    break block5;
                }
                tag2 = NbtIo.m_128928_((DataInput)chunkDataInputStream);
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error reading chunk for ChunkPos {}", (Object)chunkPos);
                try {
                    chunkDataInputStream.close();
                }
                catch (Throwable t2) {
                    Journeymap.getLogger().error("Error closing stream on chunk error {}", (Object)chunkPos);
                    t.addSuppressed(t2);
                }
                return null;
            }
            chunkDataInputStream.close();
            return tag2;
        }
        return tag;
    }

    protected void write(ChunkPos chunkPos, @Nullable CompoundTag tag) throws IOException {
        CacheFile cacheFile = this.getCacheFile(chunkPos);
        if (tag == null) {
            cacheFile.clear(chunkPos);
        } else {
            try (DataOutputStream chunkDataInputStream = cacheFile.getChunkDataOutputStream(chunkPos);){
                NbtIo.m_128941_((CompoundTag)tag, (DataOutput)chunkDataInputStream);
            }
        }
    }

    @Override
    public void close() throws IOException {
        ExceptionCollector collector = new ExceptionCollector();
        for (CacheFile cacheFile : this.cache.values()) {
            try {
                cacheFile.close();
            }
            catch (IOException e) {
                collector.m_13653_((Throwable)e);
            }
        }
        collector.m_13652_();
    }

    public void flush() throws IOException {
        for (CacheFile cacheFile : this.cache.values()) {
            cacheFile.flush();
        }
    }
}

