/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.network;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SkateboardJumpMessage {
    public int skateboardId;
    public int playerId;
    public int jumpAmount;

    public SkateboardJumpMessage(int skateboardId, int playerId, int jumpAmount) {
        this.skateboardId = skateboardId;
        this.playerId = playerId;
        this.jumpAmount = jumpAmount;
    }

    public SkateboardJumpMessage() {
    }

    public static SkateboardJumpMessage read(FriendlyByteBuf buf) {
        return new SkateboardJumpMessage(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void write(SkateboardJumpMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.skateboardId);
        buf.writeInt(message.playerId);
        buf.writeInt(message.jumpAmount);
    }

    public static class Handler {
        public static void handle(SkateboardJumpMessage message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer playerSided = ((NetworkEvent.Context)context.get()).getSender();
                if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    playerSided = IWannaSkateMod.PROXY.getClientSidePlayer();
                }
                Entity parent = playerSided.m_9236_().m_6815_(message.skateboardId);
                Entity jumpPlayer = playerSided.m_9236_().m_6815_(message.playerId);
                if (jumpPlayer != null && parent instanceof SkateboardEntity) {
                    SkateboardEntity skateboard = (SkateboardEntity)parent;
                    if (jumpPlayer instanceof Player && jumpPlayer.m_20365_((Entity)skateboard)) {
                        skateboard.m_7199_(Mth.m_14045_((int)message.jumpAmount, (int)0, (int)1000));
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

