/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.misc;

import com.github.alexthe668.iwannaskate.server.misc.IWSTags;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public enum SkateQuality {
    LOW(0.3, IWSTags.LOW_SKATE_QUALITY, new SoundType[0]),
    MEDIUM((double)0.92f, IWSTags.MID_SKATE_QUALITY, SoundType.f_56736_, SoundType.f_56745_, SoundType.f_244244_, SoundType.f_243772_, SoundType.f_271497_, SoundType.f_154654_, SoundType.f_56718_),
    HIGH((double)0.935f, IWSTags.HIGH_SKATE_QUALITY, SoundType.f_56742_, SoundType.f_56744_, SoundType.f_154660_),
    BEST((double)0.95f, IWSTags.BEST_SKATE_QUALITY, SoundType.f_56743_);

    private final double inertia;
    private final TagKey<Block> blockTag;
    private final List<SoundType> materialList;

    private SkateQuality(double intertia, TagKey<Block> blockTag, SoundType ... materials) {
        this.inertia = intertia;
        this.blockTag = blockTag;
        this.materialList = ImmutableList.copyOf((Object[])materials);
    }

    public double getInertia() {
        return this.inertia;
    }

    public static SkateQuality getSkateQuality(BlockState state, SkateQuality floor) {
        if (state.m_60795_()) {
            return HIGH;
        }
        SkateQuality tagMatch = null;
        for (SkateQuality value : SkateQuality.values()) {
            if (value.ordinal() < floor.ordinal() || !state.m_204336_(value.blockTag)) continue;
            tagMatch = value;
        }
        if (tagMatch != null) {
            return tagMatch;
        }
        SkateQuality materialMatch = null;
        for (SkateQuality value : SkateQuality.values()) {
            if (value.ordinal() < floor.ordinal() || !value.materialList.contains(state.m_60827_())) continue;
            materialMatch = value;
        }
        return materialMatch == null ? floor : materialMatch;
    }
}

