/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.item;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SkateboardData {
    private ResourceLocation woodBlock;
    private int gripTapeOrdinal = -1;
    private int wheelTypeOrdinal = -1;
    private boolean hasBanner = false;
    @Nullable
    private CompoundTag bannerTag = null;
    public static final SkateboardData DEFAULT = new SkateboardData(new ResourceLocation("minecraft:oak_slab"));

    public SkateboardData(ResourceLocation woodBlock) {
        this.woodBlock = woodBlock;
    }

    public static SkateboardData fromTag(CompoundTag tag) {
        ResourceLocation location = tag.m_128441_("MadeOf") ? new ResourceLocation(tag.m_128461_("MadeOf")) : new ResourceLocation("minecraft:oak_slab");
        SkateboardData data = new SkateboardData(location);
        if (tag.m_128441_("Banner")) {
            data.hasBanner = true;
            data.bannerTag = tag.m_128469_("Banner");
        }
        data.gripTapeOrdinal = tag.m_128451_("GripTape");
        data.wheelTypeOrdinal = tag.m_128451_("WheelType");
        return data;
    }

    public ResourceLocation getWoodBlock() {
        return this.woodBlock;
    }

    public void setWoodBlock(ResourceLocation woodBlock) {
        this.woodBlock = woodBlock;
    }

    public void removeBanner() {
        this.hasBanner = false;
    }

    public void setBanner(CompoundTag bannerTag) {
        this.hasBanner = true;
        this.bannerTag = bannerTag;
    }

    public boolean hasBanner() {
        return this.hasBanner && this.bannerTag != null;
    }

    public CompoundTag getBannerTag() {
        return this.bannerTag;
    }

    public boolean hasGripTape() {
        return this.gripTapeOrdinal >= 0;
    }

    public void removeGripTape() {
        this.gripTapeOrdinal = -1;
    }

    public void setGripTape(DyeColor dyeColor) {
        this.gripTapeOrdinal = dyeColor.ordinal();
    }

    public DyeColor getGripTapeColor() {
        if (this.hasGripTape()) {
            return DyeColor.values()[Mth.m_14045_((int)this.gripTapeOrdinal, (int)0, (int)(DyeColor.values().length - 1))];
        }
        return DyeColor.BLACK;
    }

    public void setWheelType(SkateboardWheels wheelType) {
        this.wheelTypeOrdinal = wheelType.ordinal();
    }

    public SkateboardWheels getWheelType() {
        return SkateboardWheels.values()[Mth.m_14045_((int)this.wheelTypeOrdinal, (int)0, (int)(SkateboardWheels.values().length - 1))];
    }

    public CompoundTag toTag() {
        CompoundTag data = new CompoundTag();
        data.m_128359_("MadeOf", this.woodBlock.toString());
        if (this.hasBanner && this.bannerTag != null) {
            data.m_128365_("Banner", (Tag)this.bannerTag);
        }
        data.m_128405_("GripTape", this.gripTapeOrdinal);
        data.m_128405_("WheelType", this.wheelTypeOrdinal);
        return data;
    }

    public void appendHoverText(List<Component> tooltip, ItemStack stack) {
        ChatFormatting chatColor = ChatFormatting.GRAY;
        Item material = (Item)ForgeRegistries.ITEMS.getValue(this.getWoodBlock());
        MutableComponent madeOfName = Component.m_237115_((String)material.m_5524_());
        tooltip.add((Component)Component.m_237115_((String)"item.iwannaskate.skateboard.made_of").m_130940_(chatColor).m_130946_(" ").m_7220_((Component)madeOfName.m_130940_(chatColor)));
        if (this.hasGripTape()) {
            tooltip.add((Component)Component.m_237115_((String)("item.iwannaskate.skateboard.grip_tape_" + this.getGripTapeColor().m_41065_())).m_130940_(chatColor));
        }
        if (this.wheelTypeOrdinal > 0) {
            String wheelStr = "item.iwannaskate.skateboard.wheels_" + this.getWheelType().name().toLowerCase();
            tooltip.add((Component)Component.m_237115_((String)wheelStr).m_130940_(chatColor));
        }
        if (this.hasBanner()) {
            tooltip.add((Component)Component.m_237115_((String)"item.iwannaskate.skateboard.banner").m_130940_(chatColor));
            CompoundTag compoundtag = this.getBannerTag();
            DyeColor base = DyeColor.m_41053_((int)compoundtag.m_128451_("Base"));
            MutableComponent baseText = Component.m_237115_((String)("item.iwannaskate.skateboard.banner_base_" + base.m_41065_())).m_130940_(chatColor);
            tooltip.add((Component)Component.m_237113_((String)"  -").m_130940_(chatColor).m_7220_((Component)baseText));
            if (compoundtag != null && compoundtag.m_128441_("Patterns")) {
                ListTag listtag = compoundtag.m_128437_("Patterns", 10);
                for (int i = 0; i < listtag.size() && i < 6; ++i) {
                    CompoundTag compoundtag1 = listtag.m_128728_(i);
                    DyeColor dyecolor = DyeColor.m_41053_((int)compoundtag1.m_128451_("Color"));
                    Holder holder = BannerPattern.m_222700_((String)compoundtag1.m_128461_("Pattern"));
                    if (holder == null) continue;
                    holder.m_203543_().map(p_220002_ -> p_220002_.m_135782_().m_214299_()).ifPresent(p_220006_ -> {
                        ResourceLocation fileLoc = new ResourceLocation(p_220006_);
                        MutableComponent patternText = Component.m_237115_((String)("block." + fileLoc.m_135827_() + ".banner." + fileLoc.m_135815_() + "." + dyecolor.m_41065_())).m_130940_(chatColor);
                        tooltip.add((Component)Component.m_237113_((String)"  -").m_130940_(chatColor).m_7220_((Component)patternText));
                    });
                }
            }
        }
        if (stack.m_41793_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.iwannaskate.skateboard.enchanted").m_130944_(new ChatFormatting[]{chatColor, ChatFormatting.UNDERLINE}));
            ListTag enchantmentList = stack.m_41785_();
            int maxPreview = 4;
            for (int i = 0; i < enchantmentList.size(); ++i) {
                if (i >= maxPreview && !IWannaSkateMod.PROXY.isKeyDown(1)) continue;
                CompoundTag compoundtag = enchantmentList.m_128728_(i);
                ForgeRegistries.ENCHANTMENTS.getDelegate(EnchantmentHelper.m_182446_((CompoundTag)compoundtag)).ifPresent(enchantment -> tooltip.add((Component)Component.m_237113_((String)"  -").m_130940_(chatColor).m_7220_(((Enchantment)enchantment.m_203334_()).m_44700_(EnchantmentHelper.m_182438_((CompoundTag)compoundtag)))));
            }
            if (enchantmentList.size() >= maxPreview && !IWannaSkateMod.PROXY.isKeyDown(1)) {
                tooltip.add((Component)Component.m_237115_((String)"item.iwannaskate.skateboard.show_more").m_130940_(chatColor));
            }
        }
    }

    @NotNull
    public static SkateboardData fromStack(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_("Skateboard")) {
            return SkateboardData.fromTag(compoundtag.m_128469_("Skateboard"));
        }
        return DEFAULT;
    }

    public static void setStackData(ItemStack stack, SkateboardData data) {
        CompoundTag tag = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        tag.m_128365_("Skateboard", (Tag)data.toTag());
        stack.m_41751_(tag);
    }
}

