/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.entity;

import com.github.alexthe668.iwannaskate.server.enchantment.IWSEnchantmentRegistry;
import com.github.alexthe668.iwannaskate.server.entity.IWSEntityRegistry;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.entity.ai.WanderingSkaterApproachPositionGoal;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import com.github.alexthe668.iwannaskate.server.misc.BuyingItemTrade;
import com.github.alexthe668.iwannaskate.server.misc.IWSDamageTypes;
import com.github.alexthe668.iwannaskate.server.misc.IWSSoundRegistry;
import com.github.alexthe668.iwannaskate.server.misc.SellingEnchantedBook;
import com.github.alexthe668.iwannaskate.server.misc.SellingItemTrade;
import com.github.alexthe668.iwannaskate.server.misc.SellingRandomDyedTrade;
import com.github.alexthe668.iwannaskate.server.misc.SellingRandomSkateboardTrade;
import com.github.alexthe668.iwannaskate.server.misc.SkateQuality;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.UseItemGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class WanderingSkaterEntity
extends WanderingTrader {
    private static final EntityDataAccessor<Optional<UUID>> SKATEBOARD_UUID = SynchedEntityData.m_135353_(WanderingSkaterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> SKATEBOARD_ID = SynchedEntityData.m_135353_(WanderingSkaterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TIME = SynchedEntityData.m_135353_(WanderingSkaterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> NO_DESPAWN = SynchedEntityData.m_135353_(WanderingSkaterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int skateTimer = 0;
    private int attemptRecoveryTimer = 0;
    private int slowTimer = 0;
    private float attackingProgress;
    private float prevAttackingProgress;
    private float attackAngle;
    private float prevAttackAngle;
    private int lastAttackTimestamp = 0;
    private int healCooldown = 0;
    @Nullable
    private BlockPos wanderingSkaterTarget;
    private int playerAggroTime;
    private long lastTradesGenTime = 0L;

    public WanderingSkaterEntity(EntityType<? extends WanderingTrader> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 16.0).m_22266_(Attributes.f_22282_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new UseItemGoal((Mob)this, new ItemStack((ItemLike)IWSItemRegistry.PIZZA_SLICE.get()), SoundEvents.f_12321_, p_35882_ -> this.m_21223_() < this.m_21233_() && this.healCooldown == 0 && !this.shouldBeAttacking()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal<Monster>((PathfinderMob)this, Monster.class, 12.0f, 0.5, 0.5){

            public boolean m_8036_() {
                return WanderingSkaterEntity.this.m_21223_() < WanderingSkaterEntity.this.m_21233_() * 0.5f && super.m_8036_();
            }

            public void m_8056_() {
                super.m_8056_();
                WanderingSkaterEntity.this.skateTimer = -300;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 0.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SkateboardWheels.EMERALD.getItemRegistryObject().get()}), false));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new WanderingSkaterApproachPositionGoal(this, 2.0, 0.35));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, new DefensiveTargetGoal<Zombie>(this, Zombie.class));
        this.f_21346_.m_25352_(1, new DefensiveTargetGoal<Evoker>(this, Evoker.class));
        this.f_21346_.m_25352_(1, new DefensiveTargetGoal<Pillager>(this, Pillager.class));
        this.f_21346_.m_25352_(1, new DefensiveTargetGoal<Vex>(this, Vex.class));
        this.f_21346_.m_25352_(1, new DefensiveTargetGoal<Illusioner>(this, Illusioner.class));
    }

    public static ItemStack createSkateboard() {
        ItemStack itemStack = new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD.get());
        SkateboardData data = new SkateboardData(ForgeRegistries.ITEMS.getKey((Object)Items.f_41914_));
        data.setGripTape(DyeColor.GRAY);
        CompoundTag bannerTag = new CompoundTag();
        ListTag patterns = new ListTag();
        CompoundTag layer1 = new CompoundTag();
        layer1.m_128359_("Pattern", "gru");
        layer1.m_128405_("Color", 13);
        patterns.add((Object)layer1);
        CompoundTag layer2 = new CompoundTag();
        layer2.m_128359_("Pattern", "flo");
        layer2.m_128405_("Color", 12);
        patterns.add((Object)layer2);
        CompoundTag layer3 = new CompoundTag();
        layer3.m_128359_("Pattern", "flo");
        layer3.m_128405_("Color", 1);
        patterns.add((Object)layer3);
        bannerTag.m_128365_("Patterns", (Tag)patterns);
        bannerTag.m_128405_("Base", DyeColor.LIME.m_41060_());
        data.setBanner(bannerTag);
        SkateboardData.setStackData(itemStack, data);
        itemStack.m_41714_((Component)Component.m_237115_((String)"item.iwannaskate.skateboard.wandering_skater").m_130940_(ChatFormatting.DARK_AQUA));
        return itemStack;
    }

    public double m_20968_(@Nullable Entity targeter) {
        return super.m_20968_(targeter) * (double)0.35f;
    }

    protected SoundEvent m_7515_() {
        return this.m_35306_() ? (SoundEvent)IWSSoundRegistry.WANDERING_SKATER_MAYBE.get() : (SoundEvent)IWSSoundRegistry.WANDERING_SKATER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)IWSSoundRegistry.WANDERING_SKATER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IWSSoundRegistry.WANDERING_SKATER_DIE.get();
    }

    protected SoundEvent m_6068_(boolean yes) {
        return yes ? (SoundEvent)IWSSoundRegistry.WANDERING_SKATER_YES.get() : (SoundEvent)IWSSoundRegistry.WANDERING_SKATER_NO.get();
    }

    public SoundEvent m_7596_() {
        return (SoundEvent)IWSSoundRegistry.WANDERING_SKATER_YES.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SKATEBOARD_UUID, Optional.empty());
        this.f_19804_.m_135372_(SKATEBOARD_ID, (Object)-1);
        this.f_19804_.m_135372_(ATTACK_TIME, (Object)0);
        this.f_19804_.m_135372_(NO_DESPAWN, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("SkateboardUUID")) {
            this.setSkateboardUUID(compound.m_128342_("SkateboardUUID"));
        }
        if (compound.m_128441_("WanderTarget")) {
            this.wanderingSkaterTarget = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("WanderTarget"));
        }
        this.setNoDespawn(compound.m_128471_("NoTraderDespawn"));
        this.lastTradesGenTime = compound.m_128454_("LastTradeGenTime");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getSkateboardUUID() != null) {
            compound.m_128362_("SkateboardUUID", this.getSkateboardUUID());
        }
        compound.m_128379_("NoTraderDespawn", this.isNoDespawn());
        compound.m_128356_("LastTradeGenTime", this.lastTradesGenTime);
    }

    public void setNoDespawn(boolean noDespawn) {
        this.f_19804_.m_135381_(NO_DESPAWN, (Object)noDespawn);
    }

    public boolean isNoDespawn() {
        return (Boolean)this.f_19804_.m_135370_(NO_DESPAWN);
    }

    @Nullable
    public UUID getSkateboardUUID() {
        return ((Optional)this.f_19804_.m_135370_(SKATEBOARD_UUID)).orElse(null);
    }

    public void setSkateboardUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(SKATEBOARD_UUID, Optional.ofNullable(uniqueId));
    }

    public boolean m_7243_(ItemStack stack) {
        return stack.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get()) && this.m_21206_().m_41619_();
    }

    public boolean m_21531_() {
        return true;
    }

    protected void m_7581_(ItemEntity entity) {
        ItemStack itemstack = entity.m_32055_();
        if (this.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
            this.m_8061_(EquipmentSlot.OFFHAND, itemstack);
            this.m_7938_((Entity)entity, itemstack.m_41613_());
        }
        this.m_21508_(EquipmentSlot.OFFHAND);
    }

    public Entity getSkateboard() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getSkateboardUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(SKATEBOARD_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevAttackingProgress = this.attackingProgress;
        this.prevAttackAngle = this.attackAngle;
        Entity skateboard = this.getSkateboard();
        if (!this.m_9236_().f_46443_) {
            Entity stack;
            if (skateboard != null) {
                this.f_19804_.m_135381_(SKATEBOARD_ID, (Object)skateboard.m_19879_());
            } else if ((this.skateTimer <= -300 || this.m_5448_() != null) && this.canPlaceBoard()) {
                this.skateTimer = 0;
                SkateboardEntity spawnedBoard = (SkateboardEntity)((EntityType)IWSEntityRegistry.SKATEBOARD.get()).m_20615_(this.m_9236_());
                stack = this.m_6844_(EquipmentSlot.OFFHAND);
                spawnedBoard.setItemStack(stack.m_41777_());
                spawnedBoard.m_146884_(this.m_20182_());
                spawnedBoard.m_146922_(this.m_146908_());
                spawnedBoard.setMobSpawned();
                spawnedBoard.m_146926_(-70.0f);
                if (this.m_9236_().m_7967_((Entity)spawnedBoard)) {
                    this.m_21011_(InteractionHand.OFF_HAND, true);
                    stack.m_41774_(1);
                    this.setSkateboardUUID(spawnedBoard.m_20148_());
                }
            }
            if (this.m_20159_() && (stack = this.m_20202_()) instanceof SkateboardEntity) {
                SkateboardEntity rideBoard = (SkateboardEntity)stack;
                ++this.skateTimer;
                if (rideBoard.getSlowdown() < (double)0.4f || rideBoard.m_20184_().m_82553_() < 0.05 && this.m_21573_().m_26572_()) {
                    ++this.slowTimer;
                }
                if (this.shouldDismountBoard(rideBoard)) {
                    this.m_8061_(EquipmentSlot.OFFHAND, rideBoard.getItemStack().m_41777_());
                    this.m_21011_(InteractionHand.OFF_HAND, true);
                    rideBoard.m_142687_(Entity.RemovalReason.DISCARDED);
                    this.m_8127_();
                    this.slowTimer = 0;
                }
            } else {
                if (this.skateTimer > 0) {
                    this.skateTimer = 0;
                }
                --this.skateTimer;
            }
        }
        if (!this.m_20159_() && skateboard != null) {
            if (this.m_6084_() && this.attemptRecoveryTimer < 5) {
                if (this.m_20280_(skateboard) > 1.0) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_21573_().m_26519_(skateboard.m_20185_(), skateboard.m_20227_(0.5), skateboard.m_20189_(), 1.0);
                    }
                } else {
                    this.m_20329_(skateboard);
                }
            } else if (skateboard instanceof SkateboardEntity) {
                this.m_8061_(EquipmentSlot.OFFHAND, ((SkateboardEntity)skateboard).getItemStack().m_41777_());
                this.m_21011_(InteractionHand.OFF_HAND, true);
                skateboard.m_142687_(Entity.RemovalReason.DISCARDED);
                this.attemptRecoveryTimer = 0;
            }
            ++this.attemptRecoveryTimer;
        }
        int attackTime = this.getAttackTime();
        float angleIncrement = 45.0f;
        if (attackTime > 0 && this.m_6084_()) {
            if (this.attackingProgress < 5.0f) {
                this.attackingProgress += 1.0f;
            } else {
                this.attackAngle += angleIncrement;
                if (this.m_21206_().m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) {
                    this.hurtMobsAtYaw(this.m_146908_() + this.attackAngle);
                }
            }
            this.f_21344_.m_26573_();
            this.setAttackTime(attackTime - 1);
        } else {
            if (this.attackingProgress > 0.0f) {
                this.attackingProgress -= 1.0f;
            }
            if (this.attackAngle > 0.0f) {
                this.attackAngle = this.attackAngle % 360.0f - angleIncrement;
            }
        }
        LivingEntity target = this.m_5448_();
        if (!this.m_9236_().f_46443_ && this.m_21206_().m_150930_((Item)IWSItemRegistry.SKATEBOARD.get()) && target != null && target.m_6084_() && this.m_20280_((Entity)target) < 20.0 && this.m_142582_((Entity)target) && this.getAttackTime() == 0) {
            this.setAttackTime(30 + this.m_217043_().m_188503_(20));
            this.lastAttackTimestamp = this.f_19797_;
        }
        if (this.healCooldown > 0) {
            --this.healCooldown;
        }
        if (this.playerAggroTime > 0) {
            --this.playerAggroTime;
        } else if (target instanceof Player) {
            this.m_6710_(null);
            this.m_6703_(null);
        }
        if (this.isNoDespawn()) {
            this.m_35891_(48000);
            if (Math.abs(this.m_9236_().m_46467_() - this.lastTradesGenTime) > 200L) {
                this.m_9236_().m_7605_((Entity)this, (byte)14);
                this.f_35261_ = new MerchantOffers();
                this.m_7604_();
            }
        }
    }

    public void m_6703_(@Nullable LivingEntity target) {
        LivingEntity current = this.m_21188_();
        if (target instanceof Player && (current == null || !current.m_7306_((Entity)target))) {
            this.m_6710_(target);
            this.playerAggroTime = 100;
        } else {
            super.m_6703_(target);
        }
    }

    public void m_7822_(byte event) {
        if (event == 14) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123748_);
        } else if (event == 15) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123748_);
            this.m_35287_((ParticleOptions)ParticleTypes.f_123748_);
            this.m_35287_((ParticleOptions)ParticleTypes.f_123748_);
        } else {
            super.m_7822_(event);
        }
    }

    private void hurtMobsAtYaw(float hurtYaw) {
        Vec3 offset = new Vec3(0.0, (double)-0.3f, (double)1.15f).m_82524_(-hurtYaw * ((float)Math.PI / 180));
        Vec3 at = this.m_146892_().m_82549_(offset);
        AABB mobBox = new AABB(at.f_82479_ - 1.0, at.f_82480_ - 1.5, at.f_82481_ - 1.0, at.f_82479_ + 1.0, at.f_82480_ + 1.5, at.f_82481_ + 1.0);
        for (Entity entity : this.m_9236_().m_6249_((Entity)this, mobBox, EntitySelector.f_20406_)) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || !this.canHurtWithAttack(living = (LivingEntity)entity) || !living.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 4.0f)) continue;
            living.m_147240_(1.0, (double)Mth.m_14031_((float)(hurtYaw * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(hurtYaw * ((float)Math.PI / 180)))));
        }
    }

    private boolean canHurtWithAttack(LivingEntity living) {
        LivingEntity target = this.m_5448_();
        return living != this && !living.m_7307_((Entity)this) && this.m_142582_((Entity)living) && (living instanceof Enemy || target != null && target.m_7306_((Entity)living)) && !(living instanceof Creeper);
    }

    private boolean canPlaceBoard() {
        return !this.m_35306_() && this.m_6084_() && this.m_20096_() && !this.shouldBeAttacking() && this.m_6844_(EquipmentSlot.OFFHAND).m_150930_((Item)IWSItemRegistry.SKATEBOARD.get()) && SkateQuality.getSkateQuality(this.m_20075_(), SkateQuality.LOW) != SkateQuality.LOW && this.m_9236_().m_45784_((Entity)this);
    }

    private boolean shouldDismountBoard(SkateboardEntity board) {
        return this.slowTimer > 60 || this.shouldBeAttacking() || this.m_35306_() || board.isRemoveLogic() || this.m_5448_() == null && this.skateTimer > 700 || !this.m_6084_();
    }

    private boolean shouldBeAttacking() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            return this.m_20280_((Entity)target) > 16.0 || Math.abs(this.f_19797_ - this.lastAttackTimestamp) < 60;
        }
        return this.getAttackTime() > 0;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType mobType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        spawnGroupData = super.m_6518_(level, difficulty, mobType, spawnGroupData, tag);
        RandomSource randomsource = level.m_213780_();
        this.m_213945_(randomsource, difficulty);
        this.m_213946_(randomsource, difficulty);
        return spawnGroupData;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
        this.m_8061_(EquipmentSlot.OFFHAND, WanderingSkaterEntity.createSkateboard());
    }

    public boolean m_6673_(DamageSource damageSource) {
        return super.m_6673_(damageSource) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_276093_(IWSDamageTypes.SKATE_DAMAGE);
    }

    protected void m_8095_() {
        if (this.m_21205_().m_150930_((Item)IWSItemRegistry.PIZZA_SLICE.get())) {
            this.healCooldown = 100;
            this.m_5634_(3.0f);
        }
        super.m_8095_();
    }

    private int getAttackTime() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIME);
    }

    private void setAttackTime(int time) {
        this.f_19804_.m_135381_(ATTACK_TIME, (Object)time);
    }

    public float getAttackingProgress(float partialTick) {
        return (this.prevAttackingProgress + (this.attackingProgress - this.prevAttackingProgress) * partialTick) * 0.2f;
    }

    public float getAttackingAngle(float partialTick) {
        return this.prevAttackAngle + (this.attackAngle - this.prevAttackAngle) * partialTick;
    }

    protected void m_7604_() {
        SkateboardWheels wheel1;
        this.lastTradesGenTime = this.m_9236_().m_46467_();
        MerchantOffers merchantoffers = this.m_6616_();
        List enchantments = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(enchantment -> enchantment.f_44672_ == IWSEnchantmentRegistry.SKATEBOARD).collect(Collectors.toList());
        Enchantment randomEnchant = enchantments.size() > 1 ? (Enchantment)enchantments.get(this.f_19796_.m_188503_(enchantments.size() - 1)) : (Enchantment)enchantments.get(0);
        VillagerTrades.ItemListing[] trades = new VillagerTrades.ItemListing[]{new SellingItemTrade(new ItemStack((ItemLike)IWSItemRegistry.SKATING_MANUAL.get(), 1), 2, 2, 4), new BuyingItemTrade(new ItemStack((ItemLike)SkateboardWheels.DEFAULT.getItemRegistryObject().get(), 2), 1, 7, 3), new SellingItemTrade(new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD_TRUCK.get(), 2), 3, 2, 4), new SellingItemTrade(new ItemStack((ItemLike)Items.f_42749_, 18), 4, 3, 5), new SellingItemTrade(new ItemStack((ItemLike)Items.f_42468_, 1), 7, 2, 5), new SellingRandomDyedTrade(new ItemStack((ItemLike)IWSItemRegistry.BEANIE.get(), 1), 6, 5, 3), new SellingRandomDyedTrade(new ItemStack((ItemLike)IWSItemRegistry.SKATER_CAP.get(), 1), 6, 5, 3), new SellingItemTrade(new ItemStack((ItemLike)IWSItemRegistry.PIZZA_SLICE.get(), 5), 2, 5, 3), new SellingItemTrade(new ItemStack((ItemLike)IWSItemRegistry.ENERGY_DRINK.get(), 6), 2, 5, 3), new SellingRandomSkateboardTrade(new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD_DECK.get()), 2, 4, 3), new SellingRandomSkateboardTrade(new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD.get()), 11, 1, 3), new SellingEnchantedBook(randomEnchant, 15, 2, 3), new SellingItemTrade(new ItemStack((ItemLike)IWSItemRegistry.SHIMMERING_WAX.get(), 1), 3, 4, 3)};
        this.m_35277_(merchantoffers, trades, 5);
        int randomAttempts = 0;
        ArrayList<SkateboardWheels> wheelsList = new ArrayList<SkateboardWheels>();
        for (SkateboardWheels wheels : SkateboardWheels.values()) {
            if (!wheels.isTrade()) continue;
            wheelsList.add(wheels);
        }
        SkateboardWheels wheel2 = wheel1 = (SkateboardWheels)((Object)wheelsList.get(Mth.m_14045_((int)(wheelsList.size() <= 1 ? 0 : this.f_19796_.m_188503_(wheelsList.size())), (int)0, (int)(wheelsList.size() - 1))));
        while (wheel1 == wheel2 && randomAttempts < 255) {
            ++randomAttempts;
            wheel2 = (SkateboardWheels)((Object)wheelsList.get(Mth.m_14045_((int)(wheelsList.size() <= 1 ? 0 : this.f_19796_.m_188503_(wheelsList.size())), (int)0, (int)(wheelsList.size() - 1))));
        }
        SellingItemTrade wheelTrade1 = new SellingItemTrade(new ItemStack((ItemLike)wheel1.getItemRegistryObject().get(), 2), 4, 4, 4);
        SellingItemTrade wheelTrade2 = new SellingItemTrade(new ItemStack((ItemLike)wheel2.getItemRegistryObject().get(), 2), 4, 4, 4);
        MerchantOffer merchantoffer1 = wheelTrade1.m_213663_((Entity)this, this.f_19796_);
        MerchantOffer merchantoffer2 = wheelTrade2.m_213663_((Entity)this, this.f_19796_);
        if (merchantoffer1 != null) {
            merchantoffers.add((Object)merchantoffer1);
        }
        if (merchantoffer2 != null) {
            merchantoffers.add((Object)merchantoffer2);
        }
    }

    public void m_35883_(@Nullable BlockPos pos) {
        this.wanderingSkaterTarget = pos;
        super.m_35883_(pos);
    }

    @Nullable
    public BlockPos getWanderingSkaterTarget() {
        return this.wanderingSkaterTarget;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.isNoDespawn() && stack.m_150930_((Item)SkateboardWheels.EMERALD.getItemRegistryObject().get())) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.emeraldSkateboard();
            this.m_9236_().m_7605_((Entity)this, (byte)15);
            this.setNoDespawn(true);
            player.m_6674_(hand);
            this.m_35883_(this.m_20183_());
            this.m_21446_(this.m_20183_(), 16);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void emeraldSkateboard() {
        ItemStack offhand = this.m_21120_(InteractionHand.OFF_HAND);
        Entity skateboardEntity = this.m_20202_() != null ? this.m_20202_() : this.getSkateboard();
        ItemStack board = ItemStack.f_41583_;
        if (offhand.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) {
            board = offhand;
        } else if (skateboardEntity instanceof SkateboardEntity) {
            SkateboardEntity skateboard = (SkateboardEntity)skateboardEntity;
            board = skateboard.getItemStack();
        }
        SkateboardData data = SkateboardData.fromStack(board);
        data.setWheelType(SkateboardWheels.EMERALD);
        SkateboardData.setStackData(board, data);
        if (skateboardEntity instanceof SkateboardEntity) {
            SkateboardEntity skateboard = (SkateboardEntity)skateboardEntity;
            skateboard.setItemStack(board);
        }
    }

    class DefensiveTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public DefensiveTargetGoal(WanderingSkaterEntity skaterEntity, Class<T> targetClass) {
            super((Mob)skaterEntity, targetClass, true);
        }

        public boolean m_8036_() {
            return WanderingSkaterEntity.this.getAttackTime() == 0 && super.m_8036_();
        }

        protected AABB m_7255_(double dist) {
            return this.f_26135_.m_20191_().m_82377_(4.0, 4.0, 4.0);
        }
    }
}

