/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.entity;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.entity.IWSEntityRegistry;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import com.github.alexthe668.iwannaskate.server.misc.IWSDamageTypes;
import com.github.alexthe668.iwannaskate.server.misc.IWSSoundRegistry;
import com.github.alexthe668.iwannaskate.server.misc.IWSTags;
import com.github.alexthe668.iwannaskate.server.misc.SkateQuality;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class SkaterSkeletonEntity
extends AbstractSkeleton {
    private static final EntityDataAccessor<Optional<UUID>> SKATEBOARD_UUID = SynchedEntityData.m_135353_(SkaterSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> SKATEBOARD_ID = SynchedEntityData.m_135353_(SkaterSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int skateTimer = 0;
    private int attemptRecoveryTimer = 0;
    private int slowTimer = 0;

    protected SkaterSkeletonEntity(EntityType type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22276_, 28.0);
    }

    public static ItemStack createSkateboard() {
        ItemStack itemStack = new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD.get());
        SkateboardData data = new SkateboardData(ForgeRegistries.ITEMS.getKey((Object)Items.f_41919_));
        data.setGripTape(DyeColor.BLACK);
        CompoundTag bannerTag = new CompoundTag();
        ListTag patterns = new ListTag();
        CompoundTag layer1 = new CompoundTag();
        layer1.m_128359_("Pattern", "sku");
        layer1.m_128405_("Color", 15);
        patterns.add((Object)layer1);
        CompoundTag layer2 = new CompoundTag();
        layer2.m_128359_("Pattern", "tts");
        layer2.m_128405_("Color", 15);
        patterns.add((Object)layer2);
        CompoundTag layer3 = new CompoundTag();
        layer3.m_128359_("Pattern", "bts");
        layer3.m_128405_("Color", 15);
        patterns.add((Object)layer3);
        bannerTag.m_128365_("Patterns", (Tag)patterns);
        bannerTag.m_128405_("Base", DyeColor.RED.m_41060_());
        data.setBanner(bannerTag);
        SkateboardData.setStackData(itemStack, data);
        itemStack.m_41714_((Component)Component.m_237115_((String)"item.iwannaskate.skateboard.skater_skeleton").m_130940_(ChatFormatting.DARK_RED));
        return itemStack;
    }

    public static boolean checkSkaterSkeletonSpawnRules(EntityType type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        BlockPos blockpos = pos.m_7495_();
        boolean prev = SkaterSkeletonEntity.m_219013_((EntityType)type, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)randomSource);
        return prev && (spawnType == MobSpawnType.SPAWNER || (Boolean)IWannaSkateMod.COMMON_CONFIG.spawnSkaterSkeletons.get() != false && !levelAccessor.m_204166_(blockpos).m_203656_(IWSTags.NO_MONSTERS) && levelAccessor.m_8055_(blockpos).m_204336_(IWSTags.SPAWNS_SKATER_SKELETONS) && levelAccessor.m_8055_(blockpos).m_60643_((BlockGetter)levelAccessor, blockpos, type));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SKATEBOARD_UUID, Optional.empty());
        this.f_19804_.m_135372_(SKATEBOARD_ID, (Object)-1);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("SkateboardUUID")) {
            this.setSkateboardUUID(compound.m_128342_("SkateboardUUID"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getSkateboardUUID() != null) {
            compound.m_128362_("SkateboardUUID", this.getSkateboardUUID());
        }
    }

    @Nullable
    public UUID getSkateboardUUID() {
        return ((Optional)this.f_19804_.m_135370_(SKATEBOARD_UUID)).orElse(null);
    }

    public void setSkateboardUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(SKATEBOARD_UUID, Optional.ofNullable(uniqueId));
    }

    public boolean m_7243_(ItemStack stack) {
        return stack.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get()) && this.m_21205_().m_41619_();
    }

    public boolean m_21531_() {
        return true;
    }

    protected void m_7581_(ItemEntity entity) {
        super.m_7581_(entity);
        this.m_21508_(EquipmentSlot.MAINHAND);
    }

    public Entity getSkateboard() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getSkateboardUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(SKATEBOARD_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData spawngroupdata = super.m_6518_(level, difficulty, spawnType, groupData, tag);
        this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
        this.m_32164_();
        return spawngroupdata;
    }

    public boolean m_5912_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        Entity skateboard = this.getSkateboard();
        if (!this.m_9236_().f_46443_) {
            Entity entity;
            if (skateboard != null) {
                this.f_19804_.m_135381_(SKATEBOARD_ID, (Object)skateboard.m_19879_());
            } else if ((this.skateTimer <= -300 || this.m_5448_() != null) && this.canPlaceBoard()) {
                this.skateTimer = 0;
                SkateboardEntity spawnedBoard = (SkateboardEntity)((EntityType)IWSEntityRegistry.SKATEBOARD.get()).m_20615_(this.m_9236_());
                ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
                spawnedBoard.setItemStack(stack.m_41777_());
                spawnedBoard.m_146884_(this.m_20182_());
                spawnedBoard.m_146922_(this.m_146908_());
                spawnedBoard.setMobSpawned();
                spawnedBoard.m_146926_(-70.0f);
                if (this.m_9236_().m_7967_((Entity)spawnedBoard)) {
                    this.m_21011_(InteractionHand.MAIN_HAND, true);
                    stack.m_41774_(1);
                    this.setSkateboardUUID(spawnedBoard.m_20148_());
                }
            }
            if (this.m_20159_() && (entity = this.m_20202_()) instanceof SkateboardEntity) {
                SkateboardEntity rideBoard = (SkateboardEntity)entity;
                ++this.skateTimer;
                if (rideBoard.getSlowdown() < (double)0.4f || rideBoard.m_20184_().m_82553_() < 0.05 && this.m_21573_().m_26572_()) {
                    ++this.slowTimer;
                }
                if (this.shouldDismountBoard(rideBoard)) {
                    this.m_8061_(EquipmentSlot.MAINHAND, rideBoard.getItemStack().m_41777_());
                    this.m_21011_(InteractionHand.MAIN_HAND, true);
                    rideBoard.m_142687_(Entity.RemovalReason.DISCARDED);
                    this.m_8127_();
                    this.slowTimer = 0;
                }
            } else {
                if (this.skateTimer > 0) {
                    this.skateTimer = 0;
                }
                --this.skateTimer;
            }
        }
        if (!this.m_20159_() && skateboard != null) {
            if (this.m_6084_() && this.attemptRecoveryTimer < 60) {
                if (this.m_20280_(skateboard) > 1.0) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_21573_().m_26519_(skateboard.m_20185_(), skateboard.m_20227_(0.5), skateboard.m_20189_(), 1.0);
                    }
                } else {
                    this.m_20329_(skateboard);
                }
            } else if (skateboard instanceof SkateboardEntity) {
                this.m_8061_(EquipmentSlot.MAINHAND, ((SkateboardEntity)skateboard).getItemStack().m_41777_());
                this.m_21011_(InteractionHand.MAIN_HAND, true);
                skateboard.m_142687_(Entity.RemovalReason.DISCARDED);
                this.attemptRecoveryTimer = 0;
            }
            ++this.attemptRecoveryTimer;
        }
    }

    private boolean canPlaceBoard() {
        return (Boolean)IWannaSkateMod.COMMON_CONFIG.skaterSkeletonsUseSkateboards.get() != false && this.m_6084_() && this.m_20096_() && this.m_6844_(EquipmentSlot.MAINHAND).m_150930_((Item)IWSItemRegistry.SKATEBOARD.get()) && SkateQuality.getSkateQuality(this.m_20075_(), SkateQuality.LOW) != SkateQuality.LOW && this.m_9236_().m_45784_((Entity)this);
    }

    private boolean shouldDismountBoard(SkateboardEntity board) {
        return this.slowTimer > 60 || board.isRemoveLogic() || this.m_5448_() == null && this.skateTimer > 700 || !this.m_6084_();
    }

    public boolean m_5545_(LevelAccessor levelAccessor, MobSpawnType type) {
        return (Boolean)IWannaSkateMod.COMMON_CONFIG.spawnSkaterSkeletons.get();
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)IWSItemRegistry.SPIKED_SKATER_HELMET.get()));
        this.m_8061_(EquipmentSlot.MAINHAND, SkaterSkeletonEntity.createSkateboard());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IWSSoundRegistry.SKATER_SKELETON_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33579_) {
        return (SoundEvent)IWSSoundRegistry.SKATER_SKELETON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IWSSoundRegistry.SKATER_SKELETON_DIE.get();
    }

    protected SoundEvent m_7878_() {
        return (SoundEvent)IWSSoundRegistry.SKATER_SKELETON_WALK.get();
    }

    public boolean m_6673_(DamageSource damageSource) {
        return super.m_6673_(damageSource) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_276093_(IWSDamageTypes.SKATE_DAMAGE);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
    }

    protected void m_6668_(DamageSource source) {
        boolean flag;
        Entity entity = source.m_7639_();
        int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)entity, (DamageSource)source);
        this.captureDrops(new ArrayList());
        boolean bl = flag = this.f_20889_ > 0;
        if (this.m_6125_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_7625_(source, flag);
            this.m_7472_(source, i, flag);
        }
        this.m_5907_();
        this.m_21226_();
        Collection drops = this.captureDrops(null);
        ArrayList<ItemEntity> processedDrops = new ArrayList<ItemEntity>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        for (ItemEntity itemEntity : drops) {
            if (itemEntity.m_32055_().m_204117_(IWSTags.SKATEBOARD_WHEELS) && (double)this.m_217043_().m_188501_() < (Double)IWannaSkateMod.COMMON_CONFIG.skaterSkeletonsHolidayWheelsDropChance.get()) {
                int count = itemEntity.m_32055_().m_41613_();
                if (calendar.get(2) + 1 == 10) {
                    itemEntity.m_32045_(new ItemStack((ItemLike)SkateboardWheels.SPOOKY.getItemRegistryObject().get(), count));
                }
                if (calendar.get(2) + 1 == 12) {
                    itemEntity.m_32045_(new ItemStack((ItemLike)SkateboardWheels.SNOWY.getItemRegistryObject().get(), count));
                }
                processedDrops.add(itemEntity);
                continue;
            }
            processedDrops.add(itemEntity);
        }
        if (!ForgeHooks.onLivingDrops((LivingEntity)this, (DamageSource)source, processedDrops, (int)i, (this.f_20889_ > 0 ? 1 : 0) != 0)) {
            processedDrops.forEach(e -> this.m_9236_().m_7967_((Entity)e));
        }
    }
}

