/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.enchantment;

import com.github.alexthe668.iwannaskate.server.enchantment.IWSEnchantmentRegistry;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class SkateboardEnchantment
extends Enchantment {
    private final int levels;
    private final int minXP;
    private final String registryName;

    protected SkateboardEnchantment(String name, Enchantment.Rarity r, int levels, int minXP) {
        super(r, IWSEnchantmentRegistry.SKATEBOARD, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
        this.levels = levels;
        this.minXP = minXP;
        this.registryName = name;
    }

    public int m_6183_(int i) {
        return this.minXP + (i - 1) * 10;
    }

    public int m_6175_(int i) {
        return super.m_6183_(i) + 30;
    }

    public int m_6586_() {
        return this.levels;
    }

    protected boolean m_5975_(Enchantment enchantment) {
        return this != enchantment && IWSEnchantmentRegistry.areCompatible(this, enchantment);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return super.canApplyAtEnchantingTable(stack);
    }

    public String getName() {
        return this.registryName;
    }

    public float getDamageBonus(int level, MobType mobType, ItemStack enchantedItem) {
        return this.registryName.equals("bashing") && enchantedItem.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get()) ? 2.0f * (float)level : 0.0f;
    }
}

