/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.block;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PizzaBlock
extends Block {
    public static final BooleanProperty PIECE_1 = BooleanProperty.m_61465_((String)"slice_1");
    public static final BooleanProperty PIECE_2 = BooleanProperty.m_61465_((String)"slice_2");
    public static final BooleanProperty PIECE_3 = BooleanProperty.m_61465_((String)"slice_3");
    public static final BooleanProperty PIECE_4 = BooleanProperty.m_61465_((String)"slice_4");
    private static final VoxelShape PIECE_1_BB = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape PIECE_2_BB = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)16.0);
    private static final VoxelShape PIECE_3_BB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)8.0);
    private static final VoxelShape PIECE_4_BB = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    private static HashMap<BlockState, VoxelShape> shapes = new HashMap();

    public PizzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PIECE_1, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PIECE_2, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PIECE_3, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PIECE_4, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (shapes.containsKey(blockState)) {
            return shapes.get(blockState);
        }
        VoxelShape shape = Shapes.m_83040_();
        if (((Boolean)blockState.m_61143_((Property)PIECE_1)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)PIECE_1_BB);
        }
        if (((Boolean)blockState.m_61143_((Property)PIECE_2)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)PIECE_2_BB);
        }
        if (((Boolean)blockState.m_61143_((Property)PIECE_3)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)PIECE_3_BB);
        }
        if (((Boolean)blockState.m_61143_((Property)PIECE_4)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)PIECE_4_BB);
        }
        shapes.put(blockState, shape);
        return shape;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Vec3 vec = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_())).m_82490_((double)1.01f);
        BlockState previous = context.m_43725_().m_8055_(context.m_8083_());
        BlockState pizza = this.m_49966_();
        if (previous.m_60734_() == this) {
            pizza = previous;
        }
        BooleanProperty slice = this.getSliceFromVec(vec);
        return (BlockState)pizza.m_61124_((Property)slice, (Comparable)Boolean.valueOf(true));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && this.getPiecesCount(state) < 4 ? true : super.m_6864_(state, context);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        Vec3 vec = result.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)result.m_82425_()));
        BooleanProperty slice = this.getSliceFromVec(vec);
        if (((Boolean)blockState.m_61143_((Property)slice)).booleanValue() && item != this.m_5456_()) {
            if (level.f_46443_) {
                if (this.eat((LevelAccessor)level, pos, blockState, player, slice).m_19077_()) {
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.m_41619_()) {
                    return InteractionResult.CONSUME;
                }
            }
            return this.eat((LevelAccessor)level, pos, blockState, player, slice);
        }
        return InteractionResult.PASS;
    }

    public BooleanProperty getSliceFromVec(Vec3 vec3) {
        if (vec3.f_82479_ >= 0.5 && vec3.f_82481_ >= 0.5) {
            return PIECE_1;
        }
        if (vec3.f_82479_ >= 0.5 && vec3.f_82481_ < 0.5) {
            return PIECE_4;
        }
        if (vec3.f_82479_ < 0.5 && vec3.f_82481_ >= 0.5) {
            return PIECE_2;
        }
        if (vec3.f_82479_ < 0.5 && vec3.f_82481_ < 0.5) {
            return PIECE_3;
        }
        return PIECE_1;
    }

    protected InteractionResult eat(LevelAccessor level, BlockPos pos, BlockState state, Player player, BooleanProperty slice) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        player.m_36324_().m_38707_(3, 0.2f);
        int i = this.getPiecesCount(state);
        level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        if (i > 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)slice, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            level.m_7471_(pos, false);
            level.m_142346_((Entity)player, GameEvent.f_157794_, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState pos, LevelAccessor p_51216_, BlockPos p_51217_, BlockPos p_51218_) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)p_51216_, p_51217_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, pos, p_51216_, p_51217_, p_51218_);
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos pos) {
        return PizzaBlock.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP) && this.getPiecesCount(blockState) > 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.m_61104_(new Property[]{PIECE_1, PIECE_2, PIECE_3, PIECE_4});
    }

    public int m_6782_(BlockState state, Level p_51199_, BlockPos p_51200_) {
        return this.getPiecesCount(state) * 2;
    }

    private int getPiecesCount(BlockState state) {
        int i = 0;
        if (((Boolean)state.m_61143_((Property)PIECE_1)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.m_61143_((Property)PIECE_2)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.m_61143_((Property)PIECE_3)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.m_61143_((Property)PIECE_4)).booleanValue()) {
            ++i;
        }
        return i;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState p_51193_, BlockGetter p_51194_, BlockPos p_51195_, PathComputationType p_51196_) {
        return false;
    }
}

