/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.render.item;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.client.gui.SkateManualScreen;
import com.github.alexthe668.iwannaskate.client.model.SkateboardModel;
import com.github.alexthe668.iwannaskate.client.render.entity.SkateboardTexturer;
import com.github.alexthe668.iwannaskate.server.item.BaseSkateboardItem;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardMaterials;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class IWSItemstackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final SkateboardModel SKATEBOARD_MODEL = new SkateboardModel();
    private static Map<ItemStack, Float> prevFlipProgresses = new HashMap<ItemStack, Float>();
    private static Map<ItemStack, Float> flipProgresses = new HashMap<ItemStack, Float>();
    private static final float FLIP_TIME = 5.0f;
    private static SkateboardData randomSkateData;
    private static int ticks;
    private static RandomSource randomSource;

    public IWSItemstackRenderer() {
        super(null, null);
    }

    public static void tick() {
        if (ticks % 40 == 0) {
            Set<Item> set = SkateboardMaterials.isLoaded() ? SkateboardMaterials.getSkateboardMaterials() : Set.of(Items.f_41914_);
            randomSkateData = SkateboardMaterials.generateRandomData(set, randomSource, false);
        }
        ++ticks;
    }

    public void m_108829_(ItemStack itemStack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Item item = itemStack.m_41720_();
        if (item instanceof BaseSkateboardItem) {
            BaseSkateboardItem skateboardItem = (BaseSkateboardItem)item;
            boolean isCreativeTab = false;
            float f = 0.0f;
            if (itemStack.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get()) && transformType == ItemDisplayContext.GUI && ((Boolean)IWannaSkateMod.CLIENT_CONFIG.flipBoardItems.get()).booleanValue()) {
                f = Citadel.PROXY.getMouseOverProgress(itemStack);
                if (Minecraft.m_91087_().f_91080_ instanceof SkateManualScreen && skateboardItem.canFlipInInventory(itemStack)) {
                    f = 1.0f;
                }
            }
            SkateboardData data = SkateboardData.fromStack(itemStack);
            if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128471_("IsCreativeTab") && randomSkateData != null) {
                data = randomSkateData;
                isCreativeTab = true;
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.45f, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-180.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            SKATEBOARD_MODEL.animateItem(data, f);
            if (isCreativeTab) {
                float lerpTicks = ticks;
                if (!Minecraft.m_91087_().m_91104_()) {
                    lerpTicks += Minecraft.m_91087_().m_91296_();
                }
                SKATEBOARD_MODEL.animateCreativeTab(lerpTicks);
            }
            if (itemStack.m_150930_((Item)IWSItemRegistry.SKATEBOARD_DECK.get())) {
                SkateboardTexturer.renderDeck(SKATEBOARD_MODEL, data, poseStack, bufferIn, combinedLightIn, itemStack.m_41790_());
            } else {
                SkateboardTexturer.renderBoard(SKATEBOARD_MODEL, data, poseStack, bufferIn, combinedLightIn, itemStack.m_41790_());
            }
            poseStack.m_85849_();
        }
    }

    static {
        ticks = 0;
        randomSource = RandomSource.m_216337_();
    }
}

