/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.render.entity;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.client.model.ModelPartType;
import com.github.alexthe668.iwannaskate.client.model.ModelPartWrapper;
import com.github.alexthe668.iwannaskate.client.model.ModelRootRegistry;
import com.github.alexthe668.iwannaskate.client.render.entity.ModelPositions;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.entity.SkaterPose;
import com.github.alexthe668.iwannaskate.server.misc.IWSTags;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class SkatingModelPositioner {
    private static final List<ModelPositions> models = new ArrayList<ModelPositions>();
    private static final List<EntityModel> modelsNeedingRestoration = new ArrayList<EntityModel>();

    public static void setupSkaterRotations(LivingEntity livingEntity, EntityModel model, SkateboardEntity skateboard, PoseStack poseStack, float bodyYRot, float partialTick) {
        float poseProgress = skateboard.getSkaterPoseProgress(partialTick);
        float priorPoseProgress = 1.0f - poseProgress;
        SkatingModelPositioner.rotateForPose(livingEntity, model, poseStack, partialTick, skateboard, skateboard.getPrevSkaterPose(), priorPoseProgress);
        SkatingModelPositioner.rotateForPose(livingEntity, model, poseStack, partialTick, skateboard, skateboard.getSkaterPose(), poseProgress);
    }

    public static boolean doesChangeModel(LivingEntity entity) {
        return entity.m_20202_() instanceof SkateboardEntity;
    }

    public static void saveModel(EntityModel model) {
        if (!models.stream().anyMatch(modelPositions -> modelPositions.isFor(model)) && !(model instanceof AdvancedEntityModel)) {
            models.add(new ModelPositions(model));
        }
    }

    public static void restoreModel(EntityModel model) {
        if (model instanceof AdvancedEntityModel) {
            ((AdvancedEntityModel)model).resetToDefaultPose();
            return;
        }
        Optional<ModelPositions> optional = models.stream().filter(modelPositions -> modelPositions.isFor(model)).findAny();
        if (optional.isPresent()) {
            optional.get().resetDefaultPositions();
        }
    }

    public static void setupSkaterAnimations(EntityModel model, LivingEntity livingEntity, SkateboardEntity skateboard, float partialTicks) {
        if (!modelsNeedingRestoration.contains(model)) {
            modelsNeedingRestoration.add(model);
        }
        float poseProgress = skateboard.getSkaterPoseProgress(partialTicks);
        float priorPoseProgress = 1.0f - poseProgress;
        SkatingModelPositioner.animateForPose(model, livingEntity, partialTicks, skateboard, skateboard.getPrevSkaterPose(), priorPoseProgress);
        SkatingModelPositioner.animateForPose(model, livingEntity, partialTicks, skateboard, skateboard.getSkaterPose(), poseProgress);
    }

    private static void animateForPose(EntityModel model, LivingEntity skater, float partialTicks, SkateboardEntity skateboard, SkaterPose pose, float progress) {
        int leftMulti;
        ModelRootRegistry.SkateModelParts animationData = ModelRootRegistry.INSTANCE.getAnimationData(model, skater.m_6095_());
        float animStrength = 1.0f;
        float animSpeed = 1.0f;
        boolean faceForwards = false;
        if (animationData != null) {
            animStrength = animationData.strength();
            animSpeed = animationData.speed();
            faceForwards = animationData.faceForwards();
        }
        ModelPartWrapper[] body = ModelPartType.BODY.findIn((Entity)skater, model);
        ModelPartWrapper[] head = ModelPartType.HEAD.findIn((Entity)skater, model);
        ModelPartWrapper[] rightArm = ModelPartType.RIGHT_ARM.findIn((Entity)skater, model);
        ModelPartWrapper[] leftArm = ModelPartType.LEFT_ARM.findIn((Entity)skater, model);
        ModelPartWrapper[] rightLeg = ModelPartType.RIGHT_LEG.findIn((Entity)skater, model);
        ModelPartWrapper[] leftLeg = ModelPartType.LEFT_LEG.findIn((Entity)skater, model);
        float ageInTicks = (float)skater.f_19797_ + partialTicks;
        float pedalAmount = skateboard.getPedalAmount(partialTicks);
        boolean pedalFootLeft = SkatingModelPositioner.isPedalFootLeft(skater);
        boolean isBodyParentToLegs = Arrays.stream(body).anyMatch(ModelPartWrapper::isRoot);
        int n = leftMulti = pedalFootLeft ? -1 : 1;
        if (pose.isSideways() && !faceForwards) {
            SkatingModelPositioner.rotateModelPart(head, progress, 0.0f, (float)Math.toRadians(-70 * leftMulti), 0.0f);
        }
        if (skater.m_6095_().m_204039_(IWSTags.HAS_ZOMBIE_ARMS)) {
            SkatingModelPositioner.rotateModelPart(leftArm, progress, (float)Math.toRadians(45.0), 0.0f, 0.0f);
            SkatingModelPositioner.rotateModelPart(rightArm, progress, (float)Math.toRadians(45.0), 0.0f, 0.0f);
        }
        if (pose == SkaterPose.PEDAL) {
            float swing = (float)Math.sin(ageInTicks * 0.4f * animSpeed) * pedalAmount * animStrength;
            SkatingModelPositioner.positionModelPart(body, progress, 0.0f, 0.0f, 1.0f);
            SkatingModelPositioner.rotateModelPart(body, progress, (float)Math.toRadians(animStrength * 15.0f), 0.0f, 0.0f);
            if (isBodyParentToLegs) {
                SkatingModelPositioner.rotateModelPart(leftLeg, progress, (float)Math.toRadians(animStrength * -15.0f), 0.0f, 0.0f);
                SkatingModelPositioner.rotateModelPart(rightLeg, progress, (float)Math.toRadians(animStrength * -15.0f), 0.0f, 0.0f);
            }
            SkatingModelPositioner.rotateModelPart(leftArm, progress, (float)Math.toRadians(-35.0f - swing * 15.0f) * pedalAmount, (float)Math.toRadians(-5.0), (float)Math.toRadians(-10.0));
            SkatingModelPositioner.rotateModelPart(rightArm, progress, (float)Math.toRadians(-35.0f - swing * 15.0f) * pedalAmount, (float)Math.toRadians(5.0), (float)Math.toRadians(10.0));
            if (pedalFootLeft) {
                if (!isBodyParentToLegs) {
                    SkatingModelPositioner.positionModelPart(leftLeg, progress, 0.0f, -Math.abs(swing * 3.0f), 1.0f + Math.abs(swing * 2.0f));
                    SkatingModelPositioner.positionModelPart(rightLeg, progress, 0.0f, -3.0f, 2.0f);
                }
                SkatingModelPositioner.rotateModelPart(leftLeg, progress, (float)Math.toRadians(15.0f - swing * 70.0f), 0.0f, 0.0f);
                SkatingModelPositioner.rotateModelPart(rightLeg, progress, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
            } else {
                if (!isBodyParentToLegs) {
                    SkatingModelPositioner.positionModelPart(rightLeg, progress, 0.0f, -Math.abs(swing * 3.0f), 1.0f + Math.abs(swing * 2.0f));
                    SkatingModelPositioner.positionModelPart(leftLeg, progress, 0.0f, -3.0f, 2.0f);
                }
                SkatingModelPositioner.rotateModelPart(rightLeg, progress, (float)Math.toRadians(15.0f - swing * 70.0f), 0.0f, 0.0f);
                SkatingModelPositioner.rotateModelPart(leftLeg, progress, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
            }
        } else if (pose == SkaterPose.CROUCH) {
            SkatingModelPositioner.rotateModelPart(body, progress, (float)Math.toRadians(35.0), 0.0f, 0.0f);
            SkatingModelPositioner.rotateModelPart(head, progress, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
            SkatingModelPositioner.rotateModelPart(rightLeg, progress, (float)Math.toRadians(-15.0), 0.0f, (float)Math.toRadians(25.0));
            SkatingModelPositioner.rotateModelPart(leftLeg, progress, (float)Math.toRadians(-15.0), 0.0f, (float)Math.toRadians(-25.0));
            SkatingModelPositioner.rotateModelPart(rightArm, progress, 0.0f, (float)Math.toRadians(65.0), (float)Math.toRadians(65.0));
            SkatingModelPositioner.rotateModelPart(leftArm, progress, 0.0f, (float)Math.toRadians(-65.0), (float)Math.toRadians(-65.0));
            if (!isBodyParentToLegs) {
                SkatingModelPositioner.positionModelPart(rightLeg, progress, 0.0f, -3.0f, 6.0f);
                SkatingModelPositioner.positionModelPart(leftLeg, progress, 0.0f, -3.0f, 6.0f);
            } else {
                SkatingModelPositioner.positionModelPart(body, progress, 0.0f, 0.0f, -6.0f);
            }
        } else if (pose == SkaterPose.OLLIE) {
            if (!isBodyParentToLegs) {
                SkatingModelPositioner.positionModelPart(rightLeg, progress, 0.0f, -3.0f, 5.0f);
                SkatingModelPositioner.positionModelPart(leftLeg, progress, 0.0f, -3.0f, 5.0f);
            }
            SkatingModelPositioner.rotateModelPart(body, progress, (float)Math.toRadians(30.0), (float)Math.toRadians(-10.0), 0.0f);
            SkatingModelPositioner.rotateModelPart(head, progress, (float)Math.toRadians(-30.0), (float)Math.toRadians(-40.0), 0.0f);
            if (pedalFootLeft) {
                SkatingModelPositioner.rotateModelPart(leftLeg, progress, 0.0f, 0.0f, (float)Math.toRadians(-45.0));
                SkatingModelPositioner.rotateModelPart(rightLeg, progress, 0.0f, 0.0f, (float)Math.toRadians(-15.0));
                SkatingModelPositioner.rotateModelPart(rightArm, progress, 0.0f, (float)Math.toRadians(65.0), (float)Math.toRadians(100.0));
                SkatingModelPositioner.rotateModelPart(leftArm, progress, 0.0f, (float)Math.toRadians(-65.0), (float)Math.toRadians(-115.0));
            } else {
                SkatingModelPositioner.rotateModelPart(leftLeg, progress, 0.0f, 0.0f, (float)Math.toRadians(15.0));
                SkatingModelPositioner.rotateModelPart(rightLeg, progress, 0.0f, 0.0f, (float)Math.toRadians(45.0));
                SkatingModelPositioner.rotateModelPart(rightArm, progress, 0.0f, (float)Math.toRadians(65.0), (float)Math.toRadians(115.0));
                SkatingModelPositioner.rotateModelPart(leftArm, progress, 0.0f, (float)Math.toRadians(-65.0), (float)Math.toRadians(-100.0));
            }
        } else if (pose == SkaterPose.KICKFLIP) {
            SkatingModelPositioner.rotateModelPart(body, progress, (float)Math.toRadians(45.0), 0.0f, 0.0f);
            if (pedalFootLeft) {
                if (!isBodyParentToLegs) {
                    SkatingModelPositioner.positionModelPart(rightLeg, progress, 0.0f, -4.0f, 8.0f);
                    SkatingModelPositioner.positionModelPart(leftLeg, progress, 0.0f, -4.0f, 4.0f);
                }
                SkatingModelPositioner.rotateModelPart(rightLeg, progress, (float)Math.toRadians(-35.0), (float)Math.toRadians(5.0), (float)Math.toRadians(35.0));
                SkatingModelPositioner.rotateModelPart(leftLeg, progress, (float)Math.toRadians(25.0), 0.0f, (float)Math.toRadians(-25.0));
                SkatingModelPositioner.rotateModelPart(leftArm, progress, 0.0f, (float)Math.toRadians(-65.0), (float)Math.toRadians(-100.0));
                SkatingModelPositioner.rotateModelPart(rightArm, progress, 0.0f, (float)Math.toRadians(65.0), (float)Math.toRadians(80.0));
            } else {
                if (!isBodyParentToLegs) {
                    SkatingModelPositioner.positionModelPart(rightLeg, progress, 0.0f, -4.0f, 4.0f);
                    SkatingModelPositioner.positionModelPart(leftLeg, progress, 0.0f, -4.0f, 8.0f);
                }
                SkatingModelPositioner.rotateModelPart(leftLeg, progress, (float)Math.toRadians(-35.0), (float)Math.toRadians(-5.0), (float)Math.toRadians(-35.0));
                SkatingModelPositioner.rotateModelPart(rightLeg, progress, (float)Math.toRadians(25.0), 0.0f, (float)Math.toRadians(25.0));
                SkatingModelPositioner.rotateModelPart(rightArm, progress, 0.0f, (float)Math.toRadians(65.0), (float)Math.toRadians(100.0));
                SkatingModelPositioner.rotateModelPart(leftArm, progress, 0.0f, (float)Math.toRadians(-65.0), (float)Math.toRadians(-80.0));
            }
        } else if (pose == SkaterPose.GRIND) {
            SkatingModelPositioner.rotateModelPart(body, progress, (float)Math.toRadians(15.0), 0.0f, 0.0f);
            SkatingModelPositioner.rotateModelPart(head, progress, (float)Math.toRadians(15.0), 0.0f, 0.0f);
            SkatingModelPositioner.rotateModelPart(rightLeg, progress, (float)Math.toRadians(-25 * leftMulti), 0.0f, 0.0f);
            SkatingModelPositioner.rotateModelPart(leftLeg, progress, (float)Math.toRadians(25 * leftMulti), 0.0f, 0.0f);
            if (!isBodyParentToLegs) {
                SkatingModelPositioner.positionModelPart(rightLeg, progress, 0.0f, -1.0f, 2.0f);
                SkatingModelPositioner.positionModelPart(leftLeg, progress, 0.0f, -1.0f, 2.0f);
            }
            if (pedalFootLeft) {
                SkatingModelPositioner.rotateModelPart(leftArm, progress, (float)Math.toRadians(-50.0), (float)Math.toRadians(-20.0), (float)Math.toRadians(-30.0));
                SkatingModelPositioner.rotateModelPart(rightArm, progress, (float)Math.toRadians(70.0), (float)Math.toRadians(-20.0), (float)Math.toRadians(30.0));
            } else {
                SkatingModelPositioner.rotateModelPart(rightArm, progress, (float)Math.toRadians(-50.0), (float)Math.toRadians(20.0), (float)Math.toRadians(30.0));
                SkatingModelPositioner.rotateModelPart(leftArm, progress, (float)Math.toRadians(70.0), (float)Math.toRadians(20.0), (float)Math.toRadians(-30.0));
            }
        }
    }

    private static boolean isPedalFootLeft(LivingEntity skater) {
        return (Boolean)IWannaSkateMod.CLIENT_CONFIG.invertSide.get() == (skater.m_5737_() != HumanoidArm.LEFT);
    }

    public static void rotateCapeForPose(AbstractClientPlayer player, PoseStack poseStack, float partialTicks, SkateboardEntity skateboard, SkaterPose pose, float progress) {
        boolean pedalFootLeft = SkatingModelPositioner.isPedalFootLeft((LivingEntity)player);
        Vec3 trail = skateboard.m_20184_();
        float f = (float)Math.pow(trail.m_82553_(), 0.5);
        float f1 = pedalFootLeft ? -1.0f : 1.0f;
        float maxUp = 70.0f;
        if (pose == SkaterPose.NONE) {
            poseStack.m_252880_(0.0f, 0.0f, 0.125f * progress);
            poseStack.m_252781_(Axis.f_252495_.m_252977_(15.0f * progress));
        }
        if (pose == SkaterPose.PEDAL) {
            poseStack.m_252880_(0.0f, 0.0f, 0.125f * progress);
            poseStack.m_252781_(Axis.f_252495_.m_252977_(25.0f * progress));
        }
        if (pose.isSideways()) {
            float swing = (float)(Math.sin(((float)player.f_19797_ + partialTicks) * 0.2f) + 1.0) * 0.5f;
            poseStack.m_252880_(0.0f, f * 0.1f * progress, 0.0f);
            poseStack.m_252781_(Axis.f_252392_.m_252977_((60.0f + 20.0f * swing) * progress));
            poseStack.m_252781_(Axis.f_252393_.m_252977_(f1 * (f * 30.0f + 35.0f) * progress));
            maxUp = 105.0f;
        }
        float flap = (float)(Math.cos(((float)player.f_19797_ + partialTicks) * 0.2f) + 1.0) * 0.5f;
        poseStack.m_252781_(Axis.f_252495_.m_252977_(Mth.m_14036_((float)f, (float)0.0f, (float)1.0f) * (maxUp + 20.0f * flap) * progress));
    }

    private static void rotateForPose(LivingEntity skater, EntityModel model, PoseStack stack, float partialTicks, SkateboardEntity skateboard, SkaterPose pose, float progress) {
        int leftMulti;
        ModelRootRegistry.SkateModelParts animationData = ModelRootRegistry.INSTANCE.getAnimationData(model, skater.m_6095_());
        boolean pedalFootLeft = SkatingModelPositioner.isPedalFootLeft(skater);
        int n = leftMulti = pedalFootLeft ? -1 : 1;
        if (pose.useBoardPitch()) {
            float f = skateboard.m_5686_(partialTicks) * progress;
            stack.m_252781_(Axis.f_252495_.m_252977_(f));
            stack.m_252880_(0.0f, -0.33f * (float)Math.sin(Math.toRadians(f)), 0.0f);
        }
        if (pose.useBoardRoll()) {
            float yDif = Mth.m_14177_((float)(skateboard.m_5675_(partialTicks) - skater.f_20883_));
            float moving = Mth.m_14036_((float)(1.0f - Math.abs(yDif) / 90.0f), (float)1.0f, (float)1.0f);
            stack.m_252781_(Axis.f_252393_.m_252977_(skateboard.getZRot(partialTicks) * progress * moving));
        }
        if (pose.isSideways() && (animationData == null || !animationData.faceForwards())) {
            stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f * progress * (float)leftMulti));
        }
        if (pose == SkaterPose.PEDAL && progress > 0.0f) {
            float up = (float)Math.sin(Math.toRadians(skateboard.m_5686_(partialTicks))) * skateboard.getOnGroundProgress(partialTicks);
            stack.m_252880_((0.2f + 0.05f * (1.0f - up)) * progress * (float)leftMulti, (-0.2f + up * 0.1f) * progress, (-0.1f + up * -0.6f) * progress);
        } else if (pose == SkaterPose.CROUCH) {
            stack.m_252880_(0.0f, -0.25f * progress, -0.15f * progress * (float)leftMulti);
        } else if (pose == SkaterPose.OLLIE) {
            stack.m_252880_(-0.4f * progress, 0.0f, -0.35f * progress * (float)leftMulti);
            stack.m_252781_(Axis.f_252393_.m_252977_(20.0f * progress));
        } else if (pose == SkaterPose.KICKFLIP) {
            stack.m_252880_(0.1f * progress, -0.4f * progress, -0.1f * progress * (float)leftMulti);
            stack.m_252781_(Axis.f_252495_.m_252977_(10.0f * progress));
        } else if (pose == SkaterPose.GRIND) {
            stack.m_252880_(0.0f, -0.2f * progress, -0.2f * progress * (float)leftMulti);
            stack.m_252781_(Axis.f_252495_.m_252977_(-15.0f * progress));
        }
    }

    private static void rotateModelPart(ModelPartWrapper[] parts, float progress, float x, float y, float z) {
        for (ModelPartWrapper model : parts) {
            ModelPart part = model.getModelPart();
            AdvancedModelBox box = model.getAdvancedModelBox();
            if (part != null) {
                part.f_104203_ += progress * x;
                part.f_104204_ += progress * y;
                part.f_104205_ += progress * z;
            }
            if (box == null) continue;
            box.rotateAngleX += progress * x;
            box.rotateAngleY += progress * y;
            box.rotateAngleZ += progress * z;
        }
    }

    private static void positionModelPart(ModelPartWrapper[] parts, float progress, float x, float y, float z) {
        for (ModelPartWrapper model : parts) {
            ModelPart part = model.getModelPart();
            AdvancedModelBox box = model.getAdvancedModelBox();
            if (part != null) {
                part.f_104200_ += progress * x;
                part.f_104201_ += progress * y;
                part.f_104202_ += progress * z;
            }
            if (box == null) continue;
            box.rotationPointX += progress * x;
            box.rotationPointY += progress * y;
            box.rotationPointZ += progress * z;
        }
    }
}

